/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.da.comp.w2lcommon.helper;

import com.sun.star.awt.XControl;
import com.sun.star.awt.XControlContainer;
import com.sun.star.awt.XControlModel;
import com.sun.star.awt.XDialog;
import com.sun.star.beans.XPropertySet;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.Date;

public class DialogAccess {
    private XDialog xDialog = null;
    public static final short CHECKBOX_NOT_CHECKED = 0;
    public static final short CHECKBOX_CHECKED = 1;
    public static final short CHECKBOX_DONT_KNOW = 2;

    public DialogAccess(XDialog xDialog) {
        this.xDialog = xDialog;
    }

    protected void setDialog(XDialog xDialog) {
        this.xDialog = xDialog;
    }

    protected XDialog getDialog() {
        return this.xDialog;
    }

    public XPropertySet getControlProperties(String sControlName) {
        XControlContainer xContainer = (XControlContainer)UnoRuntime.queryInterface(XControlContainer.class, (Object)this.xDialog);
        XControl xControl = xContainer.getControl(sControlName);
        XControlModel xModel = xControl.getModel();
        XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)xModel);
        return xPropertySet;
    }

    public boolean getControlEnabled(String sControlName) {
        XPropertySet xPropertySet = this.getControlProperties(sControlName);
        try {
            return (Boolean)xPropertySet.getPropertyValue("Enabled");
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setControlEnabled(String sControlName, boolean bEnabled) {
        XPropertySet xPropertySet = this.getControlProperties(sControlName);
        try {
            xPropertySet.setPropertyValue("Enabled", (Object)new Boolean(bEnabled));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public short getCheckBoxState(String sControlName) {
        XPropertySet xPropertySet = this.getControlProperties(sControlName);
        try {
            return (Short)xPropertySet.getPropertyValue("State");
        }
        catch (Exception e) {
            return 2;
        }
    }

    public boolean getCheckBoxStateAsBoolean(String sControlName) {
        return this.getCheckBoxState(sControlName) == 1;
    }

    public void setCheckBoxState(String sControlName, short nState) {
        XPropertySet xPropertySet = this.getControlProperties(sControlName);
        try {
            xPropertySet.setPropertyValue("State", (Object)new Short(nState));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setCheckBoxStateAsBoolean(String sControlName, boolean bChecked) {
        this.setCheckBoxState(sControlName, bChecked ? (short)1 : 0);
    }

    public String[] getListBoxStringItemList(String sControlName) {
        XPropertySet xPropertySet = this.getControlProperties(sControlName);
        try {
            return (String[])xPropertySet.getPropertyValue("StringItemList");
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    public void setListBoxStringItemList(String sControlName, String[] items) {
        XPropertySet xPropertySet = this.getControlProperties(sControlName);
        try {
            xPropertySet.setPropertyValue("StringItemList", (Object)items);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public short getListBoxSelectedItem(String sControlName) {
        XPropertySet xPropertySet = this.getControlProperties(sControlName);
        try {
            short[] selection = (short[])xPropertySet.getPropertyValue("SelectedItems");
            return selection[0];
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void setListBoxSelectedItem(String sControlName, short nIndex) {
        XPropertySet xPropertySet = this.getControlProperties(sControlName);
        try {
            short[] selection = new short[]{nIndex};
            xPropertySet.setPropertyValue("SelectedItems", (Object)selection);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public short getListBoxLineCount(String sControlName) {
        XPropertySet xPropertySet = this.getControlProperties(sControlName);
        try {
            return (Short)xPropertySet.getPropertyValue("LineCount");
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setListBoxLineCount(String sControlName, short nLineCount) {
        XPropertySet xPropertySet = this.getControlProperties(sControlName);
        try {
            xPropertySet.setPropertyValue("LineCount", (Object)new Short(nLineCount));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getComboBoxText(String sControlName) {
        XPropertySet xPropertySet = this.getControlProperties(sControlName);
        try {
            return (String)xPropertySet.getPropertyValue("Text");
        }
        catch (Exception e) {
            return "";
        }
    }

    public void setComboBoxText(String sControlName, String sText) {
        XPropertySet xPropertySet = this.getControlProperties(sControlName);
        try {
            xPropertySet.setPropertyValue("Text", (Object)sText);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getLabelText(String sControlName) {
        XPropertySet xPropertySet = this.getControlProperties(sControlName);
        try {
            return (String)xPropertySet.getPropertyValue("Label");
        }
        catch (Exception e) {
            return "";
        }
    }

    public void setLabelText(String sControlName, String sLabel) {
        XPropertySet xPropertySet = this.getControlProperties(sControlName);
        try {
            xPropertySet.setPropertyValue("Label", (Object)sLabel);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getTextFieldText(String sControlName) {
        XPropertySet xPropertySet = this.getControlProperties(sControlName);
        try {
            return (String)xPropertySet.getPropertyValue("Text");
        }
        catch (Exception e) {
            return "";
        }
    }

    public void setTextFieldText(String sControlName, String sText) {
        XPropertySet xPropertySet = this.getControlProperties(sControlName);
        try {
            xPropertySet.setPropertyValue("Text", (Object)sText);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getFormattedFieldText(String sControlName) {
        XPropertySet xPropertySet = this.getControlProperties(sControlName);
        try {
            return (String)xPropertySet.getPropertyValue("Text");
        }
        catch (Exception e) {
            return "";
        }
    }

    public void setFormattedFieldText(String sControlName, String sText) {
        XPropertySet xPropertySet = this.getControlProperties(sControlName);
        try {
            xPropertySet.setPropertyValue("Text", (Object)sText);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getDateFieldValue(String sControlName) {
        XPropertySet xPropertySet = this.getControlProperties(sControlName);
        try {
            Object dateObject = xPropertySet.getPropertyValue("Date");
            if (dateObject instanceof Date) {
                Date date = (Date)dateObject;
                return 10000 * date.Year + 100 * date.Month + date.Day;
            }
            if (dateObject instanceof Integer) {
                return (Integer)dateObject;
            }
            return 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setDateFieldValue(String sControlName, int nValue) {
        XPropertySet xPropertySet = this.getControlProperties(sControlName);
        Date date = new Date();
        date.Year = (short)(nValue / 10000);
        date.Month = (short)(nValue % 10000 / 100);
        date.Day = (short)(nValue % 100);
        try {
            xPropertySet.setPropertyValue("Date", (Object)date);
        }
        catch (Exception e) {
            try {
                xPropertySet.setPropertyValue("Date", (Object)nValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getNumericFieldValue(String sControlName) {
        XPropertySet xPropertySet = this.getControlProperties(sControlName);
        try {
            return ((Double)xPropertySet.getPropertyValue("Value")).intValue();
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setNumericFieldValue(String sControlName, int nValue) {
        XPropertySet xPropertySet = this.getControlProperties(sControlName);
        try {
            xPropertySet.setPropertyValue("Value", (Object)new Double(nValue));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

