/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.mapping.DocValuesPropertyBase;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.PropertyVariant;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class IpProperty
extends DocValuesPropertyBase
implements PropertyVariant,
ToCopyableBuilder<Builder, IpProperty> {
    @Nullable
    private final Double boost;
    @Nullable
    private final Boolean ignoreMalformed;
    @Nullable
    private final Boolean index;
    @Nullable
    private final String nullValue;
    public static final JsonpDeserializer<IpProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IpProperty::setupIpPropertyDeserializer);

    private IpProperty(Builder builder) {
        super(builder);
        this.boost = builder.boost;
        this.ignoreMalformed = builder.ignoreMalformed;
        this.index = builder.index;
        this.nullValue = builder.nullValue;
    }

    public static IpProperty of(Function<Builder, ObjectBuilder<IpProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.Ip;
    }

    @Nullable
    public final Double boost() {
        return this.boost;
    }

    @Nullable
    public final Boolean ignoreMalformed() {
        return this.ignoreMalformed;
    }

    @Nullable
    public final Boolean index() {
        return this.index;
    }

    @Nullable
    public final String nullValue() {
        return this.nullValue;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "ip");
        super.serializeInternal(generator, mapper);
        if (this.boost != null) {
            generator.writeKey("boost");
            generator.write(this.boost.doubleValue());
        }
        if (this.ignoreMalformed != null) {
            generator.writeKey("ignore_malformed");
            generator.write(this.ignoreMalformed.booleanValue());
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index.booleanValue());
        }
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            generator.write(this.nullValue);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIpPropertyDeserializer(ObjectDeserializer<Builder> op) {
        IpProperty.setupDocValuesPropertyBaseDeserializer(op);
        op.add(Builder::boost, JsonpDeserializer.doubleDeserializer(), "boost");
        op.add(Builder::ignoreMalformed, JsonpDeserializer.booleanDeserializer(), "ignore_malformed");
        op.add(Builder::index, JsonpDeserializer.booleanDeserializer(), "index");
        op.add(Builder::nullValue, JsonpDeserializer.stringDeserializer(), "null_value");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.boost);
        result = 31 * result + Objects.hashCode(this.ignoreMalformed);
        result = 31 * result + Objects.hashCode(this.index);
        result = 31 * result + Objects.hashCode(this.nullValue);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IpProperty other = (IpProperty)o;
        return Objects.equals(this.boost, other.boost) && Objects.equals(this.ignoreMalformed, other.ignoreMalformed) && Objects.equals(this.index, other.index) && Objects.equals(this.nullValue, other.nullValue);
    }

    public static class Builder
    extends DocValuesPropertyBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, IpProperty> {
        @Nullable
        private Double boost;
        @Nullable
        private Boolean ignoreMalformed;
        @Nullable
        private Boolean index;
        @Nullable
        private String nullValue;

        public Builder() {
        }

        private Builder(IpProperty o) {
            super(o);
            this.boost = o.boost;
            this.ignoreMalformed = o.ignoreMalformed;
            this.index = o.index;
            this.nullValue = o.nullValue;
        }

        private Builder(Builder o) {
            super(o);
            this.boost = o.boost;
            this.ignoreMalformed = o.ignoreMalformed;
            this.index = o.index;
            this.nullValue = o.nullValue;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder boost(@Nullable Double value) {
            this.boost = value;
            return this;
        }

        @Nonnull
        public final Builder ignoreMalformed(@Nullable Boolean value) {
            this.ignoreMalformed = value;
            return this;
        }

        @Nonnull
        public final Builder index(@Nullable Boolean value) {
            this.index = value;
            return this;
        }

        @Nonnull
        public final Builder nullValue(@Nullable String value) {
            this.nullValue = value;
            return this;
        }

        @Override
        @Nonnull
        public IpProperty build() {
            this._checkSingleUse();
            return new IpProperty(this);
        }
    }
}

