/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.annotation.constraint.Live;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.util.IndexedXMLObjectChildrenList;
import org.opensaml.saml.common.AbstractSignableSAMLObject;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml1.core.Advice;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.AttributeStatement;
import org.opensaml.saml.saml1.core.AuthenticationStatement;
import org.opensaml.saml.saml1.core.AuthorizationDecisionStatement;
import org.opensaml.saml.saml1.core.Conditions;
import org.opensaml.saml.saml1.core.Statement;
import org.opensaml.saml.saml1.core.SubjectStatement;
import org.opensaml.xmlsec.signature.Signature;

public class AssertionImpl
extends AbstractSignableSAMLObject
implements Assertion {
    @Nullable
    private String id;
    @Nullable
    private SAMLVersion version;
    @Nullable
    private String issuer;
    @Nullable
    private Instant issueInstant;
    @Nullable
    private Conditions conditions;
    @Nullable
    private Advice advice;
    @Nonnull
    private final IndexedXMLObjectChildrenList<Statement> statements = new IndexedXMLObjectChildrenList(this);

    protected AssertionImpl(@Nullable String namespaceURI, @Nonnull String elementLocalName, @Nullable String namespacePrefix) {
        super(namespaceURI, elementLocalName, namespacePrefix);
        this.version = SAMLVersion.VERSION_11;
    }

    @Override
    @Nullable
    public Integer getMajorVersion() {
        return this.version != null ? Integer.valueOf(this.version.getMajorVersion()) : null;
    }

    @Override
    @Nullable
    public Integer getMinorVersion() {
        return this.version != null ? Integer.valueOf(this.version.getMinorVersion()) : null;
    }

    @Override
    @Nullable
    public SAMLVersion getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(@Nullable SAMLVersion newVersion) {
        this.version = this.prepareForAssignment(this.version, newVersion);
    }

    @Override
    @Nullable
    public String getID() {
        return this.id;
    }

    @Override
    public void setID(@Nullable String newID) {
        String oldID = this.id;
        this.id = this.prepareForAssignment(this.id, newID);
        this.registerOwnID(oldID, this.id);
    }

    @Override
    @Nullable
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    public void setIssuer(@Nullable String iss) {
        this.issuer = this.prepareForAssignment(this.issuer, iss);
    }

    @Override
    @Nullable
    public Instant getIssueInstant() {
        return this.issueInstant;
    }

    @Override
    public void setIssueInstant(@Nullable Instant instant) {
        this.issueInstant = this.prepareForAssignment(this.issueInstant, instant);
    }

    @Override
    @Nullable
    public Conditions getConditions() {
        return this.conditions;
    }

    @Override
    public void setConditions(@Nullable Conditions c) {
        this.conditions = this.prepareForAssignment(this.conditions, c);
    }

    @Override
    @Nullable
    public Advice getAdvice() {
        return this.advice;
    }

    @Override
    public void setAdvice(@Nullable Advice adv) {
        this.advice = this.prepareForAssignment(this.advice, adv);
    }

    @Override
    @Nonnull
    @Live
    public List<Statement> getStatements() {
        return this.statements;
    }

    @Override
    @Nonnull
    @Live
    public List<Statement> getStatements(@Nonnull QName typeOrName) {
        return this.statements.subList(typeOrName);
    }

    @Override
    @Nonnull
    @Live
    public List<SubjectStatement> getSubjectStatements() {
        QName statementQName = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "SubjectStatement");
        return this.statements.subList(statementQName);
    }

    @Override
    @Nonnull
    @Live
    public List<AuthenticationStatement> getAuthenticationStatements() {
        QName statementQName = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AuthenticationStatement");
        return this.statements.subList(statementQName);
    }

    @Override
    @Nonnull
    @Live
    public List<AttributeStatement> getAttributeStatements() {
        QName statementQName = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AttributeStatement");
        return this.statements.subList(statementQName);
    }

    @Override
    @Nonnull
    @Live
    public List<AuthorizationDecisionStatement> getAuthorizationDecisionStatements() {
        QName statementQName = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AuthorizationDecisionStatement");
        return this.statements.subList(statementQName);
    }

    @Override
    @Nullable
    public String getSignatureReferenceID() {
        return this.id;
    }

    @Override
    @Nullable
    @NotLive
    @Unmodifiable
    public List<XMLObject> getOrderedChildren() {
        ArrayList<XMLObject> children = new ArrayList<XMLObject>();
        if (this.conditions != null) {
            children.add(this.conditions);
        }
        if (this.advice != null) {
            children.add(this.advice);
        }
        children.addAll(this.statements);
        Signature sig = this.getSignature();
        if (sig != null) {
            children.add(sig);
        }
        return CollectionSupport.copyToList(children);
    }
}

