/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.List;
import org.assertj.core.error.MessageFormatter;

public class AssertionErrorMessagesAggregator {
    public static String aggregateErrorMessages(List<String> errors) {
        StringBuilder msg = new StringBuilder("%nThe following ");
        AssertionErrorMessagesAggregator.countAssertions(errors, msg);
        msg.append(" failed:%n");
        for (int i2 = 0; i2 < errors.size(); ++i2) {
            msg.append(i2 + 1).append(") ").append(errors.get(i2)).append("%n");
        }
        return MessageFormatter.instance().format(null, null, msg.toString(), new Object[0]);
    }

    private static void countAssertions(List<String> errors, StringBuilder msg) {
        int size = errors.size();
        if (size == 1) {
            msg.append("assertion");
        } else {
            msg.append(size).append(" assertions");
        }
    }
}

