/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee;

import com.intellij.application.options.PathMacrosImpl;
import com.intellij.application.options.ReplacePathToMacroMap;
import com.intellij.javaee.ExternalResource;
import com.intellij.javaee.ExternalResourceListener;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.javaee.ExternalResourceManagerExBaseKt;
import com.intellij.javaee.ResourceRegistrar;
import com.intellij.javaee.ResourceRegistrarImpl;
import com.intellij.javaee.StandardResourceEP;
import com.intellij.javaee.StandardResourceProvider;
import com.intellij.javaee.XMLCatalogManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.extensions.LazyExtension;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.concurrency.SynchronizedClearableLazy;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.XmlSchemaProvider;
import com.intellij.xml.util.XmlUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="ExternalResourceManagerImpl", storages={@Storage(value="javaeeExternalResources.xml")}, category=SettingsCategory.CODE)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \\2\u00020\u00012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002:\u0001\\B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J%\u0010\u001f\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00160\u000b0\u0015H\u0010\u00a2\u0006\u0002\b J\b\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\nH\u0016J\u001f\u0010(\u001a\u00020\n2\u000b\u0010)\u001a\u00070\n\u00a2\u0006\u0002\b*2\b\u0010+\u001a\u0004\u0018\u00010\nH\u0016J$\u0010,\u001a\u0004\u0018\u00010\n2\u0006\u0010-\u001a\u00020.2\u0006\u0010)\u001a\u00020\n2\b\u0010+\u001a\u0004\u0018\u00010\nH\u0016J\u001c\u0010/\u001a\u0004\u0018\u00010\n2\u0006\u0010)\u001a\u00020\n2\b\u0010+\u001a\u0004\u0018\u00010\nH\u0016J\u001c\u0010,\u001a\u0004\u0018\u00010\n2\u0006\u0010)\u001a\u00020\n2\b\u0010+\u001a\u0004\u0018\u00010\nH\u0002J\u001f\u0010(\u001a\u0004\u0018\u00010\n2\u000b\u0010)\u001a\u00070\n\u00a2\u0006\u0002\b*2\u0006\u0010-\u001a\u00020.H\u0016J)\u0010(\u001a\u0004\u0018\u00010\n2\u000b\u0010)\u001a\u00070\n\u00a2\u0006\u0002\b*2\b\u0010+\u001a\u0004\u0018\u00010\n2\u0006\u0010-\u001a\u00020.H\u0002J)\u0010(\u001a\u0004\u0018\u0001002\u000b\u0010)\u001a\u00070\n\u00a2\u0006\u0002\b*2\u0006\u00101\u001a\u0002002\b\u0010+\u001a\u0004\u0018\u00010\nH\u0016J'\u00102\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n032\b\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020$H\u0016\u00a2\u0006\u0002\u00107J6\u00102\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n032\b\u00104\u001a\u0004\u0018\u0001052\r\u0010+\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b*2\u0006\u00106\u001a\u00020$H\u0016\u00a2\u0006\u0002\u00108J\u0018\u00109\u001a\u00020\"2\u0006\u0010)\u001a\u00020\n2\u0006\u0010:\u001a\u00020\nH\u0016J1\u00109\u001a\u00020\"2\u000b\u0010)\u001a\u00070\n\u00a2\u0006\u0002\b*2\r\u0010+\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b*2\u000b\u0010:\u001a\u00070\n\u00a2\u0006\u0002\b*H\u0016J\"\u0010;\u001a\u00020\"2\u0006\u0010)\u001a\u00020\n2\b\u0010+\u001a\u0004\u0018\u00010\n2\u0006\u0010:\u001a\u00020\nH\u0002J\u0010\u0010<\u001a\u00020\"2\u0006\u0010)\u001a\u00020\nH\u0016J\u001a\u0010<\u001a\u00020\"2\u0006\u0010)\u001a\u00020\n2\b\u0010+\u001a\u0004\u0018\u00010\nH\u0016J\u0018\u0010<\u001a\u00020\"2\u0006\u0010)\u001a\u00020\n2\u0006\u0010-\u001a\u00020.H\u0016J*\u00109\u001a\u00020\"2\u000b\u0010)\u001a\u00070\n\u00a2\u0006\u0002\b*2\u000b\u0010:\u001a\u00070\n\u00a2\u0006\u0002\b*2\u0006\u0010-\u001a\u00020.H\u0016J\u0015\u0010=\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n03H\u0016\u00a2\u0006\u0002\u0010>J\u001d\u0010=\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n032\u0006\u0010-\u001a\u00020.H\u0016\u00a2\u0006\u0002\u0010?J\b\u0010@\u001a\u00020\"H\u0016J\u0010\u0010@\u001a\u00020\"2\u0006\u0010-\u001a\u00020.H\u0016J \u0010A\u001a\u00020\"2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\n0C2\b\u0010D\u001a\u0004\u0018\u00010EH\u0016J \u0010F\u001a\u00020\"2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\n0C2\b\u0010D\u001a\u0004\u0018\u00010EH\u0002J\u0010\u0010G\u001a\u00020\"2\u0006\u0010)\u001a\u00020\nH\u0002J\u0010\u0010H\u001a\u00020$2\u0006\u0010)\u001a\u00020\nH\u0016J\u0015\u0010I\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n03H\u0016\u00a2\u0006\u0002\u0010>J\u0010\u0010J\u001a\u00020K2\u0006\u0010-\u001a\u00020.H\u0016J\n\u0010L\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u0010M\u001a\u00020\"2\u0006\u0010N\u001a\u00020\u0003H\u0016J\b\u0010O\u001a\u00020\"H\u0002J\u001f\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00160\u000b0PH\u0000\u00a2\u0006\u0002\bQJ\u0010\u0010R\u001a\u00020\n2\u0006\u0010-\u001a\u00020.H\u0016J\u0018\u0010S\u001a\u00020\"2\u0006\u0010\u0019\u001a\u00020\n2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010T\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.H\u0016J\u0018\u0010U\u001a\u00020\"2\u0006\u0010+\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.H\u0016J\n\u0010V\u001a\u0004\u0018\u00010\nH\u0016J\u0012\u0010W\u001a\u00020\"2\b\u0010X\u001a\u0004\u0018\u00010\nH\u0016J\u001e\u0010Y\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010Z2\u0006\u0010-\u001a\u00020.H\u0016J\n\u0010[\u001a\u0004\u0018\u00010\u001eH\u0002J\u0012\u0010S\u001a\u00020\"2\b\u0010\u0019\u001a\u0004\u0018\u00010\nH\u0002R&\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000e\u001a&\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\n0\n \u0010*\u0012\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\n0\n\u0018\u00010\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0012\u001a&\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\n0\n \u0010*\u0012\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\n0\n\u0018\u00010\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0013\u001a \u0012\u001c\u0012\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00160\u000b0\u00150\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"Lcom/intellij/javaee/ExternalResourceManagerExBase;", "Lcom/intellij/javaee/ExternalResourceManagerEx;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "resources", "Ljava/util/HashMap;", "", "", "resourceLocations", "Ljava/util/HashSet;", "ignoredResources", "", "kotlin.jvm.PlatformType", "", "standardIgnoredResources", "standardResources", "Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "", "Lcom/intellij/javaee/ExternalResource;", "getStandardResources", "()Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "defaultHtmlDoctype", "xmlSchemaVersion", "Lcom/intellij/javaee/ExternalResourceManagerEx$XMLSchemaVersion;", "myCatalogPropertiesFile", "myCatalogManager", "Lcom/intellij/javaee/XMLCatalogManager;", "computeStdResources", "computeStdResources$intellij_xml_psi_impl", "dropCache", "", "isStandardResource", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isUserResource", "getResourceLocation", "url", "Lorg/jetbrains/annotations/NonNls;", "version", "getUserResource", "project", "Lcom/intellij/openapi/project/Project;", "getStdResource", "Lcom/intellij/psi/PsiFile;", "baseFile", "getResourceUrls", "", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "includeStandard", "(Lcom/intellij/openapi/fileTypes/FileType;Z)[Ljava/lang/String;", "(Lcom/intellij/openapi/fileTypes/FileType;Ljava/lang/String;Z)[Ljava/lang/String;", "addResource", "location", "addSilently", "removeResource", "getAvailableUrls", "()[Ljava/lang/String;", "(Lcom/intellij/openapi/project/Project;)[Ljava/lang/String;", "clearAllResources", "addIgnoredResources", "urls", "", "disposable", "Lcom/intellij/openapi/Disposable;", "doAddIgnoredResources", "addIgnoredSilently", "isIgnoredResource", "getIgnoredResources", "getModificationCount", "", "getState", "loadState", "state", "fireExternalResourceChanged", "", "getStandardResources$intellij_xml_psi_impl", "getDefaultHtmlDoctype", "setDefaultHtmlDoctype", "getXmlSchemaVersion", "setXmlSchemaVersion", "getCatalogPropertiesFile", "setCatalogPropertiesFile", "filePath", "getUrlsByNamespace", "Lcom/intellij/util/containers/MultiMap;", "getCatalogManager", "Companion", "intellij.xml.psi.impl"})
public class ExternalResourceManagerExBase
extends ExternalResourceManagerEx
implements PersistentStateComponent<Element> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<String, Map<String, String>> resources;
    @NotNull
    private final HashSet<String> resourceLocations;
    private final Set<String> ignoredResources;
    private final Set<String> standardIgnoredResources;
    @NotNull
    private final SynchronizedClearableLazy<Map<String, Map<String, ExternalResource>>> standardResources;
    @Nullable
    private String defaultHtmlDoctype;
    @NotNull
    private ExternalResourceManagerEx.XMLSchemaVersion xmlSchemaVersion;
    @Nullable
    private String myCatalogPropertiesFile;
    @Nullable
    private XMLCatalogManager myCatalogManager;
    @NotNull
    public static final String J2EE_1_3 = "http://java.sun.com/dtd/";
    @NotNull
    public static final String J2EE_1_2 = "http://java.sun.com/j2ee/dtds/";
    @NotNull
    public static final String J2EE_NS = "http://java.sun.com/xml/ns/j2ee/";
    @NotNull
    public static final String JAVAEE_NS = "http://java.sun.com/xml/ns/javaee/";
    @NotNull
    public static final String JCP_NS = "http://xmlns.jcp.org/xml/ns/javaee/";
    @NotNull
    public static final String JAKARTA_NS = "https://jakarta.ee/xml/ns/jakartaee/";

    public ExternalResourceManagerExBase(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.resources = new HashMap();
        this.resourceLocations = new HashSet();
        this.ignoredResources = Collections.synchronizedSet(new TreeSet());
        this.standardIgnoredResources = Collections.synchronizedSet(new TreeSet());
        this.standardResources = new SynchronizedClearableLazy(() -> ExternalResourceManagerExBase.standardResources$lambda$0(this));
        this.defaultHtmlDoctype = "HTML5";
        this.xmlSchemaVersion = ExternalResourceManagerEx.XMLSchemaVersion.XMLSchema_1_0;
        StandardResourceProvider.EP_NAME.addChangeListener(coroutineScope, this::dropCache);
        StandardResourceEP.EP_NAME.addChangeListener(coroutineScope, this::dropCache);
    }

    @NotNull
    protected final SynchronizedClearableLazy<Map<String, Map<String, ExternalResource>>> getStandardResources() {
        return this.standardResources;
    }

    @NotNull
    public Map<String, Map<String, ExternalResource>> computeStdResources$intellij_xml_psi_impl() {
        ResourceRegistrarImpl registrar = new ResourceRegistrarImpl();
        for (StandardResourceProvider provider : StandardResourceProvider.EP_NAME.lazySequence()) {
            provider.registerResources((ResourceRegistrar)registrar);
        }
        for (LazyExtension item : StandardResourceEP.EP_NAME.filterableLazySequence()) {
            StandardResourceEP extension;
            if ((StandardResourceEP)item.getInstance() == null) continue;
            String string = extension.url;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"url");
            String string2 = extension.version;
            String string3 = extension.resourcePath;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"resourcePath");
            registrar.addStdResource(string, string2, string3, null, item.getPluginDescriptor().getPluginClassLoader());
        }
        this.standardIgnoredResources.clear();
        this.standardIgnoredResources.addAll((Collection<String>)registrar.getIgnoredResources());
        return registrar.getResources();
    }

    private final void dropCache() {
        this.standardResources.drop();
        this.incModificationCount();
    }

    @Override
    public boolean isStandardResource(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile parent = file.getParent();
        return parent != null && Intrinsics.areEqual((Object)parent.getName(), (Object)"standardSchemas");
    }

    @Override
    public boolean isUserResource(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.resourceLocations.contains(file.getUrl());
    }

    @NotNull
    public String getResourceLocation(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.getResourceLocation(url, "");
    }

    @NotNull
    public String getResourceLocation(@NotNull String url, @Nullable String version) {
        String result;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = version;
        if (string == null) {
            string = "";
        }
        if ((result = this.getUserResource(url, string)) == null) {
            XMLCatalogManager manager = this.getCatalogManager();
            if (manager != null) {
                result = manager.resolve(url);
            }
            if (result == null && (result = this.getStdResource(url, version)) == null) {
                return url;
            }
        }
        return result;
    }

    @Override
    @Nullable
    public String getUserResource(@NotNull Project project, @NotNull String url, @Nullable String version) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = ExternalResourceManagerExBaseKt.access$getProjectResources(project).getUserResource(url, version);
        if (string == null) {
            string = this.getUserResource(url, version);
        }
        return string;
    }

    @Override
    @Nullable
    public String getStdResource(@NotNull String url, @Nullable String version) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Object object = ExternalResourceManagerExBaseKt.access$getMap((Map)this.standardResources.getValue(), version);
        return object != null && (object = (ExternalResource)object.get(url)) != null ? ((ExternalResource)object).getResourceUrl() : null;
    }

    private final String getUserResource(String url, String version) {
        Map map = ExternalResourceManagerExBaseKt.access$getMap(this.resources, version);
        return map != null ? (String)map.get(url) : null;
    }

    @Nullable
    public String getResourceLocation(@NotNull String url, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.getResourceLocation(url, null, project);
    }

    private final String getResourceLocation(String url, String version, Project project) {
        ExternalResourceManagerExBase projectResources = ExternalResourceManagerExBaseKt.access$getProjectResources(project);
        String location = projectResources.getResourceLocation(url, version);
        if (!Intrinsics.areEqual((Object)location, (Object)url)) {
            return location;
        }
        if (projectResources.xmlSchemaVersion == ExternalResourceManagerEx.XMLSchemaVersion.XMLSchema_1_1) {
            if (Intrinsics.areEqual((Object)"http://www.w3.org/2001/XMLSchema", (Object)url)) {
                return ExternalResourceManagerExBaseKt.access$getXSD_1_1$p();
            }
            if (Intrinsics.areEqual((Object)"http://www.w3.org/2001/XMLSchema.xsd", (Object)url)) {
                return ExternalResourceManagerExBaseKt.access$getXSD_1_1$p();
            }
        }
        return this.getResourceLocation(url, version);
    }

    @Nullable
    public PsiFile getResourceLocation(@NotNull String url, @NotNull PsiFile baseFile, @Nullable String version) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)baseFile, (String)"baseFile");
        XmlFile xmlFile = XmlSchemaProvider.Companion.findSchema(url, baseFile);
        if (xmlFile != null) {
            XmlFile it = xmlFile;
            boolean bl = false;
            return (PsiFile)it;
        }
        Project project = baseFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String string = this.getResourceLocation(url, version, project);
        Intrinsics.checkNotNull((Object)string);
        String location = string;
        return (PsiFile)XmlUtil.findXmlFile(baseFile, location);
    }

    @NotNull
    public String[] getResourceUrls(@Nullable FileType fileType, boolean includeStandard) {
        return this.getResourceUrls(fileType, "", includeStandard);
    }

    @NotNull
    public String[] getResourceUrls(@Nullable FileType fileType, @Nullable String version, boolean includeStandard) {
        LinkedList result = new LinkedList();
        ExternalResourceManagerExBaseKt.access$addResourcesFromMap(result, version, this.resources);
        if (includeStandard) {
            ExternalResourceManagerExBaseKt.access$addResourcesFromMap(result, version, (Map)this.standardResources.getValue());
        }
        String[] stringArray = ArrayUtilRt.toStringArray((Collection)result);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"toStringArray(...)");
        return stringArray;
    }

    public void addResource(@NotNull String url, @NotNull String location) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.addResource(url, "", location);
    }

    public void addResource(@NotNull String url, @Nullable String version, @NotNull String location) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        ThreadingAssertions.assertWriteAccess();
        this.addSilently(url, version, location);
        this.fireExternalResourceChanged();
    }

    private final void addSilently(String url, String version, String location) {
        Companion.getOrCreateMap$intellij_xml_psi_impl((Map)this.resources, version).put(url, location);
        this.resourceLocations.add(location);
        this.incModificationCount();
    }

    public void removeResource(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.removeResource(url, "");
    }

    public void removeResource(@NotNull String url, @Nullable String version) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        ThreadingAssertions.assertWriteAccess();
        Map map = ExternalResourceManagerExBaseKt.access$getMap(this.resources, version);
        if (map == null) {
            return;
        }
        Map map2 = map;
        String location = (String)map2.remove(url);
        if (location != null) {
            this.resourceLocations.remove(location);
        }
        this.incModificationCount();
        this.fireExternalResourceChanged();
    }

    @Override
    public void removeResource(@NotNull String url, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ExternalResourceManagerExBaseKt.access$getProjectResources(project).removeResource(url);
    }

    @Override
    public void addResource(@NotNull String url, @NotNull String location, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ExternalResourceManagerExBaseKt.access$getProjectResources(project).addResource(url, location);
    }

    @Override
    @NotNull
    public String[] getAvailableUrls() {
        Set urls = new HashSet();
        Iterator<Map<String, String>> iterator = this.resources.values().iterator();
        while (iterator.hasNext()) {
            Map<String, String> map;
            Intrinsics.checkNotNullExpressionValue(iterator.next(), (String)"next(...)");
            urls.addAll((Collection)map.keySet());
        }
        String[] stringArray = ArrayUtilRt.toStringArray((Collection)urls);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"toStringArray(...)");
        return stringArray;
    }

    @Override
    @NotNull
    public String[] getAvailableUrls(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ExternalResourceManagerExBaseKt.access$getProjectResources(project).getAvailableUrls();
    }

    @Override
    public void clearAllResources() {
        this.resources.clear();
        this.ignoredResources.clear();
    }

    @Override
    public void clearAllResources(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ThreadingAssertions.assertWriteAccess();
        this.clearAllResources();
        ExternalResourceManagerExBaseKt.access$getProjectResources(project).clearAllResources();
        this.incModificationCount();
        this.fireExternalResourceChanged();
    }

    @Override
    public void addIgnoredResources(@NotNull List<String> urls, @Nullable Disposable disposable) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        Application app = ApplicationManager.getApplication();
        if (app.isWriteAccessAllowed()) {
            this.doAddIgnoredResources(urls, disposable);
        } else {
            app.runWriteAction(() -> ExternalResourceManagerExBase.addIgnoredResources$lambda$0(this, urls, disposable));
        }
    }

    private final void doAddIgnoredResources(List<String> urls, Disposable disposable) {
        long modificationCount = this.getModificationCount();
        for (String url : urls) {
            this.addIgnoredSilently(url);
        }
        if (modificationCount != this.getModificationCount()) {
            if (disposable != null) {
                Disposer.register((Disposable)disposable, () -> ExternalResourceManagerExBase.doAddIgnoredResources$lambda$0(urls, this));
            }
            this.fireExternalResourceChanged();
        }
    }

    private final void addIgnoredSilently(String url) {
        if (this.standardIgnoredResources.contains(url)) {
            return;
        }
        if (this.ignoredResources.add(url)) {
            this.incModificationCount();
        }
    }

    @Override
    public boolean isIgnoredResource(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (this.ignoredResources.contains(url)) {
            return true;
        }
        this.standardResources.getValue();
        return this.standardIgnoredResources.contains(url) || ExternalResourceManagerExBaseKt.access$isImplicitNamespaceDescriptor(url);
    }

    @Override
    @NotNull
    public String[] getIgnoredResources() {
        this.standardResources.getValue();
        if (this.ignoredResources.isEmpty()) {
            String[] stringArray = ArrayUtilRt.toStringArray((Collection)this.standardIgnoredResources);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"toStringArray(...)");
            return stringArray;
        }
        Set set = new HashSet(this.ignoredResources.size() + this.standardIgnoredResources.size());
        Set<String> set2 = this.ignoredResources;
        Intrinsics.checkNotNullExpressionValue(set2, (String)"ignoredResources");
        set.addAll((Collection)set2);
        Set<String> set3 = this.standardIgnoredResources;
        Intrinsics.checkNotNullExpressionValue(set3, (String)"standardIgnoredResources");
        set.addAll((Collection)set3);
        String[] stringArray = ArrayUtilRt.toStringArray((Collection)set);
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"toStringArray(...)");
        return stringArray;
    }

    @Override
    public long getModificationCount(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ExternalResourceManagerExBaseKt.access$getProjectResources(project).getModificationCount();
    }

    @Nullable
    public Element getState() {
        Element e;
        Element element = new Element("state");
        TreeSet urls = new TreeSet();
        Iterator<Object> iterator = this.resources.values().iterator();
        while (iterator.hasNext()) {
            Map<String, String> map;
            Intrinsics.checkNotNullExpressionValue(iterator.next(), (String)"next(...)");
            urls.addAll(map.keySet());
        }
        Iterator iterator2 = urls.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        iterator = iterator2;
        while (iterator.hasNext()) {
            String url = (String)((Object)iterator.next());
            String location = this.getResourceLocation(url);
            Element e2 = new Element("resource");
            e2.setAttribute("url", url);
            e2.setAttribute("location", StringsKt.replace$default((String)location, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null));
            element.addContent(e2);
        }
        Set<String> set = this.standardIgnoredResources;
        Intrinsics.checkNotNullExpressionValue(set, (String)"standardIgnoredResources");
        this.ignoredResources.removeAll((Collection)set);
        for (String ignoredResource : this.ignoredResources) {
            Element e3 = new Element("ignored-resource");
            e3.setAttribute("url", ignoredResource);
            element.addContent(e3);
        }
        if (this.defaultHtmlDoctype != null && !Intrinsics.areEqual((Object)"HTML5", (Object)this.defaultHtmlDoctype)) {
            e = new Element("default-html-doctype");
            e.setText(this.defaultHtmlDoctype);
            element.addContent(e);
        }
        if (this.xmlSchemaVersion != ExternalResourceManagerEx.XMLSchemaVersion.XMLSchema_1_0) {
            e = new Element("xml-schema-version");
            e.setText(this.xmlSchemaVersion.toString());
            element.addContent(e);
        }
        if (this.myCatalogPropertiesFile != null) {
            Element properties = new Element("CATALOG_PROPERTIES");
            properties.setText(this.myCatalogPropertiesFile);
            element.addContent(properties);
        }
        ReplacePathToMacroMap macroReplacements = new ReplacePathToMacroMap();
        PathMacrosImpl.Companion.getInstanceEx().addMacroReplacements(macroReplacements);
        macroReplacements.substitute(element, SystemInfo.isFileSystemCaseSensitive);
        return element;
    }

    public void loadState(@NotNull Element state) {
        Element catalogElement;
        Element schemaElement;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ExpandMacroToPathMap macroExpands = new ExpandMacroToPathMap();
        PathMacrosImpl.Companion.getInstanceEx().addMacroExpands(macroExpands);
        macroExpands.substitute(state, SystemInfo.isFileSystemCaseSensitive);
        this.incModificationCount();
        for (Element element : state.getChildren("resource")) {
            String url;
            if (element.getAttributeValue("url") == null || !(((CharSequence)url).length() > 0)) continue;
            String string = element.getAttributeValue("location");
            Intrinsics.checkNotNull((Object)string);
            this.addSilently(url, "", StringsKt.replace$default((String)string, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null));
        }
        this.ignoredResources.clear();
        for (Element element : state.getChildren("ignored-resource")) {
            String string = element.getAttributeValue("url");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
            this.addIgnoredSilently(string);
        }
        Element child = state.getChild("default-html-doctype");
        if (child != null) {
            String text = child.getText();
            String string = FileUtil.toSystemIndependentName((String)text);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemIndependentName(...)");
            if (StringsKt.endsWith$default((String)string, (String)".jar!/resources/html5-schema/html5.rnc", (boolean)false, (int)2, null)) {
                text = "HTML5";
            }
            this.defaultHtmlDoctype = text;
        }
        if ((schemaElement = state.getChild("xml-schema-version")) != null) {
            String text = schemaElement.getText();
            ExternalResourceManagerEx.XMLSchemaVersion xMLSchemaVersion = this.xmlSchemaVersion = Intrinsics.areEqual((Object)ExternalResourceManagerEx.XMLSchemaVersion.XMLSchema_1_1.toString(), (Object)text) ? ExternalResourceManagerEx.XMLSchemaVersion.XMLSchema_1_1 : ExternalResourceManagerEx.XMLSchemaVersion.XMLSchema_1_0;
        }
        if ((catalogElement = state.getChild("CATALOG_PROPERTIES")) != null) {
            this.myCatalogPropertiesFile = catalogElement.getTextTrim();
        }
    }

    private final void fireExternalResourceChanged() {
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Topic<ExternalResourceListener> topic = ExternalResourceListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        ((ExternalResourceListener)messageBus.syncPublisher(topic)).externalResourceChanged();
        this.incModificationCount();
    }

    @NotNull
    public final Collection<Map<String, ExternalResource>> getStandardResources$intellij_xml_psi_impl() {
        return ((Map)this.standardResources.getValue()).values();
    }

    @Override
    @NotNull
    public String getDefaultHtmlDoctype(@NotNull Project project) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String doctype = ExternalResourceManagerExBaseKt.access$getProjectResources((Project)project).defaultHtmlDoctype;
        if (Intrinsics.areEqual((Object)"http://www.w3.org/1999/xhtml", (Object)doctype)) {
            String string2 = XmlUtil.XHTML4_SCHEMA_LOCATION;
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"XHTML4_SCHEMA_LOCATION");
        } else if (Intrinsics.areEqual((Object)"HTML5", (Object)doctype)) {
            String string3 = Html5SchemaProvider.getHtml5SchemaLocation();
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getHtml5SchemaLocation(...)");
        } else {
            String string4 = doctype;
            string = string4;
            Intrinsics.checkNotNull((Object)string4);
        }
        return string;
    }

    @Override
    public void setDefaultHtmlDoctype(@NotNull String defaultHtmlDoctype, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)defaultHtmlDoctype, (String)"defaultHtmlDoctype");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ExternalResourceManagerExBaseKt.access$getProjectResources(project).setDefaultHtmlDoctype(defaultHtmlDoctype);
    }

    @Override
    @NotNull
    public ExternalResourceManagerEx.XMLSchemaVersion getXmlSchemaVersion(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ExternalResourceManagerExBaseKt.access$getProjectResources((Project)project).xmlSchemaVersion;
    }

    @Override
    public void setXmlSchemaVersion(@NotNull ExternalResourceManagerEx.XMLSchemaVersion version, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)((Object)version), (String)"version");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ExternalResourceManagerExBaseKt.access$getProjectResources((Project)project).xmlSchemaVersion = version;
        this.fireExternalResourceChanged();
    }

    @Override
    @Nullable
    public String getCatalogPropertiesFile() {
        return this.myCatalogPropertiesFile;
    }

    @Override
    public void setCatalogPropertiesFile(@Nullable String filePath) {
        this.myCatalogManager = null;
        this.myCatalogPropertiesFile = filePath;
        this.incModificationCount();
    }

    @Override
    @Nullable
    public MultiMap<String, String> getUrlsByNamespace(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return new MultiMap();
    }

    private final XMLCatalogManager getCatalogManager() {
        if (this.myCatalogManager == null && this.myCatalogPropertiesFile != null) {
            String string = this.myCatalogPropertiesFile;
            Intrinsics.checkNotNull((Object)string);
            this.myCatalogManager = new XMLCatalogManager(string);
        }
        return this.myCatalogManager;
    }

    private final void setDefaultHtmlDoctype(String defaultHtmlDoctype) {
        this.incModificationCount();
        this.defaultHtmlDoctype = Intrinsics.areEqual((Object)Html5SchemaProvider.getHtml5SchemaLocation(), (Object)defaultHtmlDoctype) ? "HTML5" : defaultHtmlDoctype;
        this.fireExternalResourceChanged();
    }

    private static final Map standardResources$lambda$0(ExternalResourceManagerExBase this$0) {
        return this$0.computeStdResources$intellij_xml_psi_impl();
    }

    private static final void addIgnoredResources$lambda$0(ExternalResourceManagerExBase this$0, List $urls, Disposable $disposable) {
        this$0.doAddIgnoredResources($urls, $disposable);
    }

    private static final void doAddIgnoredResources$lambda$0(List $urls, ExternalResourceManagerExBase this$0) {
        ApplicationManager.getApplication().runWriteAction(() -> ExternalResourceManagerExBase.doAddIgnoredResources$lambda$0$0($urls, this$0));
    }

    private static final void doAddIgnoredResources$lambda$0$0(List $urls, ExternalResourceManagerExBase this$0) {
        boolean isChanged = false;
        for (String url : $urls) {
            if (!this$0.ignoredResources.remove(url)) continue;
            isChanged = true;
        }
        if (isChanged) {
            this$0.fireExternalResourceChanged();
        }
    }

    @JvmStatic
    @TestOnly
    public static final void registerResourceTemporarily(@NotNull String url, @NotNull String location, @NotNull Disposable disposable) {
        Companion.registerResourceTemporarily(url, location, disposable);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JI\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u000e0\r\"\u0004\b\u0000\u0010\u000e2\u001e\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u000e0\r0\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u0000\u00a2\u0006\u0002\b\u0011J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/javaee/ExternalResourceManagerExBase$Companion;", "", "<init>", "()V", "J2EE_1_3", "", "Lorg/jetbrains/annotations/NonNls;", "J2EE_1_2", "J2EE_NS", "JAVAEE_NS", "JCP_NS", "JAKARTA_NS", "getOrCreateMap", "", "T", "resources", "version", "getOrCreateMap$intellij_xml_psi_impl", "registerResourceTemporarily", "", "url", "location", "disposable", "Lcom/intellij/openapi/Disposable;", "intellij.xml.psi.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> Map<String, T> getOrCreateMap$intellij_xml_psi_impl(@NotNull Map<String, Map<String, T>> resources, @Nullable String version) {
            Intrinsics.checkNotNullParameter(resources, (String)"resources");
            String string = version;
            if (string == null) {
                string = "";
            }
            Map map = resources.computeIfAbsent(string, arg_0 -> Companion.getOrCreateMap$lambda$1(Companion::getOrCreateMap$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"computeIfAbsent(...)");
            return map;
        }

        @JvmStatic
        @TestOnly
        public final void registerResourceTemporarily(@NotNull String url, @NotNull String location, @NotNull Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            Application app = ApplicationManager.getApplication();
            app.runWriteAction(() -> Companion.registerResourceTemporarily$lambda$0(url, location));
            Disposer.register((Disposable)disposable, () -> Companion.registerResourceTemporarily$lambda$1(app, url));
        }

        private static final Map getOrCreateMap$lambda$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new HashMap();
        }

        private static final Map getOrCreateMap$lambda$1(Function1 $tmp0, Object p0) {
            return (Map)$tmp0.invoke(p0);
        }

        private static final void registerResourceTemporarily$lambda$0(String $url, String $location) {
            ExternalResourceManagerEx.getInstance().addResource($url, $location);
        }

        private static final void registerResourceTemporarily$lambda$1(Application $app, String $url) {
            $app.runWriteAction(() -> Companion.registerResourceTemporarily$lambda$1$0($url));
        }

        private static final void registerResourceTemporarily$lambda$1$0(String $url) {
            ExternalResourceManagerEx.getInstance().removeResource($url);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

