/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.api.endpoint;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import org.apache.solr.client.api.model.BackupDeletionResponseBody;
import org.apache.solr.client.api.model.PurgeUnusedFilesRequestBody;
import org.apache.solr.client.api.model.PurgeUnusedResponse;

@Path(value="/backups/{backupName}")
public interface DeleteCollectionBackupApi {
    @Path(value="/versions/{backupId}")
    @DELETE
    @Operation(summary="Delete incremental backup point by ID", tags={"collection-backups"})
    public BackupDeletionResponseBody deleteSingleBackupById(@PathParam(value="backupName") String var1, @PathParam(value="backupId") String var2, @QueryParam(value="location") String var3, @QueryParam(value="repository") String var4, @QueryParam(value="async") String var5) throws Exception;

    @Path(value="/versions")
    @DELETE
    @Operation(summary="Delete all incremental backup points older than the most recent N", tags={"collection-backups"})
    public BackupDeletionResponseBody deleteMultipleBackupsByRecency(@PathParam(value="backupName") String var1, @QueryParam(value="retainLatest") Integer var2, @QueryParam(value="location") String var3, @QueryParam(value="repository") String var4, @QueryParam(value="async") String var5) throws Exception;

    @Path(value="/purgeUnused")
    @PUT
    @Operation(summary="Garbage collect orphaned incremental backup files", tags={"collection-backups"})
    public PurgeUnusedResponse garbageCollectUnusedBackupFiles(@PathParam(value="backupName") String var1, @RequestBody(description="Request body parameters for the orphaned file cleanup", required=false) PurgeUnusedFilesRequestBody var2) throws Exception;
}

