/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.sql;

import java.util.HashMap;
import java.util.Map;
import org.apache.sis.util.iso.Types;

final class TableHierarchy {
    static final char TYPE_OPEN = '{';
    static final char TYPE_CLOSE = '}';
    private static final Map<String, String> ABBREVIATIONS = new HashMap<String, String>(25);
    private static final Map<String, String> TABLES = new HashMap<String, String>(25);

    private static void add(String string, String string2) {
        ABBREVIATIONS.put(string, string2);
        TABLES.put(string2, string);
    }

    private TableHierarchy() {
    }

    static String encode(String string, String string2) {
        string = ABBREVIATIONS.getOrDefault(string, string);
        return '{' + string + '}' + string2;
    }

    static Class<?> subType(Class<?> clazz, String string) {
        int n;
        if (string.charAt(0) == '{' && (n = string.indexOf(125)) >= 0) {
            String string2 = string.substring(1, n);
            Class<?> clazz2 = Types.forStandardName(string2 = TABLES.getOrDefault(string2, string2));
            if (clazz2 != null && clazz.isAssignableFrom(clazz2)) {
                clazz = clazz2;
            }
        }
        return clazz;
    }

    static {
        TableHierarchy.add("Individual", "ind");
        TableHierarchy.add("Organisation", "org");
        TableHierarchy.add("ResponsibleParty", "rp");
        TableHierarchy.add("VectorSpatialRepresentation", "vec");
        TableHierarchy.add("GridSpatialRepresentation", "grd");
        TableHierarchy.add("Georectified", "rtf");
        TableHierarchy.add("Georeferenceable", "cbl");
        TableHierarchy.add("DataIdentification", "data");
        TableHierarchy.add("ServiceIdentification", "srv");
        TableHierarchy.add("FeatureCatalogueDescription", "cat");
        TableHierarchy.add("CoverageDescription", "cov");
        TableHierarchy.add("ImageDescription", "img");
        TableHierarchy.add("SampleDimension", "sd");
        TableHierarchy.add("Band", "band");
        TableHierarchy.add("LegalConstraints", "legal");
        TableHierarchy.add("SecurityConstraints", "secu");
        TableHierarchy.add("GeographicBoundingBox", "bbox");
        TableHierarchy.add("BoundingPolygon", "poly");
        TableHierarchy.add("GeographicDescription", "gdsc");
        TableHierarchy.add("SpatialTemporalExtent", "ste");
        TableHierarchy.add("GCPCollection", "gcp");
    }
}

