/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.catalina.TrackedWebResource;
import org.apache.catalina.WebResourceRoot;

class TrackedInputStream
extends InputStream
implements TrackedWebResource {
    private final WebResourceRoot root;
    private final String name;
    private final InputStream is;
    private final Exception creation;

    TrackedInputStream(WebResourceRoot webResourceRoot, String string, InputStream inputStream) {
        this.root = webResourceRoot;
        this.name = string;
        this.is = inputStream;
        this.creation = new Exception();
        webResourceRoot.registerTrackedResource(this);
    }

    @Override
    public int read() throws IOException {
        return this.is.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.is.read(byArray);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.is.read(byArray, n, n2);
    }

    @Override
    public long skip(long l) throws IOException {
        return this.is.skip(l);
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    @Override
    public void close() throws IOException {
        this.root.deregisterTrackedResource(this);
        this.is.close();
    }

    @Override
    public synchronized void mark(int n) {
        this.is.mark(n);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.is.reset();
    }

    @Override
    public boolean markSupported() {
        return this.is.markSupported();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Exception getCreatedBy() {
        return this.creation;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        stringWriter.append('[');
        stringWriter.append(this.name);
        stringWriter.append(']');
        stringWriter.append(System.lineSeparator());
        this.creation.printStackTrace(printWriter);
        printWriter.flush();
        return stringWriter.toString();
    }
}

