/*
 * Decompiled with CFR 0.152.
 */
package viz.panel;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.RoundRectangle2D;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import viz.util.Util;

public class ExpandablePanel
extends JPanel {
    static Image DOWN_ICON;
    static Image LEFT_ICON;
    private static final long serialVersionUID = 1L;
    public JPanel m_panel;
    String m_sLabel;
    DropDownButton editButton;

    public ExpandablePanel(String sLabel, JPanel panel) {
        try {
            URL downURL = ClassLoader.getSystemResource("viz/icons/down.png");
            DOWN_ICON = ImageIO.read(downURL);
            URL leftURL = ClassLoader.getSystemResource("viz/icons/left.png");
            LEFT_ICON = ImageIO.read(leftURL);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.m_sLabel = sLabel;
        this.m_panel = panel;
        panel.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.editButton = new DropDownButton(sLabel);
        String name = panel.getClass().getName();
        name = name.substring(name.lastIndexOf(46) + 1);
        this.setName(name);
        this.editButton.setName(String.valueOf(name) + "Button");
        Dimension size = Util.isMac() ? new Dimension(200, 20) : new Dimension(150, 20);
        this.editButton.setPreferredSize(size);
        this.editButton.addActionListener(e -> {
            boolean isVisible = this.m_panel.isVisible();
            this.m_panel.setVisible(!isVisible);
            this.editButton.setOpen(!isVisible);
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc_btnLoadLocations = new GridBagConstraints();
        gbc_btnLoadLocations.gridwidth = 1;
        gbc_btnLoadLocations.gridx = 0;
        gbc_btnLoadLocations.gridy = 0;
        this.add((Component)this.editButton, gbc_btnLoadLocations);
        GridBagConstraints gbc_panel = new GridBagConstraints();
        gbc_panel.fill = 2;
        gbc_panel.gridx = 0;
        gbc_panel.gridy = 1;
        gbc_panel.gridwidth = 1;
        this.add((Component)panel, gbc_panel);
        panel.setVisible(false);
    }

    public class DropDownButton
    extends JButton
    implements MouseListener {
        private static final long serialVersionUID = 1L;
        boolean mouseIn;
        boolean isOpen;
        String label;

        void setOpen(boolean isOpen) {
            this.isOpen = isOpen;
            this.repaint();
        }

        public DropDownButton(String label) {
            super(label);
            this.mouseIn = false;
            this.isOpen = false;
            this.label = label;
            this.setBorderPainted(false);
            this.addMouseListener(this);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            if (this.getModel().isPressed()) {
                g.setColor(g.getColor());
                g2.fillRect(3, 3, this.getWidth() - 6, this.getHeight() - 6);
            }
            g2.setFont(Font.getFont("Dialog"));
            super.paintComponent(g);
            int x = 5;
            int y = 3;
            if (this.isOpen) {
                int w = DOWN_ICON.getWidth(null);
                int h = DOWN_ICON.getHeight(null);
                g.drawImage(DOWN_ICON, x, y, x + w, y + h, 0, 0, w, h, null);
            } else {
                int w = LEFT_ICON.getWidth(null);
                int h = LEFT_ICON.getHeight(null);
                g.drawImage(LEFT_ICON, x, y, x + w, y + h, 0, 0, w, h, null);
            }
            if (this.mouseIn) {
                g2.setColor(Color.darkGray);
            } else {
                g2.setColor(new Color(128, 128, 128));
            }
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setStroke(new BasicStroke(1.2f));
            g2.draw(new RoundRectangle2D.Double(1.0, 1.0, this.getWidth() - 3, this.getHeight() - 3, 12.0, 8.0));
            g2.setStroke(new BasicStroke(1.5f));
            g2.drawLine(4, this.getHeight() - 3, this.getWidth() - 4, this.getHeight() - 3);
            g2.dispose();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.mouseIn = true;
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.mouseIn = false;
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

