/*
 * Decompiled with CFR 0.152.
 */
package beast.app.draw;

import beast.app.beauti.BeautiDoc;
import beast.app.beauti.BeautiPanel;
import beast.app.beauti.BeautiPanelConfig;
import beast.app.draw.InputEditor;
import beast.app.draw.ListInputEditor;
import beast.app.draw.SmallLabel;
import beast.core.BEASTInterface;
import beast.core.Input;
import beast.core.util.Log;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionListener;

public class DoubleListInputEditor
extends ListInputEditor {
    private static final long serialVersionUID = 1L;
    protected Input<?> m_input;
    protected BEASTInterface m_beastObject;
    protected JTextField m_entry;
    protected int itemNr;
    JLabel m_inputLabel;
    protected static Dimension PREFERRED_SIZE = new Dimension(200, 25);
    protected static Dimension MAX_SIZE = new Dimension(1024, 25);
    protected boolean m_bAddButtons = true;
    protected SmallLabel m_validateLabel;
    protected BeautiDoc doc;
    List<InputEditor> m_validateListeners;

    public DoubleListInputEditor(BeautiDoc beautiDoc) {
        super(beautiDoc);
    }

    @Override
    public Class<?> type() {
        return List.class;
    }

    @Override
    public Class<?> baseType() {
        return Double.class;
    }

    @Override
    protected void initEntry() {
        if (this.m_input.get() != null) {
            String string = "";
            for (Double d : (List)this.m_input.get()) {
                string = string + d + " ";
            }
            string = string.substring(0, string.length() - 1);
            this.m_entry.setText(string);
        }
    }

    @Override
    public JTextField getEntry() {
        return this.m_entry;
    }

    @Override
    public void addValidationListener(InputEditor inputEditor) {
        if (this.m_validateListeners == null) {
            this.m_validateListeners = new ArrayList<InputEditor>();
        }
        this.m_validateListeners.add(inputEditor);
    }

    @Override
    public void notifyValidationListeners(InputEditor.ValidationStatus validationStatus) {
        if (this.m_validateListeners != null) {
            for (InputEditor inputEditor : this.m_validateListeners) {
                inputEditor.startValidating(validationStatus);
            }
        }
    }

    @Override
    protected BeautiDoc getDoc() {
        if (this.doc == null) {
            Container container = this;
            while (container.getParent() != null) {
                if (!((container = container.getParent()) instanceof BeautiPanel)) continue;
                this.doc = ((BeautiPanel)container).getDoc();
            }
        }
        return this.doc;
    }

    @Override
    public Class<?>[] types() {
        Class[] classArray = new Class[]{this.type()};
        return classArray;
    }

    @Override
    public void init(Input<?> input, BEASTInterface bEASTInterface, int n, InputEditor.ExpandOption expandOption, boolean bl) {
        this.m_bAddButtons = bl;
        this.m_input = input;
        this.m_beastObject = bEASTInterface;
        this.itemNr = n;
        this.addInputLabel();
        this.setUpEntry();
        this.add(this.m_entry);
        this.add(Box.createHorizontalGlue());
        this.addValidationLabel();
    }

    @Override
    void setUpEntry() {
        this.m_entry = new JTextField();
        this.m_entry.setName(this.m_input.getName());
        int n = this.m_entry.getFont().getSize();
        PREFERRED_SIZE = new Dimension(200, 25 * n / 13);
        this.m_entry.setMinimumSize(PREFERRED_SIZE);
        this.m_entry.setPreferredSize(PREFERRED_SIZE);
        this.m_entry.setSize(PREFERRED_SIZE);
        this.initEntry();
        this.m_entry.setToolTipText(this.m_input.getHTMLTipText());
        this.m_entry.setMaximumSize(new Dimension(1024, 25 * n / 13));
        this.m_entry.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                DoubleListInputEditor.this.processEntry();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                DoubleListInputEditor.this.processEntry();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                DoubleListInputEditor.this.processEntry();
            }
        });
    }

    @Override
    protected void setValue(Object object) {
        if (this.itemNr < 0) {
            this.m_input.setValue(object, this.m_beastObject);
        } else {
            List list = (List)this.m_input.get();
            Object e = list.get(this.itemNr);
            if (e != object) {
                if (e instanceof BEASTInterface) {
                    BEASTInterface.getOutputs(e).remove(this.m_beastObject);
                }
                list.set(this.itemNr, object);
                if (object instanceof BEASTInterface) {
                    BEASTInterface.getOutputs(object).add(this.m_beastObject);
                }
            }
        }
    }

    @Override
    protected void processEntry() {
        try {
            this.setValue(this.m_entry.getText());
            this.validateInput();
            this.m_entry.requestFocusInWindow();
        }
        catch (Exception exception) {
            if (this.m_validateLabel != null) {
                this.m_validateLabel.setVisible(true);
                this.m_validateLabel.setToolTipText("<html><p>Parsing error: " + exception.getMessage() + ". Value was left at " + this.m_input.get() + ".</p></html>");
                this.m_validateLabel.m_circleColor = Color.orange;
            }
            this.repaint();
        }
    }

    @Override
    protected void addInputLabel() {
        if (this.m_bAddButtons) {
            String string = this.formatName(this.m_input.getName());
            this.addInputLabel(string, this.m_input.getHTMLTipText());
        }
    }

    @Override
    protected String formatName(String string) {
        if (this.doc.beautiConfig.inputLabelMap.containsKey(this.m_beastObject.getClass().getName() + "." + string)) {
            string = this.doc.beautiConfig.inputLabelMap.get(this.m_beastObject.getClass().getName() + "." + string);
        } else {
            string = string.replaceAll("([a-z])([A-Z])", "$1 $2");
            string = string.substring(0, 1).toUpperCase() + string.substring(1);
        }
        return string;
    }

    @Override
    protected void addInputLabel(String string, String string2) {
        if (this.m_bAddButtons) {
            this.m_inputLabel = new JLabel(string);
            this.m_inputLabel.setToolTipText(string2);
            this.m_inputLabel.setHorizontalTextPosition(4);
            int n = this.m_inputLabel.getFont().getSize();
            Dimension dimension = new Dimension(200, 20 * n / 13);
            this.m_inputLabel.setMaximumSize(dimension);
            this.m_inputLabel.setMinimumSize(dimension);
            this.m_inputLabel.setPreferredSize(dimension);
            this.m_inputLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            this.add(this.m_inputLabel);
        }
    }

    @Override
    protected void addValidationLabel() {
        if (this.m_bAddButtons) {
            this.m_validateLabel = new SmallLabel("x", new Color(200, 0, 0));
            this.add(this.m_validateLabel);
            this.m_validateLabel.setVisible(true);
            this.validateInput();
        }
    }

    @Override
    protected void validateAllEditors() {
        for (InputEditor inputEditor : this.doc.currentInputEditors) {
            inputEditor.validateInput();
        }
    }

    @Override
    public void validateInput() {
        try {
            this.m_input.validate();
            if (this.m_entry != null && !this.m_input.canSetValue(this.m_entry.getText(), this.m_beastObject)) {
                throw new IllegalArgumentException("invalid value");
            }
            try {
                this.validateRecursively(this.m_input, new HashSet());
            }
            catch (Exception exception) {
                this.notifyValidationListeners(InputEditor.ValidationStatus.HAS_INVALIDMEMBERS);
                if (this.m_validateLabel != null) {
                    this.m_validateLabel.setVisible(true);
                    this.m_validateLabel.setToolTipText("<html><p>Recursive error in " + exception.getMessage() + "</p></html>");
                    this.m_validateLabel.m_circleColor = Color.orange;
                }
                this.repaint();
                return;
            }
            if (this.m_validateLabel != null) {
                this.m_validateLabel.setVisible(false);
            }
            this.notifyValidationListeners(InputEditor.ValidationStatus.IS_VALID);
        }
        catch (Exception exception) {
            Log.warning.println("Validation message: " + exception.getMessage());
            if (this.m_validateLabel != null) {
                this.m_validateLabel.setToolTipText(exception.getMessage());
                this.m_validateLabel.m_circleColor = Color.red;
                this.m_validateLabel.setVisible(true);
            }
            this.notifyValidationListeners(InputEditor.ValidationStatus.IS_INVALID);
        }
        this.repaint();
    }

    @Override
    void validateRecursively(Input<?> input, Set<Input<?>> set) {
        if (set.contains(input)) {
            return;
        }
        set.add(input);
        if (input.get() != null) {
            if (input.get() instanceof BEASTInterface) {
                BEASTInterface bEASTInterface = (BEASTInterface)input.get();
                for (Input<?> object : bEASTInterface.listInputs()) {
                    try {
                        object.validate();
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException(((BEASTInterface)input.get()).getID() + "</p><p> " + exception.getMessage());
                    }
                    this.validateRecursively(object, set);
                }
            }
            if (input.get() instanceof List) {
                for (Iterator<Input<Object>> iterator : (List)input.get()) {
                    if (iterator == null || !(iterator instanceof BEASTInterface)) continue;
                    BEASTInterface bEASTInterface = (BEASTInterface)((Object)iterator);
                    for (Input<?> input2 : bEASTInterface.listInputs()) {
                        try {
                            input2.validate();
                        }
                        catch (Exception exception) {
                            throw new IllegalArgumentException(((BEASTInterface)((Object)iterator)).getID() + " " + exception.getMessage());
                        }
                        this.validateRecursively(input2, set);
                    }
                }
            }
        }
    }

    @Override
    public void startValidating(InputEditor.ValidationStatus validationStatus) {
        this.validateInput();
    }

    @Override
    public void refreshPanel() {
        Container container = this;
        while (container.getParent() != null) {
            if (!((container = container.getParent()) instanceof ListSelectionListener)) continue;
            ((ListSelectionListener)((Object)container)).valueChanged(null);
        }
    }

    @Override
    protected void sync() {
        Container container = this;
        while (container.getParent() != null) {
            if (!((container = container.getParent()) instanceof BeautiPanel)) continue;
            BeautiPanel beautiPanel = (BeautiPanel)container;
            BeautiPanelConfig beautiPanelConfig = beautiPanel.config;
            beautiPanelConfig.sync(beautiPanel.partitionIndex);
        }
    }

    @Override
    @Deprecated
    public void setBorder(Border border) {
        super.setBorder(border);
    }

    @Override
    public void setDoc(BeautiDoc beautiDoc) {
        this.doc = beautiDoc;
    }

    @Override
    @Deprecated
    public void repaint() {
        this.repaint(0L);
        super.repaint();
    }

    @Override
    public Component getComponent() {
        return this;
    }
}

