/*
 * Decompiled with CFR 0.152.
 */
package beast.app.treeannotator;

import beast.app.treeannotator.FileDrop;
import beast.app.treeannotator.RealNumberField;
import beast.app.treeannotator.TreeAnnotator;
import beast.app.util.WholeNumberField;
import jam.panels.OptionsPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;

public class TreeAnnotatorDialog {
    private JFrame frame;
    private OptionsPanel optionPanel;
    private WholeNumberField burninText = new WholeNumberField(0, Integer.MAX_VALUE);
    private RealNumberField limitText = new RealNumberField(0.0, 1.0);
    private JComboBox<TreeAnnotator.Target> summaryTreeCombo = new JComboBox<TreeAnnotator.Target>(TreeAnnotator.Target.values());
    private JComboBox<TreeAnnotator.HeightsSummary> nodeHeightsCombo = new JComboBox<TreeAnnotator.HeightsSummary>(TreeAnnotator.HeightsSummary.values());
    private JCheckBox lowMemCheckbox = new JCheckBox();
    private File targetFile = null;
    private File inputFile = null;
    private File outputFile = null;

    public TreeAnnotatorDialog(JFrame jFrame) {
        this.frame = jFrame;
        this.optionPanel = new OptionsPanel(12, 12);
        this.frame = jFrame;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        this.burninText.setColumns(12);
        this.burninText.setValue(0);
        this.optionPanel.addComponentWithLabel("Burnin percentage: ", this.burninText);
        this.limitText.setColumns(12);
        this.limitText.setValue(0.0);
        this.optionPanel.addComponentWithLabel("Posterior probability limit: ", this.limitText);
        this.optionPanel.addComponentWithLabel("Target tree type: ", this.summaryTreeCombo);
        this.optionPanel.addComponentWithLabel("Node heights: ", this.nodeHeightsCombo);
        this.optionPanel.addSeparator();
        final JButton jButton = new JButton("Choose File...");
        final JTextField jTextField = new JTextField("not selected", 16);
        jButton.addActionListener(actionEvent -> {
            FileDialog fileDialog = new FileDialog((Frame)jFrame, "Select target file...", 0);
            fileDialog.setVisible(true);
            if (fileDialog.getFile() == null) {
                return;
            }
            this.targetFile = new File(fileDialog.getDirectory(), fileDialog.getFile());
            jTextField.setText(this.targetFile.getName());
        });
        jTextField.setEditable(false);
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 0));
        jPanel2.add((Component)jTextField, "Center");
        jPanel2.add((Component)jButton, "East");
        final JLabel jLabel = this.optionPanel.addComponentWithLabel("Target Tree File: ", jPanel2);
        JButton jButton2 = new JButton("Choose File...");
        final JTextField jTextField2 = new JTextField("not selected", 16);
        jButton2.addActionListener(actionEvent -> {
            FileDialog fileDialog = new FileDialog((Frame)jFrame, "Select input tree file...", 0);
            fileDialog.setVisible(true);
            if (fileDialog.getFile() == null) {
                return;
            }
            this.inputFile = new File(fileDialog.getDirectory(), fileDialog.getFile());
            jTextField2.setText(this.inputFile.getName());
        });
        jTextField2.setEditable(false);
        jLabel.setEnabled(false);
        jTextField.setEnabled(false);
        jButton.setEnabled(false);
        this.summaryTreeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = TreeAnnotatorDialog.this.summaryTreeCombo.getSelectedItem().toString().equals("User target tree");
                jLabel.setEnabled(bl);
                jTextField.setEnabled(bl);
                jButton.setEnabled(bl);
            }
        });
        JPanel jPanel3 = new JPanel(new BorderLayout(0, 0));
        jPanel3.add((Component)jTextField2, "Center");
        jPanel3.add((Component)jButton2, "East");
        Color color = UIManager.getColor("Focus.color");
        MatteBorder matteBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, color);
        new FileDrop(null, (Component)jTextField2, matteBorder, new FileDrop.Listener(){

            @Override
            public void filesDropped(File[] fileArray) {
                TreeAnnotatorDialog.this.inputFile = fileArray[0];
                jTextField2.setText(TreeAnnotatorDialog.this.inputFile.getName());
            }
        });
        this.optionPanel.addComponentWithLabel("Input Tree File: ", jPanel3);
        JButton jButton3 = new JButton("Choose File...");
        JTextField jTextField3 = new JTextField("not selected", 16);
        jButton3.addActionListener(actionEvent -> {
            FileDialog fileDialog = new FileDialog((Frame)jFrame, "Select output file...", 1);
            fileDialog.setVisible(true);
            if (fileDialog.getFile() == null) {
                return;
            }
            this.outputFile = new File(fileDialog.getDirectory(), fileDialog.getFile());
            jTextField3.setText(this.outputFile.getName());
        });
        jTextField3.setEditable(false);
        JPanel jPanel4 = new JPanel(new BorderLayout(0, 0));
        jPanel4.add((Component)jTextField3, "Center");
        jPanel4.add((Component)jButton3, "East");
        this.optionPanel.addComponentWithLabel("Output File: ", jPanel4);
        this.optionPanel.addComponentWithLabel("Low memory: ", this.lowMemCheckbox);
    }

    public boolean showDialog(String string) {
        JOptionPane jOptionPane = new JOptionPane(this.optionPanel, -1, 2, null, new String[]{"Run", "Quit"}, null);
        jOptionPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        JDialog jDialog = jOptionPane.createDialog(this.frame, string);
        jDialog.pack();
        jDialog.setVisible(true);
        return jOptionPane.getValue().equals("Run");
    }

    public int getBurninPercentage() {
        return this.burninText.getValue();
    }

    public double getPosteriorLimit() {
        return this.limitText.getValue();
    }

    public TreeAnnotator.Target getTargetOption() {
        return (TreeAnnotator.Target)((Object)this.summaryTreeCombo.getSelectedItem());
    }

    public TreeAnnotator.HeightsSummary getHeightsOption() {
        return (TreeAnnotator.HeightsSummary)((Object)this.nodeHeightsCombo.getSelectedItem());
    }

    public String getTargetFileName() {
        if (this.targetFile == null) {
            return null;
        }
        return this.targetFile.getPath();
    }

    public String getInputFileName() {
        if (this.inputFile == null) {
            return null;
        }
        return this.inputFile.getPath();
    }

    public String getOutputFileName() {
        if (this.outputFile == null) {
            return null;
        }
        return this.outputFile.getPath();
    }

    public boolean useLowMem() {
        return this.lowMemCheckbox.isSelected();
    }
}

