/*
 * Decompiled with CFR 0.152.
 */
package beast.evolution.datatype;

import beast.core.Description;
import beast.core.Input;
import beast.evolution.datatype.DataType;
import java.util.ArrayList;

@Description(value="User defined datatype. Allows custom symbols to map onto statesets.")
public class UserDataType
extends DataType.Base {
    public final Input<Integer> stateCountInput = new Input("states", "total number of states", Input.Validate.REQUIRED);
    public final Input<Integer> codeLengthInput = new Input<Integer>("codelength", "length of code, if negative a variable length code is assumed, default 1", 1);
    public final Input<String> codeMapInput = new Input("codeMap", "mapping of codes to states. A comma separated string of codes with a subset of states. A state set is a space separates list of zero based integers, up to the number of states, e.g. A=0, C=1, R=0 2, ? = 0 1 2 3", Input.Validate.REQUIRED);
    public final Input<String> characterNameInput = new Input("characterName", "the name of the character");
    public final Input<String> stateNamesInput = new Input("value", "the list of the state names ordered according to codes given, that is the first in the list is coded by 0, second, by 1 and so forth.");

    public UserDataType() {
    }

    public UserDataType(String string, ArrayList<String> arrayList) {
        this.characterNameInput.setValue(string, this);
        if (arrayList.size() > 0) {
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            for (n = 0; n < arrayList.size(); ++n) {
                stringBuilder.append(n + "=" + n + ", ");
            }
            stringBuilder.append("? =");
            for (n = 0; n < arrayList.size(); ++n) {
                stringBuilder.append(n + " ");
            }
            this.codeMapInput.setValue(stringBuilder.toString(), this);
            stringBuilder = new StringBuilder();
            for (n = 0; n < arrayList.size(); ++n) {
                stringBuilder.append(arrayList.get(n) + ", ");
            }
            stringBuilder.delete(stringBuilder.length() - 2, stringBuilder.length());
            this.stateNamesInput.setValue(stringBuilder.toString(), this);
            this.stateCountInput.setValue(arrayList.size(), this);
        } else {
            this.codeMapInput.setValue("", this);
            this.stateNamesInput.setValue("", this);
            this.stateCountInput.setValue(-1, this);
        }
    }

    @Override
    public void initAndValidate() {
        this.stateCount = this.stateCountInput.get();
        this.codeLength = this.codeLengthInput.get();
        String string = this.codeMapInput.get();
        if (!this.codeMapInput.get().equals("")) {
            String[] stringArray = string.split(",");
            this.codeMap = "";
            this.mapCodeToStateSet = new int[stringArray.length][];
            int n = 0;
            for (String string2 : stringArray) {
                String[] stringArray2 = string2.split("=");
                String string3 = stringArray2[0].replaceAll("\\s", "");
                this.codeMap = this.codeMap + string3;
                if (this.codeLength > 0) {
                    if (string3.length() != this.codeLength) {
                        throw new IllegalArgumentException("Invalide code '" + string3 + "'. Expected code of length " + this.codeLength);
                    }
                } else {
                    this.codeMap = this.codeMap + ",";
                }
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                String[] stringArray3 = stringArray2 = stringArray2[1].split("\\s+");
                int n2 = stringArray3.length;
                for (int i = 0; i < n2; ++i) {
                    String string4 = stringArray3[i];
                    if (string4.length() <= 0) continue;
                    int n3 = Integer.parseInt(string4);
                    if (n3 < 0 || this.stateCount > 0 && n3 >= this.stateCount) {
                        throw new IllegalArgumentException("state index should be from 0 to statecount, not " + n3);
                    }
                    arrayList.add(n3);
                }
                int[] objectArray = new int[arrayList.size()];
                for (n2 = 0; n2 < arrayList.size(); ++n2) {
                    objectArray[n2] = (Integer)arrayList.get(n2);
                }
                this.mapCodeToStateSet[n++] = objectArray;
            }
        }
    }

    @Override
    public String getCode(int n) {
        return String.valueOf(this.codeMap.split(",")[n]);
    }

    @Override
    public String getTypeDescription() {
        return "user defined";
    }
}

