/*
 * Decompiled with CFR 0.152.
 */
package beast.util;

import beast.core.BEASTInterface;
import beast.core.BEASTObject;
import beast.core.parameter.RealParameter;
import beast.core.util.Log;
import beast.evolution.alignment.Alignment;
import beast.evolution.alignment.FilteredAlignment;
import beast.evolution.alignment.Sequence;
import beast.evolution.alignment.Taxon;
import beast.evolution.alignment.TaxonSet;
import beast.evolution.datatype.StandardData;
import beast.evolution.datatype.UserDataType;
import beast.evolution.tree.TraitSet;
import beast.evolution.tree.Tree;
import beast.math.distributions.Exponential;
import beast.math.distributions.Gamma;
import beast.math.distributions.LogNormalDistributionModel;
import beast.math.distributions.MRCAPrior;
import beast.math.distributions.Normal;
import beast.math.distributions.ParametricDistribution;
import beast.math.distributions.Uniform;
import beast.util.NexusParserListener;
import beast.util.TreeParser;
import beast.util.XMLProducer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NexusParser {
    protected int lineNr;
    public Alignment m_alignment;
    public List<Alignment> filteredAlignments = new ArrayList<Alignment>();
    public TraitSet traitSet;
    public List<MRCAPrior> calibrations;
    public List<String> taxa;
    List<Taxon> taxonList = new ArrayList<Taxon>();
    public List<Tree> trees;
    static Set<String> g_sequenceIDs = new HashSet<String>();
    public Map<String, String> translationMap = null;
    public List<TaxonSet> taxonsets = new ArrayList<TaxonSet>();
    protected List<NexusParserListener> listeners = new ArrayList<NexusParserListener>();

    public void addListener(NexusParserListener nexusParserListener) {
        this.listeners.add(nexusParserListener);
    }

    public void parseFile(File file) throws IOException {
        String string = file.getName().replaceAll(".*[\\/\\\\]", "").replaceAll("\\..*", "");
        this.parseFile(string, new FileReader(file));
    }

    public void parseFile(String string, Reader reader) throws IOException {
        this.lineNr = 0;
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        try {
            while (bufferedReader.ready()) {
                String string2 = this.nextLine(bufferedReader);
                if (string2 == null) {
                    this.processSets();
                    return;
                }
                String string3 = string2.toLowerCase();
                if (string3.matches("^\\s*begin\\s+data;\\s*$") || string3.matches("^\\s*begin\\s+characters;\\s*$")) {
                    this.m_alignment = this.parseDataBlock(bufferedReader);
                    this.m_alignment.setID(string);
                    continue;
                }
                if (string3.matches("^\\s*begin\\s+calibration;\\s*$")) {
                    this.traitSet = this.parseCalibrationsBlock(bufferedReader);
                    continue;
                }
                if (string3.matches("^\\s*begin\\s+assumptions;\\s*$") || string3.matches("^\\s*begin\\s+sets;\\s*$") || string3.matches("^\\s*begin\\s+mrbayes;\\s*$")) {
                    this.parseAssumptionsBlock(bufferedReader);
                    continue;
                }
                if (string3.matches("^\\s*begin\\s+taxa;\\s*$")) {
                    this.parseTaxaBlock(bufferedReader);
                    continue;
                }
                if (!string3.matches("^\\s*begin\\s+trees;\\s*$")) continue;
                this.parseTreesBlock(bufferedReader);
            }
            this.processSets();
        }
        catch (TreeParser.TreeParsingException treeParsingException) {
            int n = this.lineNr + 1;
            if (treeParsingException.getLineNum() != null) {
                n += treeParsingException.getLineNum() - 1;
            }
            String string4 = "Encountered error interpreting the Newick string found around line " + n + " of the input file.";
            if (treeParsingException.getCharacterNum() != null) {
                string4 = string4 + "\nThe parser reports that the error occurred at character " + (treeParsingException.getCharacterNum() + 1) + " of the Newick string on this line.";
            }
            string4 = string4 + "\nThe parser gives the following clue:\n" + treeParsingException.getMessage();
            throw new IOException(string4);
        }
        catch (Exception exception) {
            throw new IOException("Around line " + (this.lineNr + 1) + "\n" + exception.getMessage());
        }
    }

    protected void parseTreesBlock(BufferedReader bufferedReader) throws IOException {
        this.trees = new ArrayList<Tree>();
        String string = this.readLine(bufferedReader).trim();
        while (string.equals("")) {
            string = this.readLine(bufferedReader).trim();
        }
        int n = -1;
        if (string.toLowerCase().contains("translate")) {
            this.translationMap = this.parseTranslateBlock(bufferedReader);
            n = this.getIndexedTranslationMapOrigin(this.translationMap);
            if (n != -1) {
                this.taxa = this.getIndexedTranslationMap(this.translationMap, n);
            }
        }
        while (string != null) {
            if (string.toLowerCase().startsWith("tree ")) {
                TreeParser treeParser;
                int n2 = string.indexOf(40);
                if (n2 > 0) {
                    string = string.substring(n2);
                }
                if (n != -1) {
                    treeParser = new TreeParser(this.taxa, string, n, false);
                } else {
                    try {
                        treeParser = new TreeParser(this.taxa, string, 0, false);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        treeParser = new TreeParser(this.taxa, string, 1, false);
                    }
                }
                if (this.translationMap != null) {
                    treeParser.translateLeafIds(this.translationMap);
                }
                for (NexusParserListener nexusParserListener : this.listeners) {
                    nexusParserListener.treeParsed(this.trees.size(), treeParser);
                }
                this.trees.add(treeParser);
            }
            if ((string = bufferedReader.readLine()) == null) continue;
            string = string.trim();
        }
    }

    protected List<String> getIndexedTranslationMap(Map<String, String> map, int n) {
        Log.warning.println("translation map size = " + map.size());
        String[] stringArray = new String[map.size()];
        for (String string : map.keySet()) {
            stringArray[Integer.parseInt((String)string) - n] = map.get(string);
        }
        return Arrays.asList(stringArray);
    }

    protected int getIndexedTranslationMapOrigin(Map<String, String> map) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        int n = 0;
        for (String string : map.keySet()) {
            int n2 = Integer.parseInt(string);
            treeSet.add(n2);
            ++n;
        }
        if ((Integer)treeSet.last() - (Integer)treeSet.first() == n - 1 && ((Integer)treeSet.first() == 0 || (Integer)treeSet.first() == 1)) {
            return (Integer)treeSet.first();
        }
        return -1;
    }

    protected Map<String, String> parseTranslateBlock(BufferedReader bufferedReader) throws IOException {
        String[] stringArray;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = this.readLine(bufferedReader);
        StringBuilder stringBuilder = new StringBuilder();
        while (string != null && !string.trim().toLowerCase().equals(";")) {
            stringBuilder.append(string.trim());
            string = this.readLine(bufferedReader);
        }
        for (String string2 : stringArray = stringBuilder.toString().split(",")) {
            Object[] objectArray = string2.split("[\t ]+");
            if (objectArray.length == 2) {
                hashMap.put(objectArray[0], objectArray[1]);
                continue;
            }
            Log.warning.println("Ignoring translation:" + Arrays.toString(objectArray));
        }
        return hashMap;
    }

    protected void parseTaxaBlock(BufferedReader bufferedReader) throws IOException {
        String string;
        this.taxa = new ArrayList<String>();
        int n = -1;
        do {
            if ((string = this.nextLine(bufferedReader)).toLowerCase().matches("\\s*dimensions\\s.*")) {
                string = string.substring(string.toLowerCase().indexOf("ntax=") + 5);
                string = string.replaceAll(";", "");
                n = Integer.parseInt(string.trim());
                continue;
            }
            if (!string.toLowerCase().trim().startsWith("taxlabels")) continue;
            string = string.trim().substring(9).trim();
            boolean bl = string.equals("");
            do {
                if (bl) {
                    string = this.nextLine(bufferedReader);
                }
                bl = true;
                string = string.replaceAll(";", "");
                if ((string = string.trim()).length() <= 0 || string.toLowerCase().equals("end")) continue;
                String[] stringArray = string.split("\\s+");
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    if (string2.charAt(0) == '\'' || string2.charAt(0) == '\"') {
                        while (i < stringArray.length && string2.charAt(0) != string2.charAt(string2.length() - 1)) {
                            if (++i == stringArray.length) {
                                throw new IOException("Unclosed quote starting with " + string2);
                            }
                            string2 = string2 + " " + stringArray[i];
                        }
                        string2 = string2.substring(1, string2.length() - 1);
                    }
                    if (!this.taxa.contains(string2)) {
                        this.taxa.add(string2);
                    }
                    if (this.taxonListContains(string2)) continue;
                    this.taxonList.add(new Taxon(string2));
                }
            } while (!string.toLowerCase().replaceAll(";", "").equals("end"));
        } while (!string.toLowerCase().replaceAll(";", "").equals("end"));
        if (n >= 0 && this.taxa.size() != n) {
            throw new IOException("Number of taxa (" + this.taxa.size() + ") is not equal to 'dimension' " + "field (" + n + ") specified in 'taxa' block");
        }
    }

    protected TraitSet parseCalibrationsBlock(BufferedReader bufferedReader) throws IOException {
        String string;
        String string2;
        TraitSet traitSet = new TraitSet();
        traitSet.setID("traitsetDate");
        traitSet.traitNameInput.setValue("date", traitSet);
        do {
            if (!(string2 = this.nextLine(bufferedReader)).toLowerCase().contains("options")) continue;
            string = this.getAttValue("scale", string2);
            if (string.endsWith("s")) {
                string = string.substring(0, string.length() - 1);
            }
            traitSet.unitsInput.setValue(string, traitSet);
        } while (string2.toLowerCase().contains("tipcalibration"));
        string = "";
        while (!(string2 = this.nextLine(bufferedReader)).contains(";")) {
            string = string + string2;
        }
        String[] stringArray = string.split(",");
        string = "";
        for (String string3 : stringArray) {
            String[] stringArray2;
            String[] stringArray3 = string3.split(":");
            String string4 = stringArray3[0].replaceAll(".*=\\s*", "");
            for (String string5 : stringArray2 = stringArray3[1].split("\\s+")) {
                if (string5.matches("^\\s*$")) continue;
                string = string + string5 + "=" + string4 + ",\n";
            }
        }
        string = string.substring(0, string.length() - 2);
        traitSet.traitsInput.setValue(string, traitSet);
        TaxonSet taxonSet = new TaxonSet();
        taxonSet.initByName("alignment", this.m_alignment);
        traitSet.taxaInput.setValue(taxonSet, traitSet);
        traitSet.initAndValidate();
        return traitSet;
    }

    public Alignment parseDataBlock(BufferedReader bufferedReader) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        String string;
        Alignment alignment = new Alignment();
        int n = -1;
        int n2 = -1;
        int n3 = 4;
        Object object6 = "?";
        Object object7 = "-";
        String string2 = null;
        do {
            if ((string = this.nextLine(bufferedReader)).toLowerCase().contains("dimensions")) {
                object5 = this.getAttValue("nchar", string = this.getNextDataBlock(string, bufferedReader));
                if (object5 == null) {
                    throw new IOException("nchar attribute expected (e.g. 'dimensions char=123') expected, not " + string);
                }
                n2 = Integer.parseInt((String)object5);
                object4 = this.getAttValue("ntax", string);
                if (object4 == null) continue;
                n = Integer.parseInt((String)object4);
                continue;
            }
            if (!string.toLowerCase().contains("format")) continue;
            string = this.getNextDataBlock(string, bufferedReader);
            object5 = this.getAttValue("datatype", string);
            object4 = this.getAttValue("symbols", string) == null ? this.getAttValue("symbols", string) : this.getAttValue("symbols", string).replaceAll("\\s", "");
            if (object5 == null) {
                Log.warning.println("Warning: expected datatype (e.g. something like 'format datatype=dna;') not '" + string + "' Assuming integer dataType");
                alignment.dataTypeInput.setValue("integer", alignment);
                if (object4 != null && (((String)object4).equals("01") || ((String)object4).equals("012"))) {
                    n3 = ((String)object4).length();
                }
            } else if (((String)object5).toLowerCase().equals("rna") || ((String)object5).toLowerCase().equals("dna") || ((String)object5).toLowerCase().equals("nucleotide")) {
                alignment.dataTypeInput.setValue("nucleotide", alignment);
                n3 = 4;
            } else if (((String)object5).toLowerCase().equals("aminoacid") || ((String)object5).toLowerCase().equals("protein")) {
                alignment.dataTypeInput.setValue("aminoacid", alignment);
                n3 = 20;
            } else if (((String)object5).toLowerCase().equals("standard")) {
                alignment.dataTypeInput.setValue("standard", alignment);
                n3 = ((String)object4).length();
            } else if (((String)object5).toLowerCase().equals("binary")) {
                alignment.dataTypeInput.setValue("binary", alignment);
                n3 = 2;
            } else {
                alignment.dataTypeInput.setValue("integer", alignment);
                if (object4 != null && (((String)object4).equals("01") || ((String)object4).equals("012"))) {
                    n3 = ((String)object4).length();
                }
            }
            if ((object3 = this.getAttValue("missing", string)) != null) {
                object6 = object3;
            }
            if ((object2 = this.getAttValue("gap", string)) != null) {
                object7 = object2;
            }
            string2 = this.getAttValue("matchchar", string);
        } while (!string.trim().toLowerCase().startsWith("matrix") && !string.toLowerCase().contains("charstatelabels"));
        if (alignment.dataTypeInput.get().equals("standard")) {
            object5 = new StandardData();
            object5.setInputValue("nrOfStates", n3);
            ((StandardData)object5).initAndValidate();
            alignment.setInputValue("userDataType", object5);
        }
        if (string.toLowerCase().contains("charstatelabels")) {
            if (!alignment.dataTypeInput.get().equals("standard")) {
                throw new IllegalArgumentException("If CHARSTATELABELS block is specified then DATATYPE has to be Standard");
            }
            object5 = (StandardData)alignment.userDataTypeInput.get();
            object4 = new int[]{0};
            object3 = this.readInCharstatelablesTokens(bufferedReader);
            object2 = this.processCharstatelabelsTokens((ArrayList<String>)object3, (int[])object4);
            object5.setInputValue("charstatelabels", object2);
            object5.setInputValue("nrOfStates", Math.max((int)object4[0], n3));
            ((StandardData)object5).initAndValidate();
            for (UserDataType userDataType : ((StandardData)object5).charStateLabelsInput.get()) {
                userDataType.initAndValidate();
            }
        }
        while (!string.toLowerCase().contains("matrix")) {
            string = this.nextLine(bufferedReader);
        }
        object5 = new HashMap();
        object4 = new ArrayList();
        object3 = null;
        int n4 = 0;
        do {
            int n5;
            string = this.nextLine(bufferedReader);
            int n6 = 0;
            while (Character.isWhitespace(string.charAt(n6))) {
                ++n6;
            }
            if (string.charAt(n6) == '\'' || string.charAt(n6) == '\"') {
                char c = string.charAt(n6);
                n5 = ++n6;
                while (string.charAt(n5) != c) {
                    ++n5;
                }
                object = string.substring(n6, n5);
                n4 = 0;
                ++n5;
            } else {
                for (n5 = n6; n5 < string.length() && !Character.isWhitespace(string.charAt(n5)); ++n5) {
                }
                if (n5 < string.length()) {
                    object = string.substring(n6, n5);
                    n4 = 0;
                } else if ((object3 == null || n4 == n2) && n5 == string.length()) {
                    object = string.substring(n6, n5);
                    n4 = 0;
                } else {
                    object = object3;
                    if (object == null) {
                        throw new IOException("Could not recognise taxon");
                    }
                    n5 = n6;
                }
            }
            object3 = object;
            String string3 = string.substring(n5);
            for (int i = 0; i < string3.length(); ++i) {
                if (Character.isWhitespace(string3.charAt(i))) continue;
                ++n4;
            }
            String charSequence2 = string3.replaceAll(";", "");
            if (charSequence2.trim().length() <= 0) continue;
            if (object5.containsKey(object)) {
                object5.put(object, ((StringBuilder)object5.get(object)).append(charSequence2));
                continue;
            }
            object5.put(object, new StringBuilder(charSequence2));
            object4.add(object);
        } while (!string.contains(";"));
        if (n > 0 && object4.size() > n) {
            throw new IOException("Wrong number of taxa. Perhaps a typo in one of the taxa: " + object4);
        }
        HashSet<String> hashSet = new HashSet<String>();
        Object object8 = object4.iterator();
        while (object8.hasNext()) {
            object = (String)object8.next();
            if (!this.taxonListContains((String)object)) {
                this.taxonList.add(new Taxon((String)object));
            }
            StringBuilder stringBuilder = (StringBuilder)object5.get(object);
            String string4 = stringBuilder.toString().replaceAll("\\s", "");
            object5.put(object, new StringBuilder(string4));
            ArrayList<String> arrayList = new ArrayList<String>();
            Matcher matcher = Pattern.compile("\\{(.*?)\\}").matcher(string4);
            while (matcher.find()) {
                int n5 = matcher.group().length();
                arrayList.add(matcher.group().substring(1, n5 - 1));
            }
            String string5 = string4.replaceAll("\\{(.*?)\\}", "?");
            for (String string6 : arrayList) {
                int n6;
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
                for (int i = 0; i < string6.length(); ++i) {
                    n6 = string6.charAt(i);
                    if (n6 >= 48 && n6 <= 57) {
                        arrayList2.add(Integer.parseInt(string6.charAt(i) + ""));
                        continue;
                    }
                    if (string4 != string5) {
                        Log.warning.println("Ambiguity found in " + object + " that is treated as missing value");
                    }
                    string4 = string5;
                }
                Collections.sort(arrayList2);
                String string7 = "";
                for (n6 = 0; n6 < arrayList2.size(); ++n6) {
                    string7 = string7 + Integer.toString((Integer)arrayList2.get(n6));
                }
                hashSet.add(string7);
            }
            if (string5.length() != n2) {
                throw new IOException(string + "\nExpected sequence of length " + n2 + " instead of " + string4.length() + " for taxon " + object);
            }
            string4 = string4.replace(((String)object6).charAt(0), '?');
            string4 = string4.replace(((String)object7).charAt(0), '-');
            if (string2 != null && string4.contains(string2)) {
                String string6;
                char c = string2.charAt(0);
                string6 = ((StringBuilder)object5.get(object4.get(0))).toString();
                for (int i = 0; i < string4.length(); ++i) {
                    if (string4.charAt(i) != c) continue;
                    char c2 = string6.charAt(i);
                    string4 = string4.substring(0, i) + c2 + (i + 1 < string4.length() ? string4.substring(i + 1) : "");
                }
            }
            Sequence sequence = new Sequence();
            sequence.init(n3, object, string4);
            sequence.setID(NexusParser.generateSequenceID(object));
            alignment.sequenceInput.setValue(sequence, alignment);
        }
        if (alignment.dataTypeInput.get().equals("standard")) {
            object8 = "";
            for (String string8 : hashSet) {
                object8 = (String)object8 + string8 + " ";
            }
            if (((String)object8).length() > 0) {
                object8 = ((String)object8).substring(0, ((String)object8).length() - 1);
            }
            alignment.userDataTypeInput.get().initByName("ambiguities", object8);
        }
        alignment.initAndValidate();
        if (n > 0 && n != alignment.getTaxonCount()) {
            throw new IOException("dimensions block says there are " + n + " taxa, but there were " + alignment.getTaxonCount() + " taxa found");
        }
        return alignment;
    }

    private boolean taxonListContains(String string) {
        for (Taxon taxon : this.taxonList) {
            if (!taxon.getID().equals(string)) continue;
            return true;
        }
        return false;
    }

    private String getNextDataBlock(String string, BufferedReader bufferedReader) throws IOException {
        while (string.indexOf(59) < 0) {
            string = string + this.nextLine(bufferedReader);
        }
        if ((string = string.replace(";", " ")).toLowerCase().matches(".*matrix.*")) {
            throw new IllegalArgumentException("Mallformed nexus file: perhaps a semi colon is missing before 'matrix'");
        }
        return string;
    }

    protected void parseAssumptionsBlock(BufferedReader bufferedReader) throws IOException {
        String string;
        do {
            int n;
            Object object2;
            Object object3;
            String[] stringArray;
            if ((string = this.nextLine(bufferedReader)).toLowerCase().matches("\\s*charset\\s.*")) {
                string = string.replaceAll("\\(.*\\)", "");
                string = string.replaceAll("=", " = ");
                string = string.replaceAll("^\\s+", "");
                string = string.replaceAll("\\s*-\\s*", "-");
                string = string.replaceAll("\\s*\\\\\\s*", "\\\\");
                string = string.replaceAll("\\s*;", "");
                stringArray = string.trim().split("\\s+");
                object3 = stringArray[1];
                String string2 = "";
                for (int i = 3; i < stringArray.length; ++i) {
                    string2 = string2 + stringArray[i] + " ";
                }
                string2 = string2.trim().replace(' ', ',');
                object2 = new FilteredAlignment();
                ((BEASTObject)object2).setID((String)object3);
                ((FilteredAlignment)object2).alignmentInput.setValue(this.m_alignment, (BEASTInterface)object2);
                ((FilteredAlignment)object2).filterInput.setValue(string2, (BEASTInterface)object2);
                ((FilteredAlignment)object2).initAndValidate();
                this.filteredAlignments.add((Alignment)object2);
                continue;
            }
            if (string.toLowerCase().matches("\\s*wtset\\s.*")) {
                stringArray = string.split("=");
                if (stringArray.length <= 1) continue;
                string = stringArray[stringArray.length - 1].trim();
                stringArray = string.split("\\s+");
                object3 = new int[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    object3[i] = Integer.parseInt(stringArray[i]);
                }
                if (this.m_alignment != null) {
                    if (((Object)object3).length != this.m_alignment.getSiteCount()) {
                        throw new RuntimeException("Number of weights (" + ((Object)object3).length + ") " + "does not match number of sites in alignment(" + this.m_alignment.getSiteCount() + ")");
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    for (String string2 : stringArray) {
                        stringBuilder.append(string2);
                        stringBuilder.append(',');
                    }
                    stringBuilder.delete(stringBuilder.length() - 1, stringBuilder.length());
                    this.m_alignment.siteWeightsInput.setValue(stringBuilder.toString(), this.m_alignment);
                    this.m_alignment.initAndValidate();
                    continue;
                }
                Log.warning.println("WTSET was specified before alignment. WTSET is ignored.");
                continue;
            }
            if (string.toLowerCase().matches("\\s*taxset\\s.*")) {
                stringArray = string.split("=");
                if (stringArray.length <= 1) continue;
                object3 = stringArray[0].trim();
                String[] stringArray2 = ((String)object3).split("\\s+");
                if (stringArray2.length != 2) {
                    throw new RuntimeException("expected 'taxset <name> = ...;' but did not get two words before the = sign: " + string);
                }
                object2 = stringArray2[1];
                object3 = stringArray[stringArray.length - 1].trim();
                if (!((String)object3).endsWith(";")) {
                    Log.warning.println("expected 'taxset <name> = ...;' semi-colin is missing: " + string + "\n" + "Taxa from following lines may be missing.");
                }
                object3 = ((String)object3).replaceAll(";", "");
                String[] stringArray3 = ((String)object3).split("\\s+");
                TaxonSet taxonSet = new TaxonSet();
                String[] stringArray4 = stringArray3;
                n = stringArray4.length;
                for (int i = 0; i < n; ++i) {
                    String string3 = stringArray4[i];
                    taxonSet.taxonsetInput.get().add(new Taxon(string3.replaceAll("'\"", "")));
                }
                taxonSet.setID(((String)object2).replaceAll("'\"", ""));
                this.taxonsets.add(taxonSet);
                continue;
            }
            if (!string.toLowerCase().matches("^\\s*calibrate\\s.*") || (stringArray = string.split("=")).length <= 1) continue;
            object3 = stringArray[0].trim();
            String[] stringArray4 = ((String)object3).split("\\s+");
            if (stringArray4.length != 2) {
                throw new RuntimeException("expected 'calibrate <name> = ...' but did not get two words before the = sign: " + string);
            }
            object2 = stringArray4[1].replaceAll("'\"", "");
            TaxonSet taxonSet = null;
            for (Taxon taxon : this.taxonsets) {
                if (!taxon.getID().equals(object2) || !(taxon instanceof TaxonSet)) continue;
                taxonSet = (TaxonSet)taxon;
            }
            if (taxonSet == null) {
                for (Taxon taxon : this.taxonList) {
                    if (!taxon.getID().equals(object2)) continue;
                    taxonSet = new TaxonSet();
                    taxonSet.setID(taxon.getID() + ".leaf");
                    taxonSet.taxonsetInput.setValue(taxon, taxonSet);
                }
            }
            if (taxonSet == null) {
                throw new RuntimeException("Could not find taxon/taxonset " + (String)object2 + " in calibration: " + string);
            }
            object3 = stringArray[stringArray.length - 1].trim();
            Iterator<Taxon> iterator = ((String)object3).split("[\\(,\\)]");
            RealParameter[] realParameterArray = new RealParameter[((Iterator<Taxon>)iterator).length];
            for (n = 1; n < ((Iterator<Taxon>)iterator).length; ++n) {
                try {
                    realParameterArray[n] = new RealParameter((String)((Object)iterator[n]));
                    realParameterArray[n].setID("param." + n);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ParametricDistribution parametricDistribution = null;
            switch (iterator[0]) {
                case "normal": {
                    parametricDistribution = new Normal();
                    parametricDistribution.initByName("mean", realParameterArray[1], "sigma", realParameterArray[2]);
                    parametricDistribution.setID("Normal.0");
                    break;
                }
                case "uniform": {
                    parametricDistribution = new Uniform();
                    parametricDistribution.initByName("lower", iterator[1], "upper", iterator[2]);
                    parametricDistribution.setID("Uniform.0");
                    break;
                }
                case "fixed": {
                    parametricDistribution = new Normal();
                    parametricDistribution.initByName("mean", realParameterArray[1], "sigma", "+Infinity");
                    parametricDistribution.setID("Normal.0");
                    break;
                }
                case "offsetlognormal": {
                    parametricDistribution = new LogNormalDistributionModel();
                    parametricDistribution.initByName("offset", iterator[1], "M", realParameterArray[2], "S", realParameterArray[3], "meanInRealSpace", true);
                    parametricDistribution.setID("LogNormalDistributionModel.0");
                    break;
                }
                case "lognormal": {
                    parametricDistribution = new LogNormalDistributionModel();
                    parametricDistribution.initByName("M", realParameterArray[1], "S", realParameterArray[2], "meanInRealSpace", true);
                    parametricDistribution.setID("LogNormalDistributionModel.0");
                    break;
                }
                case "offsetexponential": {
                    parametricDistribution = new Exponential();
                    parametricDistribution.initByName("offset", iterator[1], "mean", realParameterArray[2]);
                    parametricDistribution.setID("Exponential.0");
                    break;
                }
                case "gamma": {
                    parametricDistribution = new Gamma();
                    parametricDistribution.initByName("alpha", realParameterArray[1], "beta", realParameterArray[2]);
                    parametricDistribution.setID("Gamma.0");
                    break;
                }
                case "offsetgamma": {
                    parametricDistribution = new Gamma();
                    parametricDistribution.initByName("offset", iterator[1], "alpha", realParameterArray[2], "beta", realParameterArray[3]);
                    parametricDistribution.setID("Gamma.0");
                    break;
                }
                default: {
                    throw new RuntimeException("Unknwon distribution " + iterator[0] + "in calibration: " + string);
                }
            }
            Object object = new MRCAPrior();
            ((MRCAPrior)object).isMonophyleticInput.setValue(true, (BEASTInterface)object);
            ((MRCAPrior)object).distInput.setValue(parametricDistribution, (BEASTInterface)object);
            ((MRCAPrior)object).taxonsetInput.setValue(taxonSet, (BEASTInterface)object);
            ((BEASTObject)object).setID(taxonSet.getID() + ".prior");
            if (this.calibrations == null) {
                this.calibrations = new ArrayList<MRCAPrior>();
            }
            this.calibrations.add((MRCAPrior)object);
        } while (!string.toLowerCase().contains("end;"));
    }

    protected void processSets() {
        for (TaxonSet taxonSet : this.taxonsets) {
            boolean bl = false;
            for (BEASTInterface bEASTInterface : taxonSet.getOutputs()) {
                if (!(bEASTInterface instanceof MRCAPrior)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            MRCAPrior mRCAPrior = new MRCAPrior();
            mRCAPrior.isMonophyleticInput.setValue(true, mRCAPrior);
            mRCAPrior.taxonsetInput.setValue(taxonSet, mRCAPrior);
            mRCAPrior.setID(taxonSet.getID() + ".prior");
            if (this.calibrations == null) {
                this.calibrations = new ArrayList<MRCAPrior>();
            }
            this.calibrations.add(mRCAPrior);
        }
    }

    void parseSetsBlock(BufferedReader bufferedReader) throws IOException {
        String string;
        do {
            String[] stringArray;
            if (!(string = this.nextLine(bufferedReader)).toLowerCase().matches("\\s*taxset\\s.*") || (stringArray = string.split("=")).length <= 1) continue;
            String string2 = stringArray[0].trim();
            String[] stringArray2 = string2.split("\\s+");
            if (stringArray2.length != 2) {
                throw new RuntimeException("expected 'taxset <name> = ...;' but did not get two words before the = sign: " + string);
            }
            String string3 = stringArray2[1];
            string2 = stringArray[stringArray.length - 1].trim();
            if (!string2.endsWith(";")) {
                Log.warning.println("expected 'taxset <name> = ...;' semi-colin is missing: " + string + "\n" + "Taxa from following lines may be missing.");
            }
            string2 = string2.replaceAll(";", "");
            String[] stringArray3 = string2.split("\\s+");
            TaxonSet taxonSet = new TaxonSet();
            for (String string4 : stringArray3) {
                taxonSet.taxonsetInput.get().add(new Taxon(string4.replaceAll("'\"", "")));
            }
            taxonSet.setID(string3.replaceAll("'\"", ""));
            this.taxonsets.add(taxonSet);
        } while (!string.toLowerCase().contains("end;"));
    }

    public static String generateSequenceID(String string) {
        String string2 = "seq_" + string;
        int n = 0;
        while (g_sequenceIDs.contains(string2 + (n > 0 ? Integer.valueOf(n) : ""))) {
            ++n;
        }
        string2 = string2 + (n > 0 ? Integer.valueOf(n) : "");
        g_sequenceIDs.add(string2);
        return string2;
    }

    protected String readLine(BufferedReader bufferedReader) throws IOException {
        if (!bufferedReader.ready()) {
            return null;
        }
        ++this.lineNr;
        return bufferedReader.readLine();
    }

    protected String nextLine(BufferedReader bufferedReader) throws IOException {
        String string = this.readLine(bufferedReader);
        if (string == null) {
            return null;
        }
        if (string.contains("[")) {
            int n = string.indexOf(91);
            int n2 = string.indexOf(93, n);
            while (n2 < 0) {
                string = string + this.readLine(bufferedReader);
                n2 = string.indexOf(93, n);
            }
            if ((string = string.substring(0, n) + string.substring(n2 + 1)).matches("^\\s*$")) {
                return this.nextLine(bufferedReader);
            }
        }
        if (string.matches("^\\s*$")) {
            return this.nextLine(bufferedReader);
        }
        return string;
    }

    protected String getAttValue(String string, String string2) {
        Pattern pattern = Pattern.compile(".*" + string + "\\s*=\\s*([^\\s;]+).*");
        Matcher matcher = pattern.matcher(string2.toLowerCase());
        if (!matcher.find()) {
            return null;
        }
        String string3 = matcher.group(1);
        if (string3.startsWith("\"") && string3.endsWith("\"")) {
            int n = matcher.start(1);
            string3 = string2.substring(n + 1, string2.indexOf(34, n + 1));
        }
        return string3;
    }

    private ArrayList<String> readInCharstatelablesTokens(BufferedReader bufferedReader) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "";
        int n = 2;
        int n2 = 0;
        boolean bl = false;
        while (!bl) {
            String string2 = this.nextLine(bufferedReader);
            block6: for (int i = 0; i < string2.length(); ++i) {
                Character c = Character.valueOf(string2.charAt(i));
                switch (n) {
                    case 2: {
                        if (Character.isWhitespace(c.charValue())) continue block6;
                        if (c.charValue() == '\'') {
                            n = 1;
                            continue block6;
                        }
                        if (c.charValue() == '/' || c.charValue() == ',') {
                            arrayList.add(c.toString());
                            string = "";
                            continue block6;
                        }
                        if (c.charValue() == ';') {
                            bl = true;
                            continue block6;
                        }
                        string = string + c;
                        n = 0;
                        continue block6;
                    }
                    case 0: {
                        if (c.charValue() == '\'') {
                            arrayList.add(string);
                            string = "";
                            n = 1;
                            continue block6;
                        }
                        if (c.charValue() == '/' || c.charValue() == ',') {
                            arrayList.add(string);
                            arrayList.add(c.toString());
                            string = "";
                            n = 2;
                            continue block6;
                        }
                        if (c.charValue() == ';') {
                            arrayList.add(string);
                            bl = true;
                            continue block6;
                        }
                        if (Character.isWhitespace(c.charValue())) {
                            arrayList.add(string);
                            string = "";
                            n = 2;
                            continue block6;
                        }
                        string = string + c;
                        continue block6;
                    }
                    case 1: {
                        int n3;
                        if (c.charValue() == '\'') {
                            ++n2;
                            continue block6;
                        }
                        if (n2 % 2 == 0) {
                            for (n3 = 0; n3 < n2 / 2; ++n3) {
                                string = string + "'";
                            }
                            string = string + c;
                        } else {
                            for (n3 = 0; n3 < n2 / 2; ++n3) {
                                string = string + "'";
                            }
                            arrayList.add(string);
                            string = "";
                            if (c.charValue() == '/' || c.charValue() == ',') {
                                arrayList.add(c.toString());
                                n = 2;
                            } else if (c.charValue() == ';') {
                                bl = true;
                            } else if (Character.isWhitespace(c.charValue())) {
                                n = 2;
                            } else {
                                string = string + c;
                                n = 0;
                            }
                        }
                        n2 = 0;
                        continue block6;
                    }
                }
            }
        }
        if (!((String)arrayList.get(arrayList.size() - 1)).equals(",")) {
            arrayList.add(",");
        }
        return arrayList;
    }

    private ArrayList<UserDataType> processCharstatelabelsTokens(ArrayList<String> arrayList, int[] nArray) throws IOException {
        ArrayList<UserDataType> arrayList2 = new ArrayList<UserDataType>();
        int n = 0;
        int n2 = -1;
        String string = "";
        ArrayList<String> arrayList3 = new ArrayList<String>();
        for (String string2 : arrayList) {
            switch (n) {
                case 0: {
                    n2 = Integer.parseInt(string2);
                    n = 1;
                    break;
                }
                case 1: {
                    if (string2.equals("/")) {
                        n = 2;
                        break;
                    }
                    if (string2.equals(",")) {
                        if (n2 > arrayList2.size() + 1) {
                            throw new IOException("Character descriptions should go in the ascending order and there should not be any description missing.");
                        }
                        arrayList2.add(new UserDataType(string, arrayList3));
                        nArray[0] = Math.max(nArray[0], arrayList3.size());
                        n2 = -1;
                        string = "";
                        arrayList3 = new ArrayList();
                        n = 0;
                        break;
                    }
                    string = string2;
                    break;
                }
                case 2: {
                    if (string2.equals(",")) {
                        if (n2 > arrayList2.size() + 1) {
                            throw new IOException("Character descriptions should go in the ascending order and there should not be any description missing.");
                        }
                        arrayList2.add(new UserDataType(string, arrayList3));
                        nArray[0] = Math.max(nArray[0], arrayList3.size());
                        n2 = -1;
                        string = "";
                        arrayList3 = new ArrayList();
                        n = 0;
                        break;
                    }
                    arrayList3.add(string2);
                }
            }
        }
        return arrayList2;
    }

    public static void main(String[] stringArray) {
        try {
            String string;
            NexusParser nexusParser = new NexusParser();
            nexusParser.parseFile(new File(stringArray[0]));
            if (nexusParser.taxa != null) {
                System.out.println(nexusParser.taxa.size() + " taxa");
                System.out.println(Arrays.toString(nexusParser.taxa.toArray(new String[nexusParser.taxa.size()])));
            }
            if (nexusParser.trees != null) {
                System.out.println(nexusParser.trees.size() + " trees");
            }
            if (nexusParser.m_alignment != null) {
                string = new XMLProducer().toXML(nexusParser.m_alignment);
                System.out.println(string);
            }
            if (nexusParser.traitSet != null) {
                string = new XMLProducer().toXML(nexusParser.traitSet);
                System.out.println(string);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

