/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractDistribution;
import org.apache.commons.math.distribution.IntegerDistribution;

public abstract class AbstractIntegerDistribution
extends AbstractDistribution
implements IntegerDistribution,
Serializable {
    private static final String WRONG_ORDER_ENDPOINTS_MESSAGE = "lower endpoint ({0}) must be less than or equal to upper endpoint ({1})";
    private static final String OUT_OF_RANGE_POINT = "{0} out of [{1}, {2}] range";
    private static final long serialVersionUID = -1146319659338487221L;

    protected AbstractIntegerDistribution() {
    }

    @Override
    public double cumulativeProbability(double d) throws MathException {
        return this.cumulativeProbability((int)Math.floor(d));
    }

    @Override
    public double cumulativeProbability(double d, double d2) throws MathException {
        if (d > d2) {
            throw MathRuntimeException.createIllegalArgumentException(WRONG_ORDER_ENDPOINTS_MESSAGE, d, d2);
        }
        if (Math.floor(d) < d) {
            return this.cumulativeProbability((int)Math.floor(d) + 1, (int)Math.floor(d2));
        }
        return this.cumulativeProbability((int)Math.floor(d), (int)Math.floor(d2));
    }

    @Override
    public abstract double cumulativeProbability(int var1) throws MathException;

    @Override
    public double probability(double d) {
        double d2 = Math.floor(d);
        if (d2 == d) {
            return this.probability((int)d);
        }
        return 0.0;
    }

    @Override
    public double cumulativeProbability(int n, int n2) throws MathException {
        if (n > n2) {
            throw MathRuntimeException.createIllegalArgumentException(WRONG_ORDER_ENDPOINTS_MESSAGE, n, n2);
        }
        return this.cumulativeProbability(n2) - this.cumulativeProbability(n - 1);
    }

    @Override
    public int inverseCumulativeProbability(double d) throws MathException {
        double d2;
        if (d < 0.0 || d > 1.0) {
            throw MathRuntimeException.createIllegalArgumentException(OUT_OF_RANGE_POINT, d, 0.0, 1.0);
        }
        int n = this.getDomainLowerBound(d);
        int n2 = this.getDomainUpperBound(d);
        while (n < n2) {
            int n3 = n + (n2 - n) / 2;
            d2 = this.checkedCumulativeProbability(n3);
            if (d2 > d) {
                if (n3 == n2) {
                    --n2;
                    continue;
                }
                n2 = n3;
                continue;
            }
            if (n3 == n) {
                ++n;
                continue;
            }
            n = n3;
        }
        d2 = this.checkedCumulativeProbability(n);
        while (d2 > d) {
            d2 = this.checkedCumulativeProbability(--n);
        }
        n = n >= this.getDomainLowerBound(d) ? n : this.getDomainLowerBound(d);
        n = n <= this.getDomainUpperBound(d) ? n : this.getDomainUpperBound(d);
        return n;
    }

    private double checkedCumulativeProbability(int n) throws FunctionEvaluationException {
        double d = Double.NaN;
        try {
            d = this.cumulativeProbability(n);
        }
        catch (MathException mathException) {
            throw new FunctionEvaluationException((Throwable)mathException, n, mathException.getPattern(), mathException.getArguments());
        }
        if (Double.isNaN(d)) {
            throw new FunctionEvaluationException(n, "Discrete cumulative probability function returned NaN for argument {0}", n);
        }
        return d;
    }

    protected abstract int getDomainLowerBound(double var1);

    protected abstract int getDomainUpperBound(double var1);
}

