/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.CauchyDistribution;

public class CauchyDistributionImpl
extends AbstractContinuousDistribution
implements CauchyDistribution,
Serializable {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 8589540077390120676L;
    private double median = 0.0;
    private double scale = 1.0;
    private final double solverAbsoluteAccuracy;

    public CauchyDistributionImpl() {
        this(0.0, 1.0);
    }

    public CauchyDistributionImpl(double d, double d2) {
        this(d, d2, 1.0E-9);
    }

    public CauchyDistributionImpl(double d, double d2, double d3) {
        this.setMedianInternal(d);
        this.setScaleInternal(d2);
        this.solverAbsoluteAccuracy = d3;
    }

    @Override
    public double cumulativeProbability(double d) {
        return 0.5 + Math.atan((d - this.median) / this.scale) / Math.PI;
    }

    @Override
    public double getMedian() {
        return this.median;
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    @Override
    public double density(double d) {
        double d2 = d - this.median;
        return 0.3183098861837907 * (this.scale / (d2 * d2 + this.scale * this.scale));
    }

    @Override
    public double inverseCumulativeProbability(double d) {
        if (d < 0.0 || d > 1.0) {
            throw MathRuntimeException.createIllegalArgumentException("{0} out of [{1}, {2}] range", d, 0.0, 1.0);
        }
        double d2 = d == 0.0 ? Double.NEGATIVE_INFINITY : (d == 1.0 ? Double.POSITIVE_INFINITY : this.median + this.scale * Math.tan(Math.PI * (d - 0.5)));
        return d2;
    }

    @Override
    @Deprecated
    public void setMedian(double d) {
        this.setMedianInternal(d);
    }

    private void setMedianInternal(double d) {
        this.median = d;
    }

    @Override
    @Deprecated
    public void setScale(double d) {
        this.setScaleInternal(d);
    }

    private void setScaleInternal(double d) {
        if (d <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException("scale must be positive ({0})", d);
        }
        this.scale = d;
    }

    @Override
    protected double getDomainLowerBound(double d) {
        double d2 = d < 0.5 ? -1.7976931348623157E308 : this.median;
        return d2;
    }

    @Override
    protected double getDomainUpperBound(double d) {
        double d2 = d < 0.5 ? this.median : Double.MAX_VALUE;
        return d2;
    }

    @Override
    protected double getInitialDomain(double d) {
        double d2 = d < 0.5 ? this.median - this.scale : (d > 0.5 ? this.median + this.scale : this.median);
        return d2;
    }

    @Override
    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }
}

