/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "grid_options.h"

GridOptions::GridOptions (bool init /* = true */) :
    mOptions (GridOptions::OptionNum),
    mNotify (GridOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
GridOptions::initOptions ()
{
    unsigned int state;
    CompAction action;
    unsigned short color[4];

    // put_center_key
    mOptions[GridOptions::PutCenterKey].setName ("put_center_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Alt>KP_5");
    mOptions[GridOptions::PutCenterKey].value().set (action);
    if (screen) screen->addAction (&mOptions[GridOptions::PutCenterKey].value ().action ());

    // put_left_key
    mOptions[GridOptions::PutLeftKey].setName ("put_left_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Alt>KP_4");
    mOptions[GridOptions::PutLeftKey].value().set (action);
    if (screen) screen->addAction (&mOptions[GridOptions::PutLeftKey].value ().action ());

    // put_right_key
    mOptions[GridOptions::PutRightKey].setName ("put_right_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Alt>KP_6");
    mOptions[GridOptions::PutRightKey].value().set (action);
    if (screen) screen->addAction (&mOptions[GridOptions::PutRightKey].value ().action ());

    // put_top_key
    mOptions[GridOptions::PutTopKey].setName ("put_top_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Alt>KP_8");
    mOptions[GridOptions::PutTopKey].value().set (action);
    if (screen) screen->addAction (&mOptions[GridOptions::PutTopKey].value ().action ());

    // put_bottom_key
    mOptions[GridOptions::PutBottomKey].setName ("put_bottom_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Alt>KP_2");
    mOptions[GridOptions::PutBottomKey].value().set (action);
    if (screen) screen->addAction (&mOptions[GridOptions::PutBottomKey].value ().action ());

    // put_topleft_key
    mOptions[GridOptions::PutTopleftKey].setName ("put_topleft_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Alt>KP_7");
    mOptions[GridOptions::PutTopleftKey].value().set (action);
    if (screen) screen->addAction (&mOptions[GridOptions::PutTopleftKey].value ().action ());

    // put_topright_key
    mOptions[GridOptions::PutToprightKey].setName ("put_topright_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Alt>KP_9");
    mOptions[GridOptions::PutToprightKey].value().set (action);
    if (screen) screen->addAction (&mOptions[GridOptions::PutToprightKey].value ().action ());

    // put_bottomleft_key
    mOptions[GridOptions::PutBottomleftKey].setName ("put_bottomleft_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Alt>KP_1");
    mOptions[GridOptions::PutBottomleftKey].value().set (action);
    if (screen) screen->addAction (&mOptions[GridOptions::PutBottomleftKey].value ().action ());

    // put_bottomright_key
    mOptions[GridOptions::PutBottomrightKey].setName ("put_bottomright_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Alt>KP_3");
    mOptions[GridOptions::PutBottomrightKey].value().set (action);
    if (screen) screen->addAction (&mOptions[GridOptions::PutBottomrightKey].value ().action ());

    // put_maximize_key
    mOptions[GridOptions::PutMaximizeKey].setName ("put_maximize_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Alt>KP_0");
    mOptions[GridOptions::PutMaximizeKey].value().set (action);
    if (screen) screen->addAction (&mOptions[GridOptions::PutMaximizeKey].value ().action ());

    // put_restore_key
    mOptions[GridOptions::PutRestoreKey].setName ("put_restore_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Alt>F5");
    mOptions[GridOptions::PutRestoreKey].value().set (action);
    if (screen) screen->addAction (&mOptions[GridOptions::PutRestoreKey].value ().action ());

    // left_maximize
    mOptions[GridOptions::LeftMaximize].setName ("left_maximize", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Super>Left");
    mOptions[GridOptions::LeftMaximize].value().set (action);
    if (screen) screen->addAction (&mOptions[GridOptions::LeftMaximize].value ().action ());

    // right_maximize
    mOptions[GridOptions::RightMaximize].setName ("right_maximize", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Control><Super>Right");
    mOptions[GridOptions::RightMaximize].value().set (action);
    if (screen) screen->addAction (&mOptions[GridOptions::RightMaximize].value ().action ());

    // top_left_corner_action
    mOptions[GridOptions::TopLeftCornerAction].setName ("top_left_corner_action", CompOption::TypeInt);
    mOptions[GridOptions::TopLeftCornerAction].rest ().set (0, 10);
    mOptions[GridOptions::TopLeftCornerAction].value().set((int) 4);

    // top_edge_action
    mOptions[GridOptions::TopEdgeAction].setName ("top_edge_action", CompOption::TypeInt);
    mOptions[GridOptions::TopEdgeAction].rest ().set (0, 10);
    mOptions[GridOptions::TopEdgeAction].value().set((int) 10);

    // top_right_corner_action
    mOptions[GridOptions::TopRightCornerAction].setName ("top_right_corner_action", CompOption::TypeInt);
    mOptions[GridOptions::TopRightCornerAction].rest ().set (0, 10);
    mOptions[GridOptions::TopRightCornerAction].value().set((int) 6);

    // left_edge_action
    mOptions[GridOptions::LeftEdgeAction].setName ("left_edge_action", CompOption::TypeInt);
    mOptions[GridOptions::LeftEdgeAction].rest ().set (0, 10);
    mOptions[GridOptions::LeftEdgeAction].value().set((int) 4);

    // right_edge_action
    mOptions[GridOptions::RightEdgeAction].setName ("right_edge_action", CompOption::TypeInt);
    mOptions[GridOptions::RightEdgeAction].rest ().set (0, 10);
    mOptions[GridOptions::RightEdgeAction].value().set((int) 6);

    // bottom_left_corner_action
    mOptions[GridOptions::BottomLeftCornerAction].setName ("bottom_left_corner_action", CompOption::TypeInt);
    mOptions[GridOptions::BottomLeftCornerAction].rest ().set (0, 10);
    mOptions[GridOptions::BottomLeftCornerAction].value().set((int) 4);

    // bottom_edge_action
    mOptions[GridOptions::BottomEdgeAction].setName ("bottom_edge_action", CompOption::TypeInt);
    mOptions[GridOptions::BottomEdgeAction].rest ().set (0, 10);
    mOptions[GridOptions::BottomEdgeAction].value().set((int) 0);

    // bottom_right_corner_action
    mOptions[GridOptions::BottomRightCornerAction].setName ("bottom_right_corner_action", CompOption::TypeInt);
    mOptions[GridOptions::BottomRightCornerAction].rest ().set (0, 10);
    mOptions[GridOptions::BottomRightCornerAction].value().set((int) 6);

    // snapback_windows
    mOptions[GridOptions::SnapbackWindows].setName ("snapback_windows", CompOption::TypeBool);
    mOptions[GridOptions::SnapbackWindows].value().set(true);

    // cycle_sizes
    mOptions[GridOptions::CycleSizes].setName ("cycle_sizes", CompOption::TypeBool);
    mOptions[GridOptions::CycleSizes].value().set(false);

    // left_edge_threshold
    mOptions[GridOptions::LeftEdgeThreshold].setName ("left_edge_threshold", CompOption::TypeInt);
    mOptions[GridOptions::LeftEdgeThreshold].rest ().set (0, 500);
    mOptions[GridOptions::LeftEdgeThreshold].value().set((int) 15);

    // right_edge_threshold
    mOptions[GridOptions::RightEdgeThreshold].setName ("right_edge_threshold", CompOption::TypeInt);
    mOptions[GridOptions::RightEdgeThreshold].rest ().set (0, 500);
    mOptions[GridOptions::RightEdgeThreshold].value().set((int) 15);

    // top_edge_threshold
    mOptions[GridOptions::TopEdgeThreshold].setName ("top_edge_threshold", CompOption::TypeInt);
    mOptions[GridOptions::TopEdgeThreshold].rest ().set (0, 500);
    mOptions[GridOptions::TopEdgeThreshold].value().set((int) 20);

    // bottom_edge_threshold
    mOptions[GridOptions::BottomEdgeThreshold].setName ("bottom_edge_threshold", CompOption::TypeInt);
    mOptions[GridOptions::BottomEdgeThreshold].rest ().set (0, 500);
    mOptions[GridOptions::BottomEdgeThreshold].value().set((int) 5);

    // snapoff_threshold
    mOptions[GridOptions::SnapoffThreshold].setName ("snapoff_threshold", CompOption::TypeInt);
    mOptions[GridOptions::SnapoffThreshold].rest ().set (0, 500);
    mOptions[GridOptions::SnapoffThreshold].value().set((int) 50);

    // draw_indicator
    mOptions[GridOptions::DrawIndicator].setName ("draw_indicator", CompOption::TypeBool);
    mOptions[GridOptions::DrawIndicator].value().set(true);

    // draw_stretched_window
    mOptions[GridOptions::DrawStretchedWindow].setName ("draw_stretched_window", CompOption::TypeBool);
    mOptions[GridOptions::DrawStretchedWindow].value().set(true);

    // animation_duration
    mOptions[GridOptions::AnimationDuration].setName ("animation_duration", CompOption::TypeInt);
    mOptions[GridOptions::AnimationDuration].rest ().set (0, MAXSHORT);
    mOptions[GridOptions::AnimationDuration].value().set((int) 350);

    // use_desktop_average_color
    mOptions[GridOptions::UseDesktopAverageColor].setName ("use_desktop_average_color", CompOption::TypeBool);
    mOptions[GridOptions::UseDesktopAverageColor].value().set(true);

    // outline_color
    mOptions[GridOptions::OutlineColor].setName ("outline_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xfbfb));
    color[1] = MAX (0, MIN (0xffff, 0x8b8b));
    color[2] = MAX (0, MIN (0xffff, 0x0));
    color[3] = MAX (0, MIN (0xffff, 0x9f9f));
    mOptions[GridOptions::OutlineColor].value().set(color);

    // fill_color
    mOptions[GridOptions::FillColor].setName ("fill_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xfbfb));
    color[1] = MAX (0, MIN (0xffff, 0x8b8b));
    color[2] = MAX (0, MIN (0xffff, 0x0));
    color[3] = MAX (0, MIN (0xffff, 0x4f4f));
    mOptions[GridOptions::FillColor].value().set(color);

    // disable_blend
    mOptions[GridOptions::DisableBlend].setName ("disable_blend", CompOption::TypeBool);
    mOptions[GridOptions::DisableBlend].value().set(false);

}

GridOptions::~GridOptions ()
{
}


CompOption::Vector &
GridOptions::getOptions ()
{
    return mOptions;
}

bool
GridOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case GridOptions::PutCenterKey:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::PutCenterKey].empty ())
                    mNotify[GridOptions::PutCenterKey] (o, GridOptions::PutCenterKey);
                return true;
            }
            break;
        case GridOptions::PutLeftKey:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::PutLeftKey].empty ())
                    mNotify[GridOptions::PutLeftKey] (o, GridOptions::PutLeftKey);
                return true;
            }
            break;
        case GridOptions::PutRightKey:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::PutRightKey].empty ())
                    mNotify[GridOptions::PutRightKey] (o, GridOptions::PutRightKey);
                return true;
            }
            break;
        case GridOptions::PutTopKey:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::PutTopKey].empty ())
                    mNotify[GridOptions::PutTopKey] (o, GridOptions::PutTopKey);
                return true;
            }
            break;
        case GridOptions::PutBottomKey:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::PutBottomKey].empty ())
                    mNotify[GridOptions::PutBottomKey] (o, GridOptions::PutBottomKey);
                return true;
            }
            break;
        case GridOptions::PutTopleftKey:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::PutTopleftKey].empty ())
                    mNotify[GridOptions::PutTopleftKey] (o, GridOptions::PutTopleftKey);
                return true;
            }
            break;
        case GridOptions::PutToprightKey:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::PutToprightKey].empty ())
                    mNotify[GridOptions::PutToprightKey] (o, GridOptions::PutToprightKey);
                return true;
            }
            break;
        case GridOptions::PutBottomleftKey:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::PutBottomleftKey].empty ())
                    mNotify[GridOptions::PutBottomleftKey] (o, GridOptions::PutBottomleftKey);
                return true;
            }
            break;
        case GridOptions::PutBottomrightKey:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::PutBottomrightKey].empty ())
                    mNotify[GridOptions::PutBottomrightKey] (o, GridOptions::PutBottomrightKey);
                return true;
            }
            break;
        case GridOptions::PutMaximizeKey:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::PutMaximizeKey].empty ())
                    mNotify[GridOptions::PutMaximizeKey] (o, GridOptions::PutMaximizeKey);
                return true;
            }
            break;
        case GridOptions::PutRestoreKey:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::PutRestoreKey].empty ())
                    mNotify[GridOptions::PutRestoreKey] (o, GridOptions::PutRestoreKey);
                return true;
            }
            break;
        case GridOptions::LeftMaximize:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::LeftMaximize].empty ())
                    mNotify[GridOptions::LeftMaximize] (o, GridOptions::LeftMaximize);
                return true;
            }
            break;
        case GridOptions::RightMaximize:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::RightMaximize].empty ())
                    mNotify[GridOptions::RightMaximize] (o, GridOptions::RightMaximize);
                return true;
            }
            break;
        case GridOptions::TopLeftCornerAction:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::TopLeftCornerAction].empty ())
                    mNotify[GridOptions::TopLeftCornerAction] (o, GridOptions::TopLeftCornerAction);
                return true;
            }
            break;
        case GridOptions::TopEdgeAction:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::TopEdgeAction].empty ())
                    mNotify[GridOptions::TopEdgeAction] (o, GridOptions::TopEdgeAction);
                return true;
            }
            break;
        case GridOptions::TopRightCornerAction:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::TopRightCornerAction].empty ())
                    mNotify[GridOptions::TopRightCornerAction] (o, GridOptions::TopRightCornerAction);
                return true;
            }
            break;
        case GridOptions::LeftEdgeAction:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::LeftEdgeAction].empty ())
                    mNotify[GridOptions::LeftEdgeAction] (o, GridOptions::LeftEdgeAction);
                return true;
            }
            break;
        case GridOptions::RightEdgeAction:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::RightEdgeAction].empty ())
                    mNotify[GridOptions::RightEdgeAction] (o, GridOptions::RightEdgeAction);
                return true;
            }
            break;
        case GridOptions::BottomLeftCornerAction:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::BottomLeftCornerAction].empty ())
                    mNotify[GridOptions::BottomLeftCornerAction] (o, GridOptions::BottomLeftCornerAction);
                return true;
            }
            break;
        case GridOptions::BottomEdgeAction:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::BottomEdgeAction].empty ())
                    mNotify[GridOptions::BottomEdgeAction] (o, GridOptions::BottomEdgeAction);
                return true;
            }
            break;
        case GridOptions::BottomRightCornerAction:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::BottomRightCornerAction].empty ())
                    mNotify[GridOptions::BottomRightCornerAction] (o, GridOptions::BottomRightCornerAction);
                return true;
            }
            break;
        case GridOptions::SnapbackWindows:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::SnapbackWindows].empty ())
                    mNotify[GridOptions::SnapbackWindows] (o, GridOptions::SnapbackWindows);
                return true;
            }
            break;
        case GridOptions::CycleSizes:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::CycleSizes].empty ())
                    mNotify[GridOptions::CycleSizes] (o, GridOptions::CycleSizes);
                return true;
            }
            break;
        case GridOptions::LeftEdgeThreshold:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::LeftEdgeThreshold].empty ())
                    mNotify[GridOptions::LeftEdgeThreshold] (o, GridOptions::LeftEdgeThreshold);
                return true;
            }
            break;
        case GridOptions::RightEdgeThreshold:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::RightEdgeThreshold].empty ())
                    mNotify[GridOptions::RightEdgeThreshold] (o, GridOptions::RightEdgeThreshold);
                return true;
            }
            break;
        case GridOptions::TopEdgeThreshold:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::TopEdgeThreshold].empty ())
                    mNotify[GridOptions::TopEdgeThreshold] (o, GridOptions::TopEdgeThreshold);
                return true;
            }
            break;
        case GridOptions::BottomEdgeThreshold:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::BottomEdgeThreshold].empty ())
                    mNotify[GridOptions::BottomEdgeThreshold] (o, GridOptions::BottomEdgeThreshold);
                return true;
            }
            break;
        case GridOptions::SnapoffThreshold:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::SnapoffThreshold].empty ())
                    mNotify[GridOptions::SnapoffThreshold] (o, GridOptions::SnapoffThreshold);
                return true;
            }
            break;
        case GridOptions::DrawIndicator:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::DrawIndicator].empty ())
                    mNotify[GridOptions::DrawIndicator] (o, GridOptions::DrawIndicator);
                return true;
            }
            break;
        case GridOptions::DrawStretchedWindow:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::DrawStretchedWindow].empty ())
                    mNotify[GridOptions::DrawStretchedWindow] (o, GridOptions::DrawStretchedWindow);
                return true;
            }
            break;
        case GridOptions::AnimationDuration:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::AnimationDuration].empty ())
                    mNotify[GridOptions::AnimationDuration] (o, GridOptions::AnimationDuration);
                return true;
            }
            break;
        case GridOptions::UseDesktopAverageColor:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::UseDesktopAverageColor].empty ())
                    mNotify[GridOptions::UseDesktopAverageColor] (o, GridOptions::UseDesktopAverageColor);
                return true;
            }
            break;
        case GridOptions::OutlineColor:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::OutlineColor].empty ())
                    mNotify[GridOptions::OutlineColor] (o, GridOptions::OutlineColor);
                return true;
            }
            break;
        case GridOptions::FillColor:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::FillColor].empty ())
                    mNotify[GridOptions::FillColor] (o, GridOptions::FillColor);
                return true;
            }
            break;
        case GridOptions::DisableBlend:
            if (o->set (value))
            {
                if (!mNotify[GridOptions::DisableBlend].empty ())
                    mNotify[GridOptions::DisableBlend] (o, GridOptions::DisableBlend);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

