/*
 * This file is autogenerated with bcop:
 * The Compiz option code generator
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */


#include <core/core.h>

#include "ring_options.h"

RingOptions::RingOptions (bool init /* = true */) :
    mOptions (RingOptions::OptionNum),
    mNotify (RingOptions::OptionNum)
{
    if (init)
        initOptions ();
}

void
RingOptions::initOptions ()
{
    unsigned int state;
    CompAction action;
    unsigned short color[4];

    // next_key
    mOptions[RingOptions::NextKey].setName ("next_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Super>Tab");
    mOptions[RingOptions::NextKey].value().set (action);
    if (screen) screen->addAction (&mOptions[RingOptions::NextKey].value ().action ());

    // next_button
    mOptions[RingOptions::NextButton].setName ("next_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[RingOptions::NextButton].value().set (action);
    if (screen) screen->addAction (&mOptions[RingOptions::NextButton].value ().action ());

    // prev_key
    mOptions[RingOptions::PrevKey].setName ("prev_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Super><Shift>Tab");
    mOptions[RingOptions::PrevKey].value().set (action);
    if (screen) screen->addAction (&mOptions[RingOptions::PrevKey].value ().action ());

    // prev_button
    mOptions[RingOptions::PrevButton].setName ("prev_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[RingOptions::PrevButton].value().set (action);
    if (screen) screen->addAction (&mOptions[RingOptions::PrevButton].value ().action ());

    // next_all_key
    mOptions[RingOptions::NextAllKey].setName ("next_all_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Super><Alt>Tab");
    mOptions[RingOptions::NextAllKey].value().set (action);
    if (screen) screen->addAction (&mOptions[RingOptions::NextAllKey].value ().action ());

    // next_all_button
    mOptions[RingOptions::NextAllButton].setName ("next_all_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[RingOptions::NextAllButton].value().set (action);
    if (screen) screen->addAction (&mOptions[RingOptions::NextAllButton].value ().action ());

    // prev_all_key
    mOptions[RingOptions::PrevAllKey].setName ("prev_all_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    action.keyFromString ("<Super><Shift><Alt>Tab");
    mOptions[RingOptions::PrevAllKey].value().set (action);
    if (screen) screen->addAction (&mOptions[RingOptions::PrevAllKey].value ().action ());

    // prev_all_button
    mOptions[RingOptions::PrevAllButton].setName ("prev_all_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[RingOptions::PrevAllButton].value().set (action);
    if (screen) screen->addAction (&mOptions[RingOptions::PrevAllButton].value ().action ());

    // next_group_key
    mOptions[RingOptions::NextGroupKey].setName ("next_group_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[RingOptions::NextGroupKey].value().set (action);
    if (screen) screen->addAction (&mOptions[RingOptions::NextGroupKey].value ().action ());

    // next_group_button
    mOptions[RingOptions::NextGroupButton].setName ("next_group_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[RingOptions::NextGroupButton].value().set (action);
    if (screen) screen->addAction (&mOptions[RingOptions::NextGroupButton].value ().action ());

    // prev_group_key
    mOptions[RingOptions::PrevGroupKey].setName ("prev_group_key", CompOption::TypeKey);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitKey);
    mOptions[RingOptions::PrevGroupKey].value().set (action);
    if (screen) screen->addAction (&mOptions[RingOptions::PrevGroupKey].value ().action ());

    // prev_group_button
    mOptions[RingOptions::PrevGroupButton].setName ("prev_group_button", CompOption::TypeButton);
    state = CompAction::StateAutoGrab;
    action = CompAction ();
    action.setState (state | CompAction::StateInitButton);
    mOptions[RingOptions::PrevGroupButton].value().set (action);
    if (screen) screen->addAction (&mOptions[RingOptions::PrevGroupButton].value ().action ());

    // window_match
    mOptions[RingOptions::WindowMatch].setName ("window_match", CompOption::TypeMatch);
    mOptions[RingOptions::WindowMatch].value().set(CompMatch ("Normal | Dialog | ModalDialog | Utility | Unknown"));
    mOptions[RingOptions::WindowMatch].value().match ().update ();

    // overlay_icon
    mOptions[RingOptions::OverlayIcon].setName ("overlay_icon", CompOption::TypeInt);
    mOptions[RingOptions::OverlayIcon].rest ().set (0, 2);
    mOptions[RingOptions::OverlayIcon].value().set((int) 1);

    // speed
    mOptions[RingOptions::Speed].setName ("speed", CompOption::TypeFloat);
    mOptions[RingOptions::Speed].rest ().set (0.1, 50.0, 0.1);
    mOptions[RingOptions::Speed].value().set((float) 1.5);

    // timestep
    mOptions[RingOptions::Timestep].setName ("timestep", CompOption::TypeFloat);
    mOptions[RingOptions::Timestep].rest ().set (0.1, 50.0, 0.1);
    mOptions[RingOptions::Timestep].value().set((float) 1.2);

    // inactive_opacity
    mOptions[RingOptions::InactiveOpacity].setName ("inactive_opacity", CompOption::TypeInt);
    mOptions[RingOptions::InactiveOpacity].rest ().set (1, 100);
    mOptions[RingOptions::InactiveOpacity].value().set((int) 100);

    // darken_back
    mOptions[RingOptions::DarkenBack].setName ("darken_back", CompOption::TypeBool);
    mOptions[RingOptions::DarkenBack].value().set(true);

    // minimized
    mOptions[RingOptions::Minimized].setName ("minimized", CompOption::TypeBool);
    mOptions[RingOptions::Minimized].value().set(true);

    // select_with_mouse
    mOptions[RingOptions::SelectWithMouse].setName ("select_with_mouse", CompOption::TypeBool);
    mOptions[RingOptions::SelectWithMouse].value().set(false);

    // ring_clockwise
    mOptions[RingOptions::RingClockwise].setName ("ring_clockwise", CompOption::TypeBool);
    mOptions[RingOptions::RingClockwise].value().set(false);

    // ring_width
    mOptions[RingOptions::RingWidth].setName ("ring_width", CompOption::TypeInt);
    mOptions[RingOptions::RingWidth].rest ().set (1, 100);
    mOptions[RingOptions::RingWidth].value().set((int) 70);

    // ring_height
    mOptions[RingOptions::RingHeight].setName ("ring_height", CompOption::TypeInt);
    mOptions[RingOptions::RingHeight].rest ().set (1, 100);
    mOptions[RingOptions::RingHeight].value().set((int) 60);

    // thumb_width
    mOptions[RingOptions::ThumbWidth].setName ("thumb_width", CompOption::TypeInt);
    mOptions[RingOptions::ThumbWidth].rest ().set (10, 1024);
    mOptions[RingOptions::ThumbWidth].value().set((int) 350);

    // thumb_height
    mOptions[RingOptions::ThumbHeight].setName ("thumb_height", CompOption::TypeInt);
    mOptions[RingOptions::ThumbHeight].rest ().set (10, 1024);
    mOptions[RingOptions::ThumbHeight].value().set((int) 250);

    // min_brightness
    mOptions[RingOptions::MinBrightness].setName ("min_brightness", CompOption::TypeFloat);
    mOptions[RingOptions::MinBrightness].rest ().set (0.1, 1.0, 0.01);
    mOptions[RingOptions::MinBrightness].value().set((float) 0.5);

    // min_scale
    mOptions[RingOptions::MinScale].setName ("min_scale", CompOption::TypeFloat);
    mOptions[RingOptions::MinScale].rest ().set (0.1, 1.0, 0.01);
    mOptions[RingOptions::MinScale].value().set((float) 0.4);

    // window_title
    mOptions[RingOptions::WindowTitle].setName ("window_title", CompOption::TypeBool);
    mOptions[RingOptions::WindowTitle].value().set(true);

    // title_font_bold
    mOptions[RingOptions::TitleFontBold].setName ("title_font_bold", CompOption::TypeBool);
    mOptions[RingOptions::TitleFontBold].value().set(false);

    // title_font_size
    mOptions[RingOptions::TitleFontSize].setName ("title_font_size", CompOption::TypeInt);
    mOptions[RingOptions::TitleFontSize].rest ().set (6, 96);
    mOptions[RingOptions::TitleFontSize].value().set((int) 16);

    // title_back_color
    mOptions[RingOptions::TitleBackColor].setName ("title_back_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0x0000));
    color[1] = MAX (0, MIN (0xffff, 0x0000));
    color[2] = MAX (0, MIN (0xffff, 0x0000));
    color[3] = MAX (0, MIN (0xffff, 0x9999));
    mOptions[RingOptions::TitleBackColor].value().set(color);

    // title_font_color
    mOptions[RingOptions::TitleFontColor].setName ("title_font_color", CompOption::TypeColor);
    color[0] = MAX (0, MIN (0xffff, 0xffff));
    color[1] = MAX (0, MIN (0xffff, 0xffff));
    color[2] = MAX (0, MIN (0xffff, 0xffff));
    color[3] = MAX (0, MIN (0xffff, 0xffff));
    mOptions[RingOptions::TitleFontColor].value().set(color);

    // title_text_placement
    mOptions[RingOptions::TitleTextPlacement].setName ("title_text_placement", CompOption::TypeInt);
    mOptions[RingOptions::TitleTextPlacement].rest ().set (0, 2);
    mOptions[RingOptions::TitleTextPlacement].value().set((int) 0);

    // vertical_offset
    mOptions[RingOptions::VerticalOffset].setName ("vertical_offset", CompOption::TypeInt);
    mOptions[RingOptions::VerticalOffset].rest ().set (0, 500);
    mOptions[RingOptions::VerticalOffset].value().set((int) 50);

}

RingOptions::~RingOptions ()
{
}


CompOption::Vector &
RingOptions::getOptions ()
{
    return mOptions;
}

bool
RingOptions::setOption (const CompString &name, CompOption::Value &value)
{
    CompOption   *o;
    unsigned int index;

    o = CompOption::findOption (mOptions, name, &index);

    if (!o)
        return false;

    switch (index)
    {
        case RingOptions::NextKey:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::NextKey].empty ())
                    mNotify[RingOptions::NextKey] (o, RingOptions::NextKey);
                return true;
            }
            break;
        case RingOptions::NextButton:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::NextButton].empty ())
                    mNotify[RingOptions::NextButton] (o, RingOptions::NextButton);
                return true;
            }
            break;
        case RingOptions::PrevKey:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::PrevKey].empty ())
                    mNotify[RingOptions::PrevKey] (o, RingOptions::PrevKey);
                return true;
            }
            break;
        case RingOptions::PrevButton:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::PrevButton].empty ())
                    mNotify[RingOptions::PrevButton] (o, RingOptions::PrevButton);
                return true;
            }
            break;
        case RingOptions::NextAllKey:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::NextAllKey].empty ())
                    mNotify[RingOptions::NextAllKey] (o, RingOptions::NextAllKey);
                return true;
            }
            break;
        case RingOptions::NextAllButton:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::NextAllButton].empty ())
                    mNotify[RingOptions::NextAllButton] (o, RingOptions::NextAllButton);
                return true;
            }
            break;
        case RingOptions::PrevAllKey:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::PrevAllKey].empty ())
                    mNotify[RingOptions::PrevAllKey] (o, RingOptions::PrevAllKey);
                return true;
            }
            break;
        case RingOptions::PrevAllButton:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::PrevAllButton].empty ())
                    mNotify[RingOptions::PrevAllButton] (o, RingOptions::PrevAllButton);
                return true;
            }
            break;
        case RingOptions::NextGroupKey:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::NextGroupKey].empty ())
                    mNotify[RingOptions::NextGroupKey] (o, RingOptions::NextGroupKey);
                return true;
            }
            break;
        case RingOptions::NextGroupButton:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::NextGroupButton].empty ())
                    mNotify[RingOptions::NextGroupButton] (o, RingOptions::NextGroupButton);
                return true;
            }
            break;
        case RingOptions::PrevGroupKey:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::PrevGroupKey].empty ())
                    mNotify[RingOptions::PrevGroupKey] (o, RingOptions::PrevGroupKey);
                return true;
            }
            break;
        case RingOptions::PrevGroupButton:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::PrevGroupButton].empty ())
                    mNotify[RingOptions::PrevGroupButton] (o, RingOptions::PrevGroupButton);
                return true;
            }
            break;
        case RingOptions::WindowMatch:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::WindowMatch].empty ())
                    mNotify[RingOptions::WindowMatch] (o, RingOptions::WindowMatch);
                return true;
            }
            break;
        case RingOptions::OverlayIcon:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::OverlayIcon].empty ())
                    mNotify[RingOptions::OverlayIcon] (o, RingOptions::OverlayIcon);
                return true;
            }
            break;
        case RingOptions::Speed:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::Speed].empty ())
                    mNotify[RingOptions::Speed] (o, RingOptions::Speed);
                return true;
            }
            break;
        case RingOptions::Timestep:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::Timestep].empty ())
                    mNotify[RingOptions::Timestep] (o, RingOptions::Timestep);
                return true;
            }
            break;
        case RingOptions::InactiveOpacity:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::InactiveOpacity].empty ())
                    mNotify[RingOptions::InactiveOpacity] (o, RingOptions::InactiveOpacity);
                return true;
            }
            break;
        case RingOptions::DarkenBack:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::DarkenBack].empty ())
                    mNotify[RingOptions::DarkenBack] (o, RingOptions::DarkenBack);
                return true;
            }
            break;
        case RingOptions::Minimized:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::Minimized].empty ())
                    mNotify[RingOptions::Minimized] (o, RingOptions::Minimized);
                return true;
            }
            break;
        case RingOptions::SelectWithMouse:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::SelectWithMouse].empty ())
                    mNotify[RingOptions::SelectWithMouse] (o, RingOptions::SelectWithMouse);
                return true;
            }
            break;
        case RingOptions::RingClockwise:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::RingClockwise].empty ())
                    mNotify[RingOptions::RingClockwise] (o, RingOptions::RingClockwise);
                return true;
            }
            break;
        case RingOptions::RingWidth:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::RingWidth].empty ())
                    mNotify[RingOptions::RingWidth] (o, RingOptions::RingWidth);
                return true;
            }
            break;
        case RingOptions::RingHeight:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::RingHeight].empty ())
                    mNotify[RingOptions::RingHeight] (o, RingOptions::RingHeight);
                return true;
            }
            break;
        case RingOptions::ThumbWidth:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::ThumbWidth].empty ())
                    mNotify[RingOptions::ThumbWidth] (o, RingOptions::ThumbWidth);
                return true;
            }
            break;
        case RingOptions::ThumbHeight:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::ThumbHeight].empty ())
                    mNotify[RingOptions::ThumbHeight] (o, RingOptions::ThumbHeight);
                return true;
            }
            break;
        case RingOptions::MinBrightness:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::MinBrightness].empty ())
                    mNotify[RingOptions::MinBrightness] (o, RingOptions::MinBrightness);
                return true;
            }
            break;
        case RingOptions::MinScale:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::MinScale].empty ())
                    mNotify[RingOptions::MinScale] (o, RingOptions::MinScale);
                return true;
            }
            break;
        case RingOptions::WindowTitle:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::WindowTitle].empty ())
                    mNotify[RingOptions::WindowTitle] (o, RingOptions::WindowTitle);
                return true;
            }
            break;
        case RingOptions::TitleFontBold:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::TitleFontBold].empty ())
                    mNotify[RingOptions::TitleFontBold] (o, RingOptions::TitleFontBold);
                return true;
            }
            break;
        case RingOptions::TitleFontSize:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::TitleFontSize].empty ())
                    mNotify[RingOptions::TitleFontSize] (o, RingOptions::TitleFontSize);
                return true;
            }
            break;
        case RingOptions::TitleBackColor:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::TitleBackColor].empty ())
                    mNotify[RingOptions::TitleBackColor] (o, RingOptions::TitleBackColor);
                return true;
            }
            break;
        case RingOptions::TitleFontColor:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::TitleFontColor].empty ())
                    mNotify[RingOptions::TitleFontColor] (o, RingOptions::TitleFontColor);
                return true;
            }
            break;
        case RingOptions::TitleTextPlacement:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::TitleTextPlacement].empty ())
                    mNotify[RingOptions::TitleTextPlacement] (o, RingOptions::TitleTextPlacement);
                return true;
            }
            break;
        case RingOptions::VerticalOffset:
            if (o->set (value))
            {
                if (!mNotify[RingOptions::VerticalOffset].empty ())
                    mNotify[RingOptions::VerticalOffset] (o, RingOptions::VerticalOffset);
                return true;
            }
            break;
        default:
            break;
    }
    return false;

}

