/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.jmask;

import blue.components.lines.LineBoundaryDialog;
import blue.soundObject.editor.jmask.TableCanvas;
import blue.soundObject.jmask.Table;
import blue.utility.NumberUtilities;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TableEditor
extends JPanel
implements PropertyChangeListener {
    Table table = null;
    boolean positivesOnly = false;
    boolean updating = false;
    private JComboBox interpolationComboBox;
    private JSpinner interpolationSpinner;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel maxLabel;
    private JTextField maxTextField;
    private JLabel minLabel;
    private JTextField minTextField;
    private TableCanvas tableCanvas;

    public TableEditor() {
        this.initComponents();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.table != null) {
            this.table.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.table != null) {
            this.table.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void setDuration(double duration) {
        this.tableCanvas.setDuration(duration);
    }

    public void setPositiveValues() {
        this.positivesOnly = true;
    }

    public void setMinMaxEnabled(boolean enabled) {
        this.minTextField.setText("");
        this.maxTextField.setText("");
        this.minTextField.setEnabled(enabled);
        this.maxTextField.setEnabled(enabled);
    }

    public void setTable(Table table) {
        if (this.table != null) {
            this.table.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.table = null;
        this.interpolationComboBox.setSelectedIndex(table.getInterpolationType());
        this.interpolationSpinner.setValue(new Double(table.getInterpolation()));
        this.minTextField.setText(NumberUtilities.formatDouble((double)table.getMin()));
        this.maxTextField.setText(NumberUtilities.formatDouble((double)table.getMax()));
        this.table = table;
        if (this.table != null) {
            this.table.addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.tableCanvas.setTable(table);
    }

    private void initComponents() {
        this.tableCanvas = new TableCanvas();
        this.interpolationComboBox = new JComboBox();
        this.interpolationSpinner = new JSpinner();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.minLabel = new JLabel();
        this.maxLabel = new JLabel();
        this.minTextField = new JTextField();
        this.maxTextField = new JTextField();
        GroupLayout tableCanvasLayout = new GroupLayout(this.tableCanvas);
        this.tableCanvas.setLayout(tableCanvasLayout);
        tableCanvasLayout.setHorizontalGroup(tableCanvasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 659, Short.MAX_VALUE));
        tableCanvasLayout.setVerticalGroup(tableCanvasLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.interpolationComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Off", "On", "Cos"}));
        this.interpolationComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableEditor.this.interpolationComboBoxActionPerformed(evt);
            }
        });
        this.interpolationSpinner.setModel(new SpinnerNumberModel(new Double(0.0), null, null, new Double(0.1)));
        this.interpolationSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                TableEditor.this.interpolationSpinnerStateChanged(evt);
            }
        });
        this.jLabel1.setText("Interpolation Type");
        this.jLabel2.setText("Interpolation Value");
        this.minLabel.setText("Min");
        this.maxLabel.setText("Max");
        this.minTextField.setText("jTextField1");
        this.minTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableEditor.this.minTextFieldActionPerformed(evt);
            }
        });
        this.minTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                TableEditor.this.minTextFieldFocusLost(evt);
            }
        });
        this.maxTextField.setText("jTextField2");
        this.maxTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TableEditor.this.maxTextFieldActionPerformed(evt);
            }
        });
        this.maxTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                TableEditor.this.maxTextFieldFocusLost(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tableCanvas, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.interpolationComboBox, -2, 77, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.interpolationSpinner, -2, 77, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.minLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.minTextField, -2, 71, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.maxLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxTextField, -2, 77, -2)));
        layout.linkSize(0, this.interpolationComboBox, this.interpolationSpinner, this.maxTextField, this.minTextField);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.tableCanvas, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.interpolationComboBox, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.interpolationSpinner, -2, -1, -2).addComponent(this.minLabel).addComponent(this.maxLabel).addComponent(this.minTextField, -2, -1, -2).addComponent(this.maxTextField, -2, -1, -2))));
    }

    private void interpolationComboBoxActionPerformed(ActionEvent evt) {
        if (this.table != null) {
            this.table.setInterpolationType(this.interpolationComboBox.getSelectedIndex());
        }
    }

    private void interpolationSpinnerStateChanged(ChangeEvent evt) {
        if (this.table != null) {
            this.table.setInterpolation(((Double)this.interpolationSpinner.getValue()).doubleValue());
        }
    }

    private void maxTextFieldActionPerformed(ActionEvent evt) {
        this.updateMax();
    }

    private void minTextFieldActionPerformed(ActionEvent evt) {
        this.updateMin();
    }

    private void minTextFieldFocusLost(FocusEvent evt) {
        if (!this.updating) {
            this.minTextField.setText(NumberUtilities.formatDouble((double)this.table.getMin()));
        }
    }

    private void maxTextFieldFocusLost(FocusEvent evt) {
        if (!this.updating) {
            this.maxTextField.setText(NumberUtilities.formatDouble((double)this.table.getMax()));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.table) {
            this.repaint();
        }
    }

    private void updateMax() {
        double newValue;
        if (this.updating) {
            return;
        }
        this.updating = true;
        try {
            newValue = Double.parseDouble(this.maxTextField.getText());
        }
        catch (NumberFormatException nfe) {
            this.maxTextField.setText(NumberUtilities.formatDouble((double)this.table.getMax()));
            this.updating = false;
            return;
        }
        if (newValue <= this.table.getMin()) {
            this.maxTextField.setText(NumberUtilities.formatDouble((double)this.table.getMax()));
            this.updating = false;
            return;
        }
        if (this.positivesOnly && newValue <= 0.0) {
            this.maxTextField.setText(NumberUtilities.formatDouble((double)this.table.getMax()));
            this.updating = false;
            return;
        }
        String retVal = LineBoundaryDialog.getLinePointMethod();
        if (retVal == null) {
            this.maxTextField.setText(NumberUtilities.formatDouble((double)this.table.getMax()));
            this.updating = false;
            return;
        }
        boolean truncate = retVal.equals("Truncate");
        this.table.setMax(newValue, truncate);
        this.updating = false;
    }

    private void updateMin() {
        double newValue;
        if (this.updating) {
            return;
        }
        this.updating = true;
        try {
            newValue = Double.parseDouble(this.minTextField.getText());
        }
        catch (NumberFormatException nfe) {
            this.minTextField.setText(NumberUtilities.formatDouble((double)this.table.getMin()));
            this.updating = false;
            return;
        }
        if (newValue >= this.table.getMax()) {
            this.minTextField.setText(NumberUtilities.formatDouble((double)this.table.getMin()));
            this.updating = false;
            return;
        }
        if (this.positivesOnly && newValue <= 0.0) {
            this.minTextField.setText(NumberUtilities.formatDouble((double)this.table.getMin()));
            this.updating = false;
            return;
        }
        String retVal = LineBoundaryDialog.getLinePointMethod();
        if (retVal == null) {
            this.minTextField.setText(NumberUtilities.formatDouble((double)this.table.getMin()));
            this.updating = false;
            return;
        }
        boolean truncate = retVal.equals("Truncate");
        this.table.setMin(newValue, truncate);
        this.updating = false;
    }
}

