/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.jmask.probability;

import blue.soundObject.editor.jmask.DurationSettable;
import blue.soundObject.editor.jmask.TableEditor;
import blue.soundObject.jmask.probability.Exponential;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ExponentialEditor
extends JPanel
implements DurationSettable {
    Exponential exponential = null;
    private JComboBox directionComboBox;
    private JLabel jLabel1;
    private ButtonGroup lambdaButtonGroup;
    private JSpinner lambdaSpinner;
    private TableEditor lambdaTableEditor;
    private JComboBox lambdaTypeComboBox;

    public ExponentialEditor(Exponential exponential) {
        this.initComponents();
        this.lambdaTableEditor.setPositiveValues();
        this.lambdaTableEditor.setTable(exponential.getLambdaTable());
        this.lambdaSpinner.setModel(new SpinnerNumberModel(exponential.getLambda(), Double.MIN_VALUE, Double.MAX_VALUE, 0.1));
        this.directionComboBox.setSelectedIndex(exponential.getDirection());
        this.lambdaTypeComboBox.setSelectedIndex(exponential.isLambdaTableEnabled() ? 1 : 0);
        this.exponential = exponential;
        this.updateDisplay();
    }

    private void updateDisplay() {
        this.lambdaSpinner.setVisible(!this.exponential.isLambdaTableEnabled());
        this.lambdaTableEditor.setVisible(this.exponential.isLambdaTableEnabled());
    }

    private void initComponents() {
        this.lambdaButtonGroup = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.directionComboBox = new JComboBox();
        this.lambdaSpinner = new JSpinner();
        this.lambdaTableEditor = new TableEditor();
        this.lambdaTypeComboBox = new JComboBox();
        this.jLabel1.setText("Direction");
        this.directionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Decreasing", "Increasing", "Bilateral"}));
        this.directionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExponentialEditor.this.directionComboBoxActionPerformed(evt);
            }
        });
        this.lambdaSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ExponentialEditor.this.lambdaSpinnerStateChanged(evt);
            }
        });
        this.lambdaTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Lambda (Constant)", "Lambda (Table)"}));
        this.lambdaTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExponentialEditor.this.lambdaTypeComboBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.directionComboBox, 0, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.lambdaTypeComboBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lambdaSpinner, -2, 84, -2))).addComponent(this.lambdaTableEditor, -2, 445, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.directionComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lambdaSpinner, -2, -1, -2).addComponent(this.lambdaTypeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lambdaTableEditor, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void lambdaSpinnerStateChanged(ChangeEvent evt) {
        if (this.exponential != null) {
            this.exponential.setLambda(((Double)this.lambdaSpinner.getValue()).doubleValue());
        }
    }

    private void directionComboBoxActionPerformed(ActionEvent evt) {
        if (this.exponential != null) {
            this.exponential.setDirection(this.directionComboBox.getSelectedIndex());
        }
    }

    private void lambdaTypeComboBoxActionPerformed(ActionEvent evt) {
        if (this.exponential != null) {
            this.exponential.setLambdaTableEnabled(this.lambdaTypeComboBox.getSelectedIndex() == 1);
            this.updateDisplay();
        }
    }

    @Override
    public void setDuration(double duration) {
        this.lambdaTableEditor.setDuration(duration);
    }
}

