/*
 * Decompiled with CFR 0.152.
 */
package blue.tools.ftableConverter;

import blue.BlueSystem;
import blue.WindowSettingManager;
import blue.WindowSettingsSavable;
import blue.utility.GUI;
import electric.xml.Element;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

public class FTableConverterDialog
extends JDialog
implements WindowSettingsSavable {
    private JButton convertButton;
    private JTextArea fStatementText;
    private JTextArea ftgenText;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;

    public FTableConverterDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setTitle(BlueSystem.getString((String)"ftableConverter.text"));
        GUI.centerOnScreen((Component)this);
        WindowSettingManager.getInstance().registerWindow("FtableConverterDialog", this);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.ftgenText = new JTextArea();
        this.jScrollPane2 = new JScrollPane();
        this.fStatementText = new JTextArea();
        this.convertButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("");
        this.ftgenText.setColumns(20);
        this.ftgenText.setRows(5);
        this.jScrollPane1.setViewportView(this.ftgenText);
        this.fStatementText.setColumns(20);
        this.fStatementText.setRows(5);
        this.jScrollPane2.setViewportView(this.fStatementText);
        this.convertButton.setText("Convert to FTGEN");
        this.convertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FTableConverterDialog.this.convertButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 510, Short.MAX_VALUE).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 510, Short.MAX_VALUE).addComponent(this.convertButton, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2, -2, 185, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.convertButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 203, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void convertButtonActionPerformed(ActionEvent evt) {
        String text = this.fStatementText.getText();
        String[] lines = text.split("\n");
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < lines.length; ++i) {
            String startLine;
            String line = lines[i].substring(lines[i].indexOf("f") + 1);
            int commentIndex = line.indexOf(";");
            String comment = "";
            if (commentIndex >= 0) {
                comment = "\t" + line.substring(commentIndex);
                line = line.substring(0, commentIndex);
            }
            line = line.trim();
            String[] pfields = line.split("\\s+");
            String newLine = startLine = "gi_\tftgen 0";
            for (int j = 1; j < pfields.length; ++j) {
                newLine = newLine + ", " + pfields[j];
            }
            if (newLine.equals(startLine)) {
                newLine = "\n";
            }
            buffer.append(newLine).append(comment).append("\n");
        }
        this.ftgenText.setText(buffer.toString());
    }

    public static void main(String[] args) {
        GUI.setBlueLookAndFeel();
        EventQueue.invokeLater(() -> new FTableConverterDialog((Frame)new JFrame(), true).setVisible(true));
    }

    @Override
    public void loadWindowSettings(Element settings) {
        WindowSettingManager.setBasicSettings(settings, this);
    }

    @Override
    public Element saveWindowSettings() {
        return WindowSettingManager.getBasicSettings(this);
    }
}

