/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.orchestra.editor.blueX7;

import blue.gui.LabelledRangeBar;
import blue.orchestra.blueX7.Operator;
import blue.utility.GUI;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

public class OscilatorPanel
extends JComponent {
    JLabel oscilatorLabel = new JLabel();
    JComboBox modeCombo;
    public JComboBox syncCombo;
    LabelledRangeBar freqCoarse = new LabelledRangeBar("Frequency Coarse ", 0, 31);
    LabelledRangeBar freqFine = new LabelledRangeBar("Frequency Fine ", 0, 99);
    LabelledRangeBar detune = new LabelledRangeBar("Detune ", -7, 7);
    Operator op;
    boolean isUpdatingData = false;

    public OscilatorPanel() {
        this.setOscilatorLabel();
        Vector<String> items = new Vector<String>(2);
        items.add("Ratio");
        items.add("Fixed (Hz)");
        this.modeCombo = new JComboBox(items);
        items = new Vector(2);
        items.add("Off");
        items.add("On");
        this.syncCombo = new JComboBox(items);
        JPanel modePanel = new JPanel(new FlowLayout(1));
        modePanel.add(new JLabel("Mode "));
        modePanel.add(this.modeCombo);
        modePanel.add(new JLabel(" Sync (*)"));
        modePanel.add(this.syncCombo);
        this.setLayout(new GridLayout(5, 1));
        this.add(this.oscilatorLabel);
        this.add(modePanel);
        this.add(this.freqCoarse);
        this.add(this.freqFine);
        this.add(this.detune);
        ChangeListener cl = e -> this.checkData();
        this.freqCoarse.addChangeListener(cl);
        this.freqFine.addChangeListener(cl);
        this.detune.addChangeListener(cl);
        ActionListener al = ae -> this.checkData();
        this.modeCombo.addActionListener(al);
        this.syncCombo.addActionListener(al);
    }

    public void checkData() {
        if (this.isUpdatingData) {
            return;
        }
        if (this.op == null) {
            return;
        }
        this.op.freqCoarse = this.freqCoarse.getValue();
        this.op.freqFine = this.freqFine.getValue();
        this.op.detune = this.detune.getValue();
        this.op.mode = this.modeCombo.getSelectedIndex();
        this.op.sync = this.syncCombo.getSelectedIndex();
    }

    public void editOperator(Operator op) {
        this.isUpdatingData = true;
        if (op == null) {
            return;
        }
        this.op = null;
        this.modeCombo.setSelectedIndex(op.mode);
        this.syncCombo.setSelectedIndex(op.sync);
        this.freqCoarse.setValue(op.freqCoarse);
        this.freqFine.setValue(op.freqFine);
        this.detune.setValue(op.detune);
        this.op = op;
        this.isUpdatingData = false;
    }

    private void setOscilatorLabel() {
        this.oscilatorLabel.setText("[ Oscilator ]");
    }

    public static void main(String[] args) {
        OscilatorPanel oscilatorPanel1 = new OscilatorPanel();
        GUI.showComponentAsStandalone((Component)oscilatorPanel1, (String)"OscilatorPanel test", (boolean)true);
    }
}

