/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.render;

import blue.BlueData;
import blue.CompileData;
import blue.LiveData;
import blue.blueLive.LiveObject;
import blue.blueLive.LiveObjectSet;
import blue.services.render.CsoundBinding;
import blue.soundObject.NoteList;
import blue.soundObject.SoundObject;
import blue.ui.core.blueLive.BlueLiveToolBar;
import blue.utility.ScoreUtilities;
import java.util.Collection;
import org.openide.util.Exceptions;

public class BlueLiveBinding
implements CsoundBinding {
    long counter = 0L;
    private final LiveData data;
    private double sr;
    private long ksmps;
    CompileData compileData = CompileData.createEmptyCompileData();
    private final BlueData blueData;

    public BlueLiveBinding(BlueData data) {
        this.blueData = data;
        this.data = data.getLiveData();
    }

    public void setup(double sr, long ksmps) {
        this.sr = sr;
        this.ksmps = ksmps;
        this.counter = 0L;
    }

    public void updateValueToCsound() {
        if (this.data.isRepeatEnabled()) {
            long samplesToWait = (long)(60.0 / (double)this.data.getTempo() * (double)this.data.getRepeat() * this.sr);
            if (this.counter + this.ksmps >= samplesToWait) {
                this.counter -= samplesToWait;
                this.triggerLiveData();
            }
            this.counter += this.ksmps;
        } else {
            this.counter = 0L;
        }
    }

    public void updateValueFromCsound() {
    }

    public void cleanup() {
    }

    protected void triggerLiveData() {
        LiveObjectSet liveObjects = this.data.getLiveObjectBins().getEnabledLiveObjectSet();
        if (liveObjects.size() > 0) {
            NoteList nl = new NoteList();
            try {
                for (LiveObject liveObj : liveObjects) {
                    SoundObject sObj = liveObj.getSoundObject();
                    if (sObj.getTimeBehavior() != -1) {
                        sObj.setTimeBehavior(2);
                    }
                    nl.addAll((Collection)sObj.generateForCSD(this.compileData, 0.0, -1.0));
                }
            }
            catch (Exception e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            ScoreUtilities.scaleScore((NoteList)nl, (double)(60.0f / (float)this.data.getTempo()));
            String scoreText = nl.toString();
            if (scoreText != null && scoreText.length() > 0) {
                BlueLiveToolBar.getInstance().sendEvents(scoreText);
            }
        }
    }
}

