/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.manager;

import blue.score.layers.Layer;
import blue.score.layers.LayerGroup;
import javax.swing.table.AbstractTableModel;

public class LayersTableModel
extends AbstractTableModel {
    private final LayerGroup<Layer> layerGroup;

    public LayersTableModel(LayerGroup layerGroup) {
        this.layerGroup = layerGroup;
    }

    @Override
    public int getRowCount() {
        return this.layerGroup.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            ((Layer)this.layerGroup.get(rowIndex)).setName((String)aValue);
        }
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return rowIndex;
        }
        return ((Layer)this.layerGroup.get(rowIndex)).getName();
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "#";
            }
            case 1: {
                return "Name";
            }
        }
        return "";
    }

    public void removeLayers(int start, int end) {
        this.layerGroup.removeLayers(start, end);
        this.fireTableRowsDeleted(start, end);
    }

    public void newLayerAt(int index) {
        this.layerGroup.newLayerAt(index);
        this.fireTableRowsInserted(index, index);
    }

    public void pushUpLayers(int start, int end) {
        this.layerGroup.pushUpLayers(start, end);
        this.fireTableRowsUpdated(start - 1, end);
    }

    void pushDownLayers(int start, int end) {
        this.layerGroup.pushDownLayers(start, end);
        this.fireTableRowsUpdated(start, end + 1);
    }
}

