/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.noteProcessorChain;

import blue.noteProcessor.Code;
import blue.ui.nbutilities.MimeTypeEditorComponent;
import blue.utility.GUI;
import com.l2fprod.common.swing.BaseDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.undo.UndoManager;
import org.openide.awt.UndoRedo;
import org.openide.windows.WindowManager;

public class CodeEditor
extends JComponent {
    Vector listeners = new Vector();
    private static CodeEditDialog codeDialog = null;
    JButton button;
    JLabel label;
    Code code;

    public CodeEditor() {
        this.setLayout(new BorderLayout(0, 0));
        this.button = new JButton("...");
        this.add((Component)this.button, "East");
        this.button.setMargin(new Insets(0, 0, 0, 0));
        this.button.addActionListener(e -> this.editCode());
        this.label = new JLabel();
        this.add((Component)this.label, "Center");
    }

    public void addActionListener(ActionListener al) {
        this.listeners.add(al);
    }

    public void removeActionListener(ActionListener al) {
        this.listeners.remove(al);
    }

    public void fireActionPerformed() {
        ActionEvent ae = new ActionEvent(this, 1001, "scale");
        for (ActionListener al : this.listeners) {
            al.actionPerformed(ae);
        }
    }

    protected void editCode() {
        if (codeDialog == null) {
            codeDialog = new CodeEditDialog(WindowManager.getDefault().getMainWindow());
            codeDialog.setSize(400, 400);
            GUI.centerOnScreen((Component)((Object)codeDialog));
        }
        codeDialog.setCodeText(this.code.getCode());
        boolean retVal = codeDialog.ask();
        if (!retVal) {
            this.fireActionPerformed();
            return;
        }
        this.code.setCode(codeDialog.getCodeText());
        this.fireActionPerformed();
    }

    public Code getCode() {
        return this.code;
    }

    public void setCode(Code code) {
        this.code = code;
        this.label.setText(code.toString());
    }

    private static class CodeEditDialog
    extends BaseDialog {
        MimeTypeEditorComponent editor = new MimeTypeEditorComponent("text/x-python");
        UndoManager undo = new UndoRedo.Manager();

        public CodeEditDialog(Frame parent) {
            super(parent, "Edit Code", true);
            this.getBanner().setVisible(false);
            this.setDefaultCloseOperation(1);
            Container contentPane = this.getContentPane();
            contentPane.setLayout(new BorderLayout());
            contentPane.add((Component)this.editor, "Center");
            this.editor.setUndoManager(this.undo);
            this.editor.getDocument().addUndoableEditListener(this.undo);
        }

        public void setCodeText(String code) {
            this.editor.setText(code);
            this.undo.discardAllEdits();
        }

        public String getCodeText() {
            return this.editor.getText();
        }
    }
}

