/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.tempo;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class TempoMinMaxDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private ButtonGroup buttonGroup1;
    private JButton cancelButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField maxTextField;
    private JTextField minTextField;
    private JButton okButton;
    private JRadioButton scaleRadioButton;
    private JRadioButton truncateRadioButton;
    private int returnStatus = 0;

    public TempoMinMaxDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    public void setValues(double min, double max) {
        this.minTextField.setText(Double.toString(min));
        this.maxTextField.setText(Double.toString(max));
        this.truncateRadioButton.setSelected(true);
    }

    public double getMin() {
        return Double.parseDouble(this.minTextField.getText());
    }

    public double getMax() {
        return Double.parseDouble(this.maxTextField.getText());
    }

    public boolean isTruncate() {
        return this.truncateRadioButton.isSelected();
    }

    public boolean validateForm() {
        double min;
        double max;
        Object error = null;
        try {
            max = Double.parseDouble(this.maxTextField.getText().trim());
        }
        catch (NumberFormatException nfe) {
            this.showError("Max value was not a number.");
            return false;
        }
        if (max < 0.0) {
            this.showError("Max can not be less than 0.");
            return false;
        }
        try {
            min = Double.parseDouble(this.minTextField.getText().trim());
        }
        catch (NumberFormatException nfe) {
            this.showError("Min value was not a number");
            return false;
        }
        if (min < 0.0) {
            this.showError("Min can not be less than 0.");
            return false;
        }
        if (min > max) {
            this.showError("Max can not be less than Min.");
            return false;
        }
        return true;
    }

    private void showError(String message) {
        JOptionPane.showMessageDialog(this, message, "Error", 0);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.truncateRadioButton = new JRadioButton();
        this.scaleRadioButton = new JRadioButton();
        this.maxTextField = new JTextField();
        this.minTextField = new JTextField();
        this.setTitle("Tempo Min/Max");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TempoMinMaxDialog.this.closeDialog(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TempoMinMaxDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TempoMinMaxDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("BPM Max:");
        this.jLabel2.setText("BPM Min:");
        this.buttonGroup1.add(this.truncateRadioButton);
        this.truncateRadioButton.setText("Truncate");
        this.buttonGroup1.add(this.scaleRadioButton);
        this.scaleRadioButton.setText("Scale");
        this.maxTextField.setText("jTextField1");
        this.minTextField.setText("jTextField2");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.okButton, -2, 67, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.truncateRadioButton).addComponent(this.scaleRadioButton).addComponent(this.maxTextField, -1, 153, Short.MAX_VALUE).addComponent(this.minTextField, -1, 153, Short.MAX_VALUE)))).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.maxTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.minTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.truncateRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scaleRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateForm()) {
            this.doClose(1);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(() -> {
            TempoMinMaxDialog dialog = new TempoMinMaxDialog((Frame)new JFrame(), true);
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    System.exit(0);
                }
            });
            dialog.setVisible(true);
        });
    }
}

