/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.undo;

import blue.BlueSystem;
import blue.score.ScoreObject;
import blue.score.layers.ScoreObjectLayer;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class ReplaceScoreObjectEdit
extends AbstractUndoableEdit {
    private ScoreObject oldSObj;
    private ScoreObject newSObj;
    private ScoreObjectLayer layer;
    private ReplaceScoreObjectEdit nextEdit = null;

    public ReplaceScoreObjectEdit(ScoreObjectLayer layer, ScoreObject sObjOld, ScoreObject sObjNew) {
        this.layer = layer;
        this.oldSObj = sObjOld;
        this.newSObj = sObjNew;
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.layer.remove(this.oldSObj);
        this.layer.add((Object)this.newSObj);
        if (this.nextEdit != null) {
            this.nextEdit.redo();
        }
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.layer.remove(this.newSObj);
        this.layer.add((Object)this.oldSObj);
        if (this.nextEdit != null) {
            this.nextEdit.undo();
        }
    }

    @Override
    public String getPresentationName() {
        return BlueSystem.getString((String)"scoreGUI.action.replaceSoundObject");
    }

    @Override
    public boolean addEdit(UndoableEdit anEdit) {
        if (anEdit instanceof ReplaceScoreObjectEdit) {
            if (this.nextEdit == null) {
                this.nextEdit = (ReplaceScoreObjectEdit)anEdit;
                return true;
            }
            return this.nextEdit.addEdit(anEdit);
        }
        return false;
    }
}

