/*
 * Decompiled with CFR 0.152.
 */
package blue.automation;

import electric.xml.Element;
import electric.xml.Elements;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ParameterIdList
implements Iterable<String> {
    private static final Comparator comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            return s1.compareToIgnoreCase(s2);
        }
    };
    private ArrayList<String> parameters;
    private int selectedIndex = -1;
    transient Vector listListeners = null;
    transient Vector listSelectionListeners = null;

    public ParameterIdList() {
        this.parameters = new ArrayList();
    }

    public ParameterIdList(ParameterIdList pil) {
        this.parameters = new ArrayList<String>(pil.parameters);
        this.selectedIndex = pil.selectedIndex;
    }

    public String getParameterId(int index) {
        return this.parameters.get(index);
    }

    public void addParameterId(String parameterId) {
        this.parameters.add(parameterId);
        String current = null;
        if (this.getSelectedIndex() > 0) {
            current = this.getParameterId(this.getSelectedIndex());
        }
        Collections.sort(this.parameters, comparator);
        int index = this.parameters.indexOf(parameterId);
        ListDataEvent lde = new ListDataEvent(this, 1, index, index);
        this.fireAddDataEvent(lde);
        if (this.selectedIndex < 0 && this.size() > 0) {
            this.setSelectedIndex(0);
        } else if (this.selectedIndex >= this.size()) {
            this.setSelectedIndex(this.size() - 1);
        } else if (current != null) {
            this.setSelectedIndex(this.parameters.indexOf(current));
        }
    }

    public void removeParameterId(String parameterId) {
        if (this.parameters.contains(parameterId)) {
            int index = this.parameters.indexOf(parameterId);
            this.parameters.remove(parameterId);
            ListDataEvent lde = new ListDataEvent(this, 2, index, index);
            this.fireRemoveDataEvent(lde);
            if (this.size() == 0) {
                this.setSelectedIndex(-1);
            } else if (index == this.selectedIndex) {
                if (this.selectedIndex >= this.size()) {
                    this.setSelectedIndex(this.size() - 1);
                }
            } else if (index < this.selectedIndex) {
                this.setSelectedIndex(this.selectedIndex - 1);
            }
        }
    }

    public void removeParameterId(int index) {
        this.parameters.remove(index);
        ListDataEvent lde = new ListDataEvent(this, 2, index, index);
        this.fireRemoveDataEvent(lde);
    }

    public ArrayList<String> getParameters() {
        return this.parameters;
    }

    @Override
    public Iterator<String> iterator() {
        return this.parameters.iterator();
    }

    public int size() {
        return this.parameters.size();
    }

    public Element saveAsXML() {
        Element retVal = new Element("parameterIdList");
        retVal.setAttribute("selectedIndex", Integer.toString(this.selectedIndex));
        for (int i = 0; i < this.size(); ++i) {
            retVal.addElement("parameterId").setText(this.parameters.get(i));
        }
        return retVal;
    }

    public static ParameterIdList loadFromXML(Element data) {
        ParameterIdList retVal = new ParameterIdList();
        String indexStr = data.getAttributeValue("selectedIndex");
        if (indexStr != null && indexStr.length() > 0) {
            retVal.selectedIndex = Integer.parseInt(indexStr);
        }
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            String nodeName = node.getName();
            if (!nodeName.equals("parameterId")) continue;
            retVal.parameters.add(node.getTextString());
        }
        if (retVal.size() > 0 && retVal.getSelectedIndex() < 0) {
            retVal.setSelectedIndex(0);
        }
        return retVal;
    }

    public void addListDataListener(ListDataListener l) {
        if (this.listListeners == null) {
            this.listListeners = new Vector();
        }
        this.listListeners.add(l);
    }

    public void removeListDataListener(ListDataListener l) {
        if (this.listListeners != null) {
            this.listListeners.remove(l);
        }
    }

    private void fireAddDataEvent(ListDataEvent lde) {
        if (this.listListeners == null) {
            return;
        }
        for (ListDataListener listener : new Vector(this.listListeners)) {
            listener.intervalAdded(lde);
        }
    }

    private void fireRemoveDataEvent(ListDataEvent lde) {
        if (this.listListeners == null) {
            return;
        }
        for (ListDataListener listener : new Vector(this.listListeners)) {
            listener.intervalRemoved(lde);
        }
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        if (this.listSelectionListeners == null) {
            this.listSelectionListeners = new Vector();
        }
        if (this.listSelectionListeners.contains(listener)) {
            return;
        }
        this.listSelectionListeners.add(listener);
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        if (this.listSelectionListeners != null) {
            this.listSelectionListeners.remove(l);
        }
    }

    private void fireListSelectionEvent(int index) {
        if (this.listSelectionListeners != null && this.listSelectionListeners.size() > 0) {
            Iterator iter = new Vector(this.listSelectionListeners).iterator();
            ListSelectionEvent lse = new ListSelectionEvent(this, index, index, false);
            while (iter.hasNext()) {
                ListSelectionListener listener = (ListSelectionListener)iter.next();
                listener.valueChanged(lse);
            }
        }
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean contains(String parameterId) {
        return this.parameters.contains(parameterId);
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int selectedIndex) {
        this.selectedIndex = selectedIndex;
        this.fireListSelectionEvent(selectedIndex);
    }

    public void setSelectedParameter(String paramId) {
        if (paramId == null) {
            return;
        }
        int index = this.parameters.indexOf(paramId);
        if (index >= 0) {
            this.setSelectedIndex(index);
        }
    }
}

