/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.blueX7;

import blue.orchestra.blueX7.EnvelopePoint;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.text.StrBuilder;

public class Operator {
    public int mode = 0;
    public int sync = 0;
    public int freqCoarse = 0;
    public int freqFine = 0;
    public int detune = 0;
    public int breakpoint = 0;
    public int curveLeft = 0;
    public int curveRight = 0;
    public int depthLeft = 0;
    public int depthRight = 0;
    public int keyboardRateScaling = 0;
    public int outputLevel = 99;
    public int velocitySensitivity = 0;
    public int modulationAmplitude = 0;
    public int modulationPitch = 0;
    public EnvelopePoint[] envelopePoints = new EnvelopePoint[4];

    public Operator() {
        for (int i = 0; i < this.envelopePoints.length; ++i) {
            this.envelopePoints[i] = new EnvelopePoint();
        }
    }

    public Operator(Operator op) {
        this.mode = op.mode;
        this.sync = op.sync;
        this.freqCoarse = op.freqCoarse;
        this.freqFine = op.freqFine;
        this.detune = op.detune;
        this.breakpoint = op.breakpoint;
        this.curveLeft = op.curveLeft;
        this.curveRight = op.curveRight;
        this.depthLeft = op.depthLeft;
        this.depthRight = op.depthRight;
        this.keyboardRateScaling = op.keyboardRateScaling;
        this.outputLevel = op.outputLevel;
        this.velocitySensitivity = op.velocitySensitivity;
        this.modulationAmplitude = op.modulationAmplitude;
        this.modulationPitch = op.modulationPitch;
        for (int i = 0; i < this.envelopePoints.length; ++i) {
            this.envelopePoints[i] = new EnvelopePoint(op.envelopePoints[i]);
        }
    }

    public String toString() {
        StrBuilder buffer = new StrBuilder();
        buffer.append("[operator]\n");
        buffer.append("mode: " + this.mode + "\n");
        buffer.append("sync: " + this.sync + "\n");
        buffer.append("freqCoarse: " + this.freqCoarse + "\n");
        buffer.append("freqFine: " + this.freqFine + "\n");
        buffer.append("detune: " + this.detune + "\n");
        return buffer.toString();
    }

    public static Operator loadFromXML(Element data) {
        Operator op = new Operator();
        op.mode = XMLUtilities.readInt(data, "mode");
        op.sync = XMLUtilities.readInt(data, "sync");
        op.freqCoarse = XMLUtilities.readInt(data, "freqCoarse");
        op.freqFine = XMLUtilities.readInt(data, "freqFine");
        op.detune = XMLUtilities.readInt(data, "detune");
        op.breakpoint = XMLUtilities.readInt(data, "breakpoint");
        op.curveLeft = XMLUtilities.readInt(data, "curveLeft");
        op.curveRight = XMLUtilities.readInt(data, "curveRight");
        op.depthLeft = XMLUtilities.readInt(data, "depthLeft");
        op.depthRight = XMLUtilities.readInt(data, "depthRight");
        op.keyboardRateScaling = XMLUtilities.readInt(data, "keyboardRateScaling");
        op.outputLevel = XMLUtilities.readInt(data, "outputLevel");
        op.velocitySensitivity = XMLUtilities.readInt(data, "velocitySensitivity");
        op.modulationAmplitude = XMLUtilities.readInt(data, "modulationAmplitude");
        op.modulationPitch = XMLUtilities.readInt(data, "modulationPitch");
        Elements envPoints = data.getElements("envelopePoint");
        int counter = 0;
        while (envPoints.hasMoreElements()) {
            op.envelopePoints[counter] = EnvelopePoint.loadFromXML(envPoints.next());
            ++counter;
        }
        return op;
    }

    public Element saveAsXML() {
        Element retVal = new Element("operator");
        retVal.addElement(XMLUtilities.writeInt("mode", this.mode));
        retVal.addElement(XMLUtilities.writeInt("sync", this.sync));
        retVal.addElement(XMLUtilities.writeInt("freqCoarse", this.freqCoarse));
        retVal.addElement(XMLUtilities.writeInt("freqFine", this.freqFine));
        retVal.addElement(XMLUtilities.writeInt("detune", this.detune));
        retVal.addElement(XMLUtilities.writeInt("breakpoint", this.breakpoint));
        retVal.addElement(XMLUtilities.writeInt("curveLeft", this.curveLeft));
        retVal.addElement(XMLUtilities.writeInt("curveRight", this.curveRight));
        retVal.addElement(XMLUtilities.writeInt("depthLeft", this.depthLeft));
        retVal.addElement(XMLUtilities.writeInt("depthRight", this.depthRight));
        retVal.addElement(XMLUtilities.writeInt("keyboardRateScaling", this.keyboardRateScaling));
        retVal.addElement(XMLUtilities.writeInt("outputLevel", this.outputLevel));
        retVal.addElement(XMLUtilities.writeInt("velocitySensitivity", this.velocitySensitivity));
        retVal.addElement(XMLUtilities.writeInt("modulationAmplitude", this.modulationAmplitude));
        retVal.addElement(XMLUtilities.writeInt("modulationPitch", this.modulationPitch));
        for (int i = 0; i < this.envelopePoints.length; ++i) {
            retVal.addElement(this.envelopePoints[i].saveAsXML());
        }
        return retVal;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }
}

