/*
 * Decompiled with CFR 0.152.
 */
package blue.scripting;

import blue.scripting.Script;
import blue.utility.ListUtil;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.ArrayList;

public class ScriptCategory {
    private String categoryName = "New Script Category";
    private ArrayList subCategories = new ArrayList();
    private ArrayList scripts = new ArrayList();
    private boolean isRoot = false;

    public String toString() {
        return this.getCategoryName();
    }

    public boolean removeScript(Script effect) {
        int index = ListUtil.indexOfByRef(this.scripts, effect);
        if (index >= 0) {
            this.scripts.remove(index);
            return true;
        }
        for (ScriptCategory category : this.subCategories) {
            if (!category.removeScript(effect)) continue;
            return true;
        }
        return false;
    }

    public boolean removeScriptCategory(ScriptCategory category) {
        int index = ListUtil.indexOfByRef(this.subCategories, category);
        if (index >= 0) {
            this.subCategories.remove(index);
            return true;
        }
        for (ScriptCategory tempCategory : this.subCategories) {
            if (!tempCategory.removeScriptCategory(category)) continue;
            return true;
        }
        return false;
    }

    public void addScriptCategory(ScriptCategory category) {
        this.subCategories.add(category);
    }

    public void addScript(int index, Script effect) {
        this.scripts.add(index, effect);
    }

    public void addScript(Script effect) {
        this.scripts.add(effect);
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public ArrayList getScripts() {
        return this.scripts;
    }

    public void setScripts(ArrayList scripts) {
        this.scripts = scripts;
    }

    public ArrayList getSubCategories() {
        return this.subCategories;
    }

    public void setSubCategories(ArrayList subCategories) {
        this.subCategories = subCategories;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setRoot(boolean isRoot) {
        this.isRoot = isRoot;
    }

    public static ScriptCategory loadFromXML(Element data) throws Exception {
        ScriptCategory scriptCat = new ScriptCategory();
        scriptCat.setCategoryName(data.getAttributeValue("categoryName"));
        scriptCat.setRoot(Boolean.valueOf(data.getAttributeValue("isRoot")));
        Elements subCatNodes = data.getElements("scriptCategory");
        while (subCatNodes.hasMoreElements()) {
            scriptCat.addScriptCategory(ScriptCategory.loadFromXML(subCatNodes.next()));
        }
        Elements scripts = data.getElements("script");
        while (scripts.hasMoreElements()) {
            scriptCat.addScript(Script.loadFromXML(scripts.next()));
        }
        return scriptCat;
    }

    public Element saveAsXML() {
        Element retVal = new Element("scriptCategory");
        retVal.setAttribute("categoryName", this.getCategoryName());
        retVal.setAttribute("isRoot", Boolean.toString(this.isRoot()));
        for (ScriptCategory tempCat : this.subCategories) {
            retVal.addElement(tempCat.saveAsXML());
        }
        for (Script effect : this.scripts) {
            retVal.addElement(effect.saveAsXML());
        }
        return retVal;
    }
}

