/*
 * Decompiled with CFR 0.152.
 */
package blue.plaf;

import blue.plaf.BlueLookAndFeel;
import blue.plaf.BlueTabControlButtonFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.netbeans.swing.tabcontrol.plaf.AbstractTabCellRenderer;
import org.netbeans.swing.tabcontrol.plaf.TabPainter;

public class BlueEditorTabCellRenderer
extends AbstractTabCellRenderer {
    private static final TabPainter leftClip = new WinClassicLeftClipPainter();
    private static final TabPainter rightClip = new WinClassicRightClipPainter();
    private static final TabPainter normal = new WinClassicPainter();
    static final Color ATTENTION_COLOR = new Color(255, 238, 120);
    private static final Insets INSETS = new Insets(0, 2, 0, 10);

    public BlueEditorTabCellRenderer() {
        super(leftClip, normal, rightClip, new Dimension(28, 32));
    }

    public Color getSelectedForeground() {
        return Color.WHITE;
    }

    public Color getForeground() {
        return this.getSelectedForeground();
    }

    public int getPixelsToAddToSelection() {
        return 4;
    }

    protected int getCaptionYAdjustment() {
        return 0;
    }

    public Dimension getPadding() {
        Dimension d = super.getPadding();
        d.width = this.isShowCloseButton() && !Boolean.getBoolean("nb.tabs.suppressCloseButton") ? 28 : 14;
        return d;
    }

    private static class WinClassicRightClipPainter
    implements TabPainter {
        private WinClassicRightClipPainter() {
        }

        public Insets getBorderInsets(Component c) {
            return INSETS;
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public Polygon getInteriorPolygon(Component c) {
            BlueEditorTabCellRenderer ren = (BlueEditorTabCellRenderer)((Object)c);
            Insets ins = this.getBorderInsets(c);
            Polygon p = new Polygon();
            int x = 0;
            int y = 1;
            int width = c.getWidth();
            int height = ren.isSelected() ? c.getHeight() + 2 : c.getHeight() - 1;
            p.addPoint(x, y + ins.top + 2);
            p.addPoint(x + 2, y + ins.top);
            p.addPoint(x + width - 1, y + ins.top);
            p.addPoint(x + width - 1, y + height - 1);
            p.addPoint(x, y + height - 1);
            return p;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            BlueEditorTabCellRenderer ren = (BlueEditorTabCellRenderer)((Object)c);
            Polygon p = this.getInteriorPolygon(c);
            g.setColor(ren.isSelected() ? UIManager.getColor("controlLtHighlight") : UIManager.getColor("controlHighlight"));
            int[] xpoints = p.xpoints;
            int[] ypoints = p.ypoints;
            g.drawLine(xpoints[0], ypoints[0], xpoints[p.npoints - 1], ypoints[p.npoints - 1]);
            for (int i = 0; i < p.npoints - 1; ++i) {
                g.drawLine(xpoints[i], ypoints[i], xpoints[i + 1], ypoints[i + 1]);
                if (ren.isSelected() && i == p.npoints - 4) {
                    g.setColor(BlueLookAndFeel.getControl());
                } else if (i == p.npoints - 4) break;
                if (i == p.npoints - 3) break;
            }
        }

        public void paintInterior(Graphics g, Component c) {
            boolean wantGradient;
            BlueEditorTabCellRenderer ren = (BlueEditorTabCellRenderer)((Object)c);
            boolean bl = wantGradient = ren.isSelected() && ren.isActive() || (ren.isClipLeft() || ren.isClipRight()) && ren.isPressed();
            if (!ren.isAttention()) {
                g.setColor(ren.isSelected() ? UIManager.getColor("TabbedPane.background") : UIManager.getColor("tab_unsel_fill"));
            } else {
                g.setColor(ATTENTION_COLOR);
            }
            Polygon p = this.getInteriorPolygon(c);
            g.fillPolygon(p);
        }

        public boolean supportsCloseButton(JComponent renderer) {
            return false;
        }

        public void getCloseButtonRectangle(JComponent jc, Rectangle rect, Rectangle bounds) {
            rect.setBounds(-20, -20, 0, 0);
        }
    }

    private static class WinClassicLeftClipPainter
    implements TabPainter {
        private WinClassicLeftClipPainter() {
        }

        public Insets getBorderInsets(Component c) {
            return INSETS;
        }

        public Polygon getInteriorPolygon(Component c) {
            BlueEditorTabCellRenderer ren = (BlueEditorTabCellRenderer)((Object)c);
            Insets ins = this.getBorderInsets(c);
            Polygon p = new Polygon();
            int x = -3;
            int y = 1;
            int width = c.getWidth() + 3;
            int height = ren.isSelected() ? c.getHeight() + 2 : c.getHeight() - 1;
            p.addPoint(x, y + ins.top + 2);
            p.addPoint(x + 2, y + ins.top);
            p.addPoint(x + width - 3, y + ins.top);
            p.addPoint(x + width - 1, y + ins.top + 2);
            p.addPoint(x + width - 1, y + height - 1);
            p.addPoint(x, y + height - 1);
            return p;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            BlueEditorTabCellRenderer ren = (BlueEditorTabCellRenderer)((Object)c);
            Polygon p = this.getInteriorPolygon(c);
            g.setColor(ren.isSelected() ? UIManager.getColor("controlLtHighlight") : UIManager.getColor("controlHighlight"));
            int[] xpoints = p.xpoints;
            int[] ypoints = p.ypoints;
            g.drawLine(xpoints[0], ypoints[0], xpoints[p.npoints - 1], ypoints[p.npoints - 1]);
            for (int i = 0; i < p.npoints - 1; ++i) {
                g.drawLine(xpoints[i], ypoints[i], xpoints[i + 1], ypoints[i + 1]);
                if (i != p.npoints - 4) continue;
                g.setColor(ren.isSelected() ? UIManager.getColor("controlDkShadow") : UIManager.getColor("controlShadow"));
                g.drawLine(xpoints[i] + 1, ypoints[i] + 1, xpoints[i] + 2, ypoints[i] + 2);
            }
        }

        public void paintInterior(Graphics g, Component c) {
            BlueEditorTabCellRenderer ren = (BlueEditorTabCellRenderer)((Object)c);
            if (!ren.isAttention()) {
                g.setColor(BlueLookAndFeel.getControl());
            } else {
                g.setColor(ATTENTION_COLOR);
            }
            Polygon p = this.getInteriorPolygon(c);
            g.fillPolygon(p);
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void getCloseButtonRectangle(JComponent jc, Rectangle rect, Rectangle bounds) {
            rect.setBounds(-20, -20, 0, 0);
        }

        public boolean supportsCloseButton(JComponent renderer) {
            return false;
        }
    }

    private static class WinClassicPainter
    implements TabPainter {
        private WinClassicPainter() {
        }

        public Insets getBorderInsets(Component c) {
            return INSETS;
        }

        public Polygon getInteriorPolygon(Component c) {
            BlueEditorTabCellRenderer ren = (BlueEditorTabCellRenderer)((Object)c);
            Insets ins = this.getBorderInsets(c);
            Polygon p = new Polygon();
            int x = ren.isLeftmost() ? 1 : 0;
            int y = 1;
            int width = ren.isLeftmost() ? c.getWidth() - 1 : c.getWidth();
            int height = ren.isSelected() ? c.getHeight() + 2 : c.getHeight() - 1;
            p.addPoint(x, y + ins.top + 2);
            p.addPoint(x + 2, y + ins.top);
            p.addPoint(x + width - 3, y + ins.top);
            p.addPoint(x + width - 1, y + ins.top + 2);
            p.addPoint(x + width - 1, y + height - 2);
            p.addPoint(x, y + height - 2);
            return p;
        }

        public boolean isBorderOpaque() {
            return true;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            BlueEditorTabCellRenderer ren = (BlueEditorTabCellRenderer)((Object)c);
            Polygon p = this.getInteriorPolygon(c);
            g.setColor(ren.isSelected() ? UIManager.getColor("controlLtHighlight") : UIManager.getColor("controlHighlight"));
            int[] xpoints = p.xpoints;
            int[] ypoints = p.ypoints;
            g.drawLine(xpoints[0], ypoints[0], xpoints[p.npoints - 1], ypoints[p.npoints - 1]);
            for (int i = 0; i < p.npoints - 1; ++i) {
                g.drawLine(xpoints[i], ypoints[i], xpoints[i + 1], ypoints[i + 1]);
                if (i != p.npoints - 4) continue;
                g.setColor(ren.isSelected() ? UIManager.getColor("controlDkShadow") : UIManager.getColor("controlShadow"));
                g.drawLine(xpoints[i] + 1, ypoints[i] + 1, xpoints[i] + 2, ypoints[i] + 2);
            }
        }

        public void paintInterior(Graphics g, Component c) {
            BlueEditorTabCellRenderer ren = (BlueEditorTabCellRenderer)((Object)c);
            if (!ren.isAttention()) {
                g.setColor(BlueLookAndFeel.getControl());
            } else {
                g.setColor(ATTENTION_COLOR);
            }
            Polygon p = this.getInteriorPolygon(c);
            g.fillPolygon(p);
            if (!this.supportsCloseButton((JComponent)c)) {
                return;
            }
            this.paintCloseButton(g, (JComponent)c);
        }

        public void getCloseButtonRectangle(JComponent jc, Rectangle rect, Rectangle bounds) {
            boolean notSupported;
            boolean rightClip = ((BlueEditorTabCellRenderer)((Object)jc)).isClipRight();
            boolean leftClip = ((BlueEditorTabCellRenderer)((Object)jc)).isClipLeft();
            boolean bl = notSupported = !((BlueEditorTabCellRenderer)((Object)jc)).isShowCloseButton();
            if (leftClip || rightClip || notSupported) {
                rect.x = -100;
                rect.y = -100;
                rect.width = 0;
                rect.height = 0;
            } else {
                String iconPath = this.findIconPath((BlueEditorTabCellRenderer)((Object)jc));
                Icon icon = BlueTabControlButtonFactory.getIcon(iconPath);
                int iconWidth = icon.getIconWidth();
                int iconHeight = icon.getIconHeight();
                rect.x = bounds.x + bounds.width - iconWidth - 2;
                rect.y = bounds.y + Math.max(0, bounds.height / 2 - iconHeight / 2);
                rect.width = iconWidth;
                rect.height = iconHeight;
            }
        }

        private void paintCloseButton(Graphics g, JComponent c) {
            if (((AbstractTabCellRenderer)c).isShowCloseButton()) {
                Rectangle r = new Rectangle(0, 0, c.getWidth(), c.getHeight());
                Rectangle cbRect = new Rectangle();
                this.getCloseButtonRectangle(c, cbRect, r);
                String iconPath = this.findIconPath((BlueEditorTabCellRenderer)((Object)c));
                Icon icon = BlueTabControlButtonFactory.getIcon(iconPath);
                icon.paintIcon(c, g, cbRect.x, cbRect.y);
            }
        }

        private String findIconPath(BlueEditorTabCellRenderer renderer) {
            if (renderer.inCloseButton() && renderer.isPressed()) {
                return "blue/plaf/resources/metal_close_pressed.png";
            }
            if (renderer.inCloseButton()) {
                return "blue/plaf/resources/metal_close_rollover.png";
            }
            return "blue/plaf/resources/metal_close_enabled.png";
        }

        public boolean supportsCloseButton(JComponent renderer) {
            return ((AbstractTabCellRenderer)renderer).isShowCloseButton();
        }
    }
}

