/*
 * Decompiled with CFR 0.152.
 */
package blue.plaf;

import blue.plaf.BlueEditorTabCellRenderer;
import blue.plaf.BlueTabControlButton;
import blue.plaf.BlueTabControlButtonFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.BasicScrollingTabDisplayerUI;
import org.netbeans.swing.tabcontrol.plaf.TabCellRenderer;

public class BlueEditorTabDisplayerUI
extends BasicScrollingTabDisplayerUI {
    private JPanel controlButtons;
    private BlueTabControlButton btnScrollLeft;
    private BlueTabControlButton btnScrollRight;
    private BlueTabControlButton btnDropDown;
    private BlueTabControlButton btnMaximizeRestore;
    private static final Rectangle scratch5 = new Rectangle();
    private static Map<Integer, String[]> buttonIconPaths;
    private static boolean isGenericUI;

    public BlueEditorTabDisplayerUI(TabDisplayer displayer) {
        super(displayer);
    }

    public static ComponentUI createUI(JComponent c) {
        return new BlueEditorTabDisplayerUI((TabDisplayer)c);
    }

    protected TabCellRenderer createDefaultRenderer() {
        return new BlueEditorTabCellRenderer();
    }

    public Rectangle getTabRect(int idx, Rectangle rect) {
        Rectangle r = super.getTabRect(idx, rect);
        r.y = 0;
        r.height = this.displayer.getHeight();
        return r;
    }

    public void install() {
        super.install();
        if (!isGenericUI) {
            this.displayer.setBackground(UIManager.getColor("tab_unsel_fill"));
            this.displayer.setOpaque(true);
        }
    }

    public Dimension getPreferredSize(JComponent c) {
        int prefHeight = 28;
        Graphics2D g = BasicScrollingTabDisplayerUI.getOffscreenGraphics();
        if (g != null) {
            FontMetrics fm = g.getFontMetrics(this.displayer.getFont());
            Insets ins = this.getTabAreaInsets();
            prefHeight = fm.getHeight() + ins.top + ins.bottom + (isGenericUI ? 5 : 6);
        }
        return new Dimension(this.displayer.getWidth(), prefHeight);
    }

    private void genericPaintAfterTabs(Graphics g) {
        g.setColor(UIManager.getColor("controlShadow"));
        Insets ins = this.displayer.getInsets();
        Rectangle r = new Rectangle();
        this.getTabsVisibleArea(r);
        r.width = this.displayer.getWidth();
        boolean selEnd = false;
        int last = this.getLastVisibleTab();
        if (last > -1) {
            this.getTabRect(last, scratch5);
            g.drawLine(BlueEditorTabDisplayerUI.scratch5.x + BlueEditorTabDisplayerUI.scratch5.width, this.displayer.getHeight() - 1, this.displayer.getWidth() - (ins.left + ins.right) - 4, this.displayer.getHeight() - 1);
            g.drawLine(0, this.displayer.getHeight() - 2, 2, this.displayer.getHeight() - 2);
            if ((this.tabState.getState(this.getFirstVisibleTab()) & 2) == 0 || this.getFirstVisibleTab() == this.displayer.getSelectionModel().getSelectedIndex()) {
                g.setColor(UIManager.getColor("controlShadow"));
                g.drawLine(0, this.displayer.getHeight(), 0, this.displayer.getHeight() - 2);
            }
            if ((this.tabState.getState(this.getLastVisibleTab()) & 1) != 0 && this.getLastVisibleTab() != this.displayer.getSelectionModel().getSelectedIndex()) {
                // empty if block
            }
        } else {
            g.drawLine(r.x, this.displayer.getHeight() - ins.bottom, r.x + r.width - 4, this.displayer.getHeight() - ins.bottom);
        }
    }

    protected void paintAfterTabs(Graphics g) {
        if (isGenericUI) {
            this.genericPaintAfterTabs(g);
            return;
        }
        Rectangle r = new Rectangle();
        this.getTabsVisibleArea(r);
        r.width = this.displayer.getWidth();
        g.setColor(this.displayer.isActive() ? this.defaultRenderer.getSelectedActivatedBackground() : this.defaultRenderer.getSelectedBackground());
        Insets ins = this.getTabAreaInsets();
        ++ins.bottom;
        g.fillRect(r.x, r.y + r.height, r.x + r.width, this.displayer.getHeight() - (r.y + r.height));
        g.setColor(UIManager.getColor("controlLtHighlight"));
        int selEnd = 0;
        int i = this.selectionModel.getSelectedIndex();
        if (i != -1) {
            this.getTabRect(i, scratch5);
            if (BlueEditorTabDisplayerUI.scratch5.width != 0) {
                if (r.x < BlueEditorTabDisplayerUI.scratch5.x) {
                    g.drawLine(r.x, this.displayer.getHeight() - ins.bottom, BlueEditorTabDisplayerUI.scratch5.x - 1, this.displayer.getHeight() - ins.bottom);
                }
                if (BlueEditorTabDisplayerUI.scratch5.x + BlueEditorTabDisplayerUI.scratch5.width < r.x + r.width) {
                    selEnd = BlueEditorTabDisplayerUI.scratch5.x + BlueEditorTabDisplayerUI.scratch5.width;
                    if (!this.scroll().isLastTabClipped()) {
                        --selEnd;
                    }
                    g.drawLine(selEnd, this.displayer.getHeight() - ins.bottom, r.x + r.width, this.displayer.getHeight() - ins.bottom);
                }
            }
            return;
        }
        g.drawLine(r.x, this.displayer.getHeight() - ins.bottom, r.x + r.width, this.displayer.getHeight() - ins.bottom);
    }

    private static void initIcons() {
        if (null == buttonIconPaths) {
            buttonIconPaths = new HashMap<Integer, String[]>(7);
            String[] iconPaths = new String[4];
            iconPaths[0] = "blue/plaf/resources/metal_scrollleft_enabled.png";
            iconPaths[2] = "blue/plaf/resources/metal_scrollleft_disabled.png";
            iconPaths[3] = "blue/plaf/resources/metal_scrollleft_rollover.png";
            iconPaths[1] = "blue/plaf/resources/metal_scrollleft_pressed.png";
            buttonIconPaths.put(9, iconPaths);
            iconPaths = new String[4];
            iconPaths[0] = "blue/plaf/resources/metal_scrollright_enabled.png";
            iconPaths[2] = "blue/plaf/resources/metal_scrollright_disabled.png";
            iconPaths[3] = "blue/plaf/resources/metal_scrollright_rollover.png";
            iconPaths[1] = "blue/plaf/resources/metal_scrollright_pressed.png";
            buttonIconPaths.put(10, iconPaths);
            iconPaths = new String[4];
            iconPaths[0] = "blue/plaf/resources/metal_popup_enabled.png";
            iconPaths[2] = "blue/plaf/resources/metal_popup_disabled.png";
            iconPaths[3] = "blue/plaf/resources/metal_popup_rollover.png";
            iconPaths[1] = "blue/plaf/resources/metal_popup_pressed.png";
            buttonIconPaths.put(8, iconPaths);
            iconPaths = new String[4];
            iconPaths[0] = "blue/plaf/resources/metal_maximize_enabled.png";
            iconPaths[2] = "blue/plaf/resources/metal_maximize_disabled.png";
            iconPaths[3] = "blue/plaf/resources/metal_maximize_rollover.png";
            iconPaths[1] = "blue/plaf/resources/metal_maximize_pressed.png";
            buttonIconPaths.put(3, iconPaths);
            iconPaths = new String[4];
            iconPaths[0] = "blue/plaf/resources/metal_restore_enabled.png";
            iconPaths[2] = "blue/plaf/resources/metal_restore_disabled.png";
            iconPaths[3] = "blue/plaf/resources/metal_restore_rollover.png";
            iconPaths[1] = "blue/plaf/resources/metal_restore_pressed.png";
            buttonIconPaths.put(4, iconPaths);
        }
    }

    public Icon getButtonIcon(int buttonId, int buttonState) {
        Icon res = null;
        BlueEditorTabDisplayerUI.initIcons();
        String[] paths = buttonIconPaths.get(buttonId);
        if (null != paths && buttonState >= 0 && buttonState < paths.length) {
            res = BlueTabControlButtonFactory.getIcon(paths[buttonState]);
        }
        return res;
    }

    protected Rectangle getControlButtonsRectangle(Container parent) {
        Component c = this.getControlButtons();
        return new Rectangle(parent.getWidth() - c.getWidth() - 4, 4, c.getWidth(), c.getHeight());
    }

    public Insets getTabAreaInsets() {
        Insets retValue = super.getTabAreaInsets();
        retValue.right += 4;
        return retValue;
    }

    protected Component getControlButtons() {
        if (null == this.controlButtons) {
            JPanel buttonsPanel = new JPanel(null);
            buttonsPanel.setOpaque(false);
            int width = 0;
            int height = 0;
            boolean isGTK = "GTK".equals(UIManager.getLookAndFeel().getID());
            Action a = this.scroll().getBackwardAction();
            a.putValue("control", this.displayer);
            this.btnScrollLeft = BlueTabControlButtonFactory.createScrollLeftButton(this.displayer, a, isGTK);
            buttonsPanel.add(this.btnScrollLeft);
            Dimension prefDim = this.btnScrollLeft.getPreferredSize();
            this.btnScrollLeft.setBounds(width, 0, prefDim.width, prefDim.height);
            width += prefDim.width;
            height = prefDim.height;
            a = this.scroll().getForwardAction();
            a.putValue("control", this.displayer);
            this.btnScrollRight = BlueTabControlButtonFactory.createScrollRightButton(this.displayer, a, isGTK);
            buttonsPanel.add(this.btnScrollRight);
            prefDim = this.btnScrollRight.getPreferredSize();
            this.btnScrollRight.setBounds(width, 0, prefDim.width, prefDim.height);
            width += prefDim.width;
            height = Math.max(height, prefDim.height);
            this.btnDropDown = BlueTabControlButtonFactory.createDropDownButton(this.displayer, isGTK);
            buttonsPanel.add(this.btnDropDown);
            prefDim = this.btnDropDown.getPreferredSize();
            this.btnDropDown.setBounds(width += 3, 0, prefDim.width, prefDim.height);
            width += prefDim.width;
            height = Math.max(height, prefDim.height);
            if (null != this.displayer.getContainerWinsysInfo() && this.displayer.getContainerWinsysInfo().isTopComponentMaximizationEnabled()) {
                this.btnMaximizeRestore = BlueTabControlButtonFactory.createMaximizeRestoreButton(this.displayer, isGTK);
                buttonsPanel.add(this.btnMaximizeRestore);
                prefDim = this.btnMaximizeRestore.getPreferredSize();
                this.btnMaximizeRestore.setBounds(width += 3, 0, prefDim.width, prefDim.height);
                width += prefDim.width;
                height = Math.max(height, prefDim.height);
            }
            Dimension size = new Dimension(width, height);
            buttonsPanel.setMinimumSize(size);
            buttonsPanel.setSize(size);
            buttonsPanel.setPreferredSize(size);
            buttonsPanel.setMaximumSize(size);
            this.controlButtons = buttonsPanel;
        }
        return this.controlButtons;
    }

    static {
        isGenericUI = !"Windows".equals(UIManager.getLookAndFeel().getID());
    }
}

