/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder.jfx;

import blue.jfx.controls.Knob;
import blue.jfx.controls.ValuePanel;
import blue.orchestra.blueSynthBuilder.BSBKnob;
import blue.orchestra.editor.blueSynthBuilder.jfx.ResizeableView;
import blue.utility.NumberUtilities;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.util.StringConverter;
import org.openide.util.Exceptions;

public class BSBKnobView
extends BorderPane
implements ResizeableView {
    private static final int VALUE_HEIGHT = 14;
    BSBKnob knob;
    Knob knobView;
    ValuePanel valuePanel;
    Label label;

    public BSBKnobView(BSBKnob knob) {
        this.setUserData(knob);
        this.knob = knob;
        this.label = new Label();
        this.label.setStyle("-fx-fill: white; -fx-font-smooth-type: lcd");
        this.label.setAlignment(Pos.CENTER);
        this.label.setMaxWidth(Double.POSITIVE_INFINITY);
        this.knobView = new Knob();
        this.valuePanel = new ValuePanel();
        this.valuePanel.setValidator(v -> {
            try {
                double f = Double.parseDouble(v);
                return f >= knob.getMinimum() && f <= knob.getMaximum();
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        });
        this.setCenter((Node)this.knobView);
        this.valuePanel.setPrefHeight(14.0);
        BorderPane.setAlignment((Node)this.valuePanel, (Pos)Pos.CENTER);
        StringConverter<Number> converter = new StringConverter<Number>(){

            public String toString(Number object) {
                return object == null ? "" : NumberUtilities.formatDouble((double)object.doubleValue());
            }

            public Number fromString(String string) {
                try {
                    return Double.parseDouble(string);
                }
                catch (NumberFormatException nfe) {
                    return 0.0;
                }
            }
        };
        ChangeListener vdeListener = (obs, old, newVal) -> {
            if (newVal.booleanValue()) {
                this.setBottom((Node)this.valuePanel);
            } else {
                this.setBottom(null);
            }
        };
        ChangeListener labelEnabledListener = (obs, old, newVal) -> {
            if (newVal.booleanValue()) {
                this.setTop((Node)this.label);
            } else {
                this.setTop(null);
            }
        };
        boolean[] val = new boolean[]{false};
        ChangeListener knobToViewListener = (obs, old, newVal) -> {
            if (!val[0]) {
                val[0] = true;
                if (!Platform.isFxApplicationThread()) {
                    CountDownLatch latch = new CountDownLatch(1);
                    Platform.runLater(() -> {
                        try {
                            this.knobView.setValue(knob.getValue());
                        }
                        finally {
                            latch.countDown();
                        }
                    });
                    try {
                        latch.await();
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else {
                    this.knobView.setValue(knob.getValue());
                }
                val[0] = false;
            }
        };
        ChangeListener viewToKnobListener = (obs, old, newVal) -> {
            if (!val[0]) {
                val[0] = true;
                knob.setValue(this.knobView.getValue());
                val[0] = false;
            }
        };
        IntegerBinding knobViewHeight = knob.knobWidthProperty().subtract(4);
        this.sceneProperty().addListener((arg_0, arg_1, arg_2) -> this.lambda$new$6(knob, knobToViewListener, viewToKnobListener, vdeListener, labelEnabledListener, knobViewHeight, (StringConverter)converter, arg_0, arg_1, arg_2));
    }

    @Override
    public boolean canResizeWidgetWidth() {
        return true;
    }

    @Override
    public boolean canResizeWidgetHeight() {
        return true;
    }

    @Override
    public int getWidgetMinimumWidth() {
        return 20;
    }

    @Override
    public int getWidgetMinimumHeight() {
        int h = 20;
        if (this.knob.isValueDisplayEnabled()) {
            h += (int)this.valuePanel.getHeight();
        }
        if (this.knob.isLabelEnabled()) {
            h += (int)this.label.getHeight();
        }
        return h;
    }

    @Override
    public int getWidgetWidth() {
        return this.knob.getKnobWidth();
    }

    @Override
    public void setWidgetWidth(int width) {
        this.knob.setKnobWidth(Math.max(20, width));
    }

    @Override
    public int getWidgetHeight() {
        return (int)this.getHeight();
    }

    @Override
    public void setWidgetHeight(int height) {
        int h = height;
        if (this.knob.isValueDisplayEnabled()) {
            h -= (int)this.valuePanel.getHeight();
        }
        if (this.knob.isLabelEnabled()) {
            h -= (int)this.label.getHeight();
        }
        this.knob.setKnobWidth(Math.max(20, h));
    }

    @Override
    public void setWidgetX(int x) {
        this.knob.setX(x);
    }

    @Override
    public int getWidgetX() {
        return this.knob.getX();
    }

    @Override
    public void setWidgetY(int y) {
        this.knob.setY(y);
    }

    @Override
    public int getWidgetY() {
        return this.knob.getY();
    }

    private /* synthetic */ void lambda$new$6(BSBKnob knob, ChangeListener knobToViewListener, ChangeListener viewToKnobListener, ChangeListener vdeListener, ChangeListener labelEnabledListener, IntegerBinding knobViewHeight, StringConverter converter, ObservableValue obs, Scene old, Scene newVal) {
        if (newVal == null) {
            this.knobView.minProperty().unbind();
            this.knobView.maxProperty().unbind();
            knob.knobValueProperty().valueProperty().removeListener(knobToViewListener);
            this.knobView.valueProperty().removeListener(viewToKnobListener);
            this.knobView.prefWidthProperty().unbind();
            this.knobView.prefHeightProperty().unbind();
            this.valuePanel.prefWidthProperty().unbind();
            this.valuePanel.maxWidthProperty().unbind();
            knob.valueDisplayEnabledProperty().removeListener(vdeListener);
            knob.labelEnabledProperty().removeListener(labelEnabledListener);
            Bindings.unbindBidirectional((Object)this.valuePanel.valueProperty(), (Object)knob.knobValueProperty().valueProperty());
            this.label.textProperty().unbind();
            this.label.fontProperty().unbind();
        } else {
            this.knobView.minProperty().bind((ObservableValue)knob.knobValueProperty().minProperty());
            this.knobView.maxProperty().bind((ObservableValue)knob.knobValueProperty().maxProperty());
            this.knobView.prefWidthProperty().bind((ObservableValue)knob.knobWidthProperty());
            this.knobView.prefHeightProperty().bind((ObservableValue)knobViewHeight);
            this.knobView.setValue(knob.getValue());
            this.knobView.minWidthProperty().bind((ObservableValue)this.knobView.prefWidthProperty());
            this.knobView.minHeightProperty().bind((ObservableValue)this.knobView.prefHeightProperty());
            this.knobView.maxWidthProperty().bind((ObservableValue)knob.knobWidthProperty());
            this.knobView.maxHeightProperty().bind((ObservableValue)knobViewHeight);
            this.valuePanel.prefWidthProperty().bind((ObservableValue)this.knobView.prefWidthProperty());
            this.valuePanel.maxWidthProperty().bind((ObservableValue)knob.knobWidthProperty());
            knob.valueDisplayEnabledProperty().addListener(vdeListener);
            knob.labelEnabledProperty().addListener(labelEnabledListener);
            knob.knobValueProperty().valueProperty().addListener(knobToViewListener);
            this.knobView.valueProperty().addListener(viewToKnobListener);
            Bindings.bindBidirectional((Property)this.valuePanel.valueProperty(), (Property)knob.knobValueProperty().valueProperty(), (StringConverter)converter);
            this.label.textProperty().bind((ObservableValue)knob.labelProperty());
            this.label.fontProperty().bind((ObservableValue)knob.labelFontProperty());
            if (knob.isValueDisplayEnabled()) {
                this.setBottom((Node)this.valuePanel);
            } else {
                this.setBottom(null);
            }
            if (knob.isLabelEnabled()) {
                this.setTop((Node)this.label);
            } else {
                this.setTop(null);
            }
        }
    }
}

