/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder.jfx;

import blue.orchestra.blueSynthBuilder.BSBGroup;
import blue.orchestra.blueSynthBuilder.BSBObject;
import blue.orchestra.blueSynthBuilder.GridSettings;
import blue.orchestra.editor.blueSynthBuilder.jfx.Alignment;
import blue.orchestra.editor.blueSynthBuilder.jfx.AlignmentUtils;
import blue.orchestra.editor.blueSynthBuilder.jfx.BSBEditSelection;
import blue.orchestra.editor.blueSynthBuilder.jfx.ResizeableView;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.BoundingBox;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;

public class BSBObjectViewHolder
extends Pane {
    double startX = 0.0;
    double startY = 0.0;
    Point2D mouseOrigin;
    BoundingBox originBounds;
    ResizeableView rView = null;
    private static ContextMenu MENU = null;
    Region bsbObjectView;
    BSBEditSelection selection;

    public BSBObjectViewHolder(final BooleanProperty editEnabledProperty, BSBEditSelection selection, ObservableList<BSBGroup> groupsList, final Region bsbObjView) {
        final BSBObject bsbObj = (BSBObject)bsbObjView.getUserData();
        this.bsbObjectView = bsbObjView;
        this.setUserData(bsbObj);
        final Pane mousePane = new Pane();
        this.setFocusTraversable(true);
        this.selection = selection;
        mousePane.setOnMousePressed(me -> {
            if (!((BSBGroup)groupsList.get(groupsList.size() - 1)).contains(bsbObj)) {
                return;
            }
            me.consume();
            this.getParent().requestFocus();
            if (me.isSecondaryButtonDown()) {
                ContextMenu menu = BSBObjectViewHolder.getContextMenu();
                menu.setUserData((Object)new MenuData(selection, (List<BSBGroup>)groupsList));
                menu.show((Node)this, me.getScreenX(), me.getScreenY());
                return;
            }
            if (me.getClickCount() >= 2 && bsbObj instanceof BSBGroup) {
                groupsList.add((Object)((BSBGroup)bsbObj));
                return;
            }
            if (selection.selection.contains((Object)bsbObj)) {
                if (me.isShiftDown()) {
                    selection.selection.remove((Object)bsbObj);
                    return;
                }
            } else {
                if (me.isShiftDown()) {
                    selection.selection.add((Object)bsbObj);
                    return;
                }
                selection.selection.clear();
                selection.selection.add((Object)bsbObj);
            }
            selection.initiateMove(bsbObj);
            this.startX = me.getSceneX();
            this.startY = me.getSceneY();
        });
        mousePane.setOnMouseDragged(me -> {
            if (!((BSBGroup)groupsList.get(groupsList.size() - 1)).contains(bsbObj)) {
                return;
            }
            selection.move(me.getSceneX() - this.startX, me.getSceneY() - this.startY);
        });
        mousePane.setOnMouseReleased(me -> {
            if (!((BSBGroup)groupsList.get(groupsList.size() - 1)).contains(bsbObj)) {
                return;
            }
            selection.endMove();
        });
        Rectangle rect = new Rectangle();
        rect.setStroke((Paint)Color.rgb((int)0, (int)255, (int)0));
        rect.widthProperty().bind((ObservableValue)mousePane.widthProperty().subtract(1));
        rect.heightProperty().bind((ObservableValue)mousePane.heightProperty().subtract(1));
        rect.setMouseTransparent(true);
        rect.setFill(null);
        rect.setVisible(false);
        rect.setLayoutX(0.5);
        rect.setLayoutY(0.5);
        this.getChildren().addAll((Object[])new Node[]{bsbObjView, mousePane, rect});
        if (editEnabledProperty != null) {
            this.setupResizeHandles(rect, selection);
            rect.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> editEnabledProperty.get() && selection.selection.contains((Object)bsbObj), (Observable[])new Observable[]{editEnabledProperty, selection.selection}));
        }
        this.sceneProperty().addListener((ChangeListener)new ChangeListener<Scene>(){

            public void changed(ObservableValue<? extends Scene> obs, Scene old, Scene newVal) {
                if (newVal == null) {
                    mousePane.prefWidthProperty().unbind();
                    mousePane.prefHeightProperty().unbind();
                    mousePane.mouseTransparentProperty().unbind();
                    BSBObjectViewHolder.this.layoutXProperty().unbind();
                    BSBObjectViewHolder.this.layoutYProperty().unbind();
                } else {
                    mousePane.prefWidthProperty().bind((ObservableValue)bsbObjView.widthProperty());
                    mousePane.prefHeightProperty().bind((ObservableValue)bsbObjView.heightProperty());
                    if (editEnabledProperty != null) {
                        mousePane.mouseTransparentProperty().bind((ObservableValue)editEnabledProperty.not());
                    } else {
                        mousePane.setMouseTransparent(true);
                    }
                    BSBObjectViewHolder.this.layoutXProperty().bind((ObservableValue)bsbObj.xProperty());
                    BSBObjectViewHolder.this.layoutYProperty().bind((ObservableValue)bsbObj.yProperty());
                }
            }
        });
    }

    private void setupResizeHandles(Rectangle rect, BSBEditSelection selection) {
        if (!(this.bsbObjectView instanceof ResizeableView)) {
            return;
        }
        BooleanBinding visibleBinding = Bindings.createBooleanBinding(() -> rect.isVisible() && selection.selection.size() == 1, (Observable[])new Observable[]{rect.visibleProperty(), selection.selection});
        this.rView = (ResizeableView)this.bsbObjectView;
        if (this.rView.canResizeWidgetWidth()) {
            Rectangle resizeLeftHandle = new Rectangle(5.0, 5.0);
            resizeLeftHandle.setManaged(false);
            resizeLeftHandle.setFill((Paint)Color.rgb((int)0, (int)255, (int)0));
            resizeLeftHandle.setLayoutX(-2.0);
            resizeLeftHandle.yProperty().bind((ObservableValue)rect.heightProperty().divide(2).subtract(2));
            resizeLeftHandle.visibleProperty().bind((ObservableValue)visibleBinding);
            resizeLeftHandle.setCursor(Cursor.W_RESIZE);
            resizeLeftHandle.setOnMousePressed(evt -> this.recordMouseOrigin((MouseEvent)evt));
            resizeLeftHandle.setOnMouseDragged(evt -> this.resizeLeft((MouseEvent)evt));
            Rectangle resizeRightHandle = new Rectangle(5.0, 5.0);
            resizeRightHandle.setManaged(false);
            resizeRightHandle.setFill((Paint)Color.rgb((int)0, (int)255, (int)0));
            resizeRightHandle.xProperty().bind((ObservableValue)rect.widthProperty().subtract(2));
            resizeRightHandle.yProperty().bind((ObservableValue)rect.heightProperty().divide(2).subtract(2));
            resizeRightHandle.visibleProperty().bind((ObservableValue)visibleBinding);
            resizeRightHandle.setCursor(Cursor.E_RESIZE);
            resizeRightHandle.setOnMousePressed(evt -> this.recordMouseOrigin((MouseEvent)evt));
            resizeRightHandle.setOnMouseDragged(evt -> this.resizeRight((MouseEvent)evt));
            this.getChildren().addAll((Object[])new Node[]{resizeLeftHandle, resizeRightHandle});
        }
        if (this.rView.canResizeWidgetHeight()) {
            Rectangle resizeTopHandle = new Rectangle(5.0, 5.0);
            resizeTopHandle.setManaged(false);
            resizeTopHandle.setFill((Paint)Color.rgb((int)0, (int)255, (int)0));
            resizeTopHandle.setLayoutY(-2.0);
            resizeTopHandle.xProperty().bind((ObservableValue)rect.widthProperty().divide(2).subtract(2));
            resizeTopHandle.visibleProperty().bind((ObservableValue)visibleBinding);
            resizeTopHandle.setCursor(Cursor.N_RESIZE);
            resizeTopHandle.setOnMousePressed(evt -> this.recordMouseOrigin((MouseEvent)evt));
            resizeTopHandle.setOnMouseDragged(evt -> this.resizeUp((MouseEvent)evt));
            Rectangle resizeBottomHandle = new Rectangle(5.0, 5.0);
            resizeBottomHandle.setManaged(false);
            resizeBottomHandle.setFill((Paint)Color.rgb((int)0, (int)255, (int)0));
            resizeBottomHandle.yProperty().bind((ObservableValue)rect.heightProperty().subtract(2));
            resizeBottomHandle.xProperty().bind((ObservableValue)rect.widthProperty().divide(2).subtract(2));
            resizeBottomHandle.visibleProperty().bind((ObservableValue)visibleBinding);
            resizeBottomHandle.setCursor(Cursor.S_RESIZE);
            resizeBottomHandle.setOnMousePressed(evt -> this.recordMouseOrigin((MouseEvent)evt));
            resizeBottomHandle.setOnMouseDragged(evt -> this.resizeDown((MouseEvent)evt));
            this.getChildren().addAll((Object[])new Node[]{resizeTopHandle, resizeBottomHandle});
        }
    }

    protected void recordMouseOrigin(MouseEvent evt) {
        BSBObject bsbObj = (BSBObject)this.getUserData();
        Rectangle r = (Rectangle)evt.getSource();
        this.mouseOrigin = r.localToParent(evt.getX(), evt.getY());
        this.mouseOrigin = this.localToParent(this.mouseOrigin);
        this.originBounds = new BoundingBox((double)bsbObj.getX(), (double)bsbObj.getY(), (double)this.rView.getWidgetWidth(), (double)this.rView.getWidgetHeight());
        evt.consume();
    }

    protected void resizeRight(MouseEvent evt) {
        Rectangle r = (Rectangle)evt.getSource();
        Point2D curPoint = r.localToParent(evt.getX(), evt.getY());
        curPoint = this.localToParent(curPoint);
        GridSettings grid = this.selection.getGridSettings();
        int diff = (int)(curPoint.getX() - this.mouseOrigin.getX());
        int newWidth = (int)this.originBounds.getWidth() + diff;
        if (grid.isSnapEnabled()) {
            double left = this.getLayoutX();
            double right = left + (double)newWidth;
            int w = grid.getWidth();
            newWidth = (int)((double)(Math.round(right / (double)w) * (long)w) - left);
        }
        if ((newWidth = Math.max(newWidth, this.rView.getWidgetMinimumWidth())) != this.rView.getWidgetWidth()) {
            this.rView.setWidgetWidth(newWidth);
        }
        evt.consume();
    }

    protected void resizeLeft(MouseEvent evt) {
        Rectangle r = (Rectangle)evt.getSource();
        Point2D curPoint = r.localToParent(evt.getX(), evt.getY());
        curPoint = this.localToParent(curPoint);
        GridSettings grid = this.selection.getGridSettings();
        int diff = (int)(curPoint.getX() - this.mouseOrigin.getX());
        diff = Math.max((int)(-this.originBounds.getMinX()), diff);
        int newWidth = (int)this.originBounds.getWidth() - diff;
        int newX = (int)this.originBounds.getMinX() + diff;
        if (grid.isSnapEnabled()) {
            double right = this.originBounds.getMaxX();
            double left = right - (double)newWidth;
            int w = grid.getWidth();
            left = Math.round(left / (double)w) * (long)w;
            newWidth = (int)(right - left);
            newX = (int)left;
        }
        newWidth = Math.max(newWidth, this.rView.getWidgetMinimumWidth());
        newX = Math.min(newX, (int)(this.originBounds.getMaxX() - (double)this.rView.getWidgetMinimumWidth()));
        if (newWidth != this.rView.getWidgetWidth()) {
            this.rView.setWidgetWidth(newWidth);
            this.rView.setWidgetX(newX);
        }
        evt.consume();
    }

    protected void resizeUp(MouseEvent evt) {
        Rectangle r = (Rectangle)evt.getSource();
        Point2D curPoint = r.localToParent(evt.getX(), evt.getY());
        curPoint = this.localToParent(curPoint);
        GridSettings grid = this.selection.getGridSettings();
        int diff = (int)(curPoint.getY() - this.mouseOrigin.getY());
        diff = Math.max((int)(-this.originBounds.getMinY()), diff);
        int newHeight = (int)this.originBounds.getHeight() - diff;
        int newY = (int)this.originBounds.getMinY() + diff;
        if (grid.isSnapEnabled()) {
            double bottom = this.originBounds.getMaxY();
            double top = bottom - (double)newHeight;
            int h = grid.getHeight();
            top = Math.round(top / (double)h) * (long)h;
            newHeight = (int)(bottom - top);
            newY = (int)top;
        }
        newHeight = Math.max(newHeight, this.rView.getWidgetMinimumHeight());
        newY = Math.min(newY, (int)(this.originBounds.getMaxY() - (double)this.rView.getWidgetMinimumHeight()));
        if (newHeight != this.rView.getWidgetHeight()) {
            this.rView.setWidgetY(newY);
            this.rView.setWidgetHeight(newHeight);
        }
        evt.consume();
    }

    protected void resizeDown(MouseEvent evt) {
        Rectangle r = (Rectangle)evt.getSource();
        Point2D curPoint = r.localToParent(evt.getX(), evt.getY());
        curPoint = this.localToParent(curPoint);
        GridSettings grid = this.selection.getGridSettings();
        int diff = (int)(curPoint.getY() - this.mouseOrigin.getY());
        int newHeight = (int)this.originBounds.getHeight() + diff;
        if (grid.isSnapEnabled()) {
            double top = this.getLayoutY();
            double bottom = top + (double)newHeight;
            int h = grid.getHeight();
            newHeight = (int)((double)(Math.round(bottom / (double)h) * (long)h) - top);
        }
        if ((newHeight = Math.max(newHeight, this.rView.getWidgetMinimumHeight())) != this.rView.getWidgetHeight()) {
            this.rView.setWidgetHeight(newHeight);
        }
        evt.consume();
    }

    private static ContextMenu getContextMenu() {
        if (MENU == null) {
            MENU = new ContextMenu();
            MenuItem cut = new MenuItem("Cut");
            cut.setOnAction(e -> {
                MenuData data = (MenuData)MENU.getUserData();
                BSBEditSelection selection = data.selection;
                selection.cut();
            });
            MenuItem copy = new MenuItem("Copy");
            copy.setOnAction(e -> {
                MenuData data = (MenuData)MENU.getUserData();
                BSBEditSelection selection = data.selection;
                selection.copy();
            });
            MenuItem remove = new MenuItem("Remove");
            remove.setOnAction(e -> {
                MenuData data = (MenuData)MENU.getUserData();
                BSBEditSelection selection = data.selection;
                selection.remove();
            });
            MenuItem makeGroup = new MenuItem("Make Group");
            makeGroup.setOnAction(e -> {
                MenuData data = (MenuData)MENU.getUserData();
                BSBEditSelection selection = data.selection;
                List<BSBGroup> groupsList = data.groupsList;
                List bsbObjs = selection.selection.stream().map(b -> (BSBObject)b.deepCopy()).collect(Collectors.toList());
                int x = Integer.MAX_VALUE;
                int y = Integer.MAX_VALUE;
                for (BSBObject bsbObj : bsbObjs) {
                    x = Math.min(x, bsbObj.getX());
                    y = Math.min(y, bsbObj.getY());
                }
                for (BSBObject bsbObj : bsbObjs) {
                    bsbObj.setX(bsbObj.getX() - x + 10);
                    bsbObj.setY(bsbObj.getY() - y + 10);
                }
                selection.remove();
                BSBGroup group = new BSBGroup();
                group.interfaceItemsProperty().addAll(bsbObjs);
                group.setX(x);
                group.setY(y);
                groupsList.get(groupsList.size() - 1).addBSBObject((BSBObject)group);
            });
            MenuItem breakGroup = new MenuItem("Break Group");
            breakGroup.setOnAction(e -> {
                MenuData data = (MenuData)MENU.getUserData();
                BSBEditSelection selection = data.selection;
                List<BSBGroup> groupsList = data.groupsList;
                BSBGroup group = (BSBGroup)selection.selection.toArray()[0];
                int x = group.getX();
                int y = group.getY();
                selection.remove();
                BSBGroup rootGroup = groupsList.get(groupsList.size() - 1);
                for (BSBObject bsbObj : group) {
                    BSBObject temp = (BSBObject)bsbObj.deepCopy();
                    temp.setX(temp.getX() + x);
                    temp.setY(temp.getY() + y);
                    rootGroup.addBSBObject(temp);
                }
            });
            Menu align = new Menu("Align");
            Menu distribute = new Menu("Distribute");
            EventHandler alignListener = ae -> {
                MenuItem source = (MenuItem)ae.getSource();
                Alignment alignment = (Alignment)((Object)((Object)source.getUserData()));
                MenuData data = (MenuData)MENU.getUserData();
                BSBEditSelection selection = data.selection;
                AlignmentUtils.align(selection.getSelectedNodes(), alignment);
            };
            EventHandler distributeListener = ae -> {
                MenuItem source = (MenuItem)ae.getSource();
                Alignment alignment = (Alignment)((Object)((Object)source.getUserData()));
                MenuData data = (MenuData)MENU.getUserData();
                BSBEditSelection selection = data.selection;
                AlignmentUtils.distribute(selection.getSelectedNodes(), alignment);
            };
            for (Alignment alignment : Alignment.values()) {
                MenuItem a = new MenuItem(alignment.toString());
                a.setUserData((Object)alignment);
                a.setOnAction(alignListener);
                MenuItem d = new MenuItem(alignment.toString());
                d.setUserData((Object)alignment);
                d.setOnAction(distributeListener);
                align.getItems().add((Object)a);
                distribute.getItems().add((Object)d);
            }
            MENU.getItems().addAll((Object[])new MenuItem[]{cut, copy, remove});
            MENU.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), makeGroup, breakGroup});
            MENU.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem(), align, distribute});
            MENU.setOnHidden(e -> MENU.setUserData(null));
            MENU.setOnShowing(e -> {
                MenuData data = (MenuData)MENU.getUserData();
                BSBEditSelection selection = data.selection;
                align.setDisable(selection.selection.size() < 2);
                distribute.setDisable(selection.selection.size() < 2);
                breakGroup.setDisable(selection.selection.size() != 1 || selection.selection.stream().noneMatch(x -> x instanceof BSBGroup));
            });
        }
        return MENU;
    }

    public Region getBSBObjectView() {
        return this.bsbObjectView;
    }

    class MenuData {
        public final BSBEditSelection selection;
        public final List<BSBGroup> groupsList;

        public MenuData(BSBEditSelection selection, List<BSBGroup> groupsList) {
            this.selection = selection;
            this.groupsList = groupsList;
        }
    }
}

