/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor;

import blue.Arrangement;
import blue.BlueSystem;
import blue.CompileData;
import blue.Tables;
import blue.automation.LineColors;
import blue.automation.Parameter;
import blue.components.lines.Line;
import blue.components.lines.LineList;
import blue.components.lines.LinePoint;
import blue.gui.ExceptionDialog;
import blue.gui.InfoDialog;
import blue.jfx.BlueFX;
import blue.orchestra.Instrument;
import blue.orchestra.editor.blueSynthBuilder.jfx.LineSelector;
import blue.score.ScoreObject;
import blue.score.ScoreObjectListener;
import blue.soundObject.NoteList;
import blue.soundObject.Sound;
import blue.soundObject.editor.ScoreObjectEditor;
import blue.soundObject.editor.sound.ParameterLineView;
import blue.soundObject.editor.sound.TimeBar;
import blue.ui.core.orchestra.editor.BlueSynthBuilderEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.concurrent.CountDownLatch;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextArea;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;

public class SoundEditor
extends ScoreObjectEditor {
    Sound sObj;
    JLabel editorLabel = new JLabel();
    JPanel topPanel = new JPanel();
    JButton testButton = new JButton();
    LineList lineList = new LineList();
    BlueSynthBuilderEditor editor = new BlueSynthBuilderEditor();
    ParameterLineView lineView;
    LineSelector lineSelector;
    private TextArea commentTextArea;
    ScoreObjectListener sObjListener = evt -> {
        if (evt.getPropertyChanged() == 1) {
            this.lineView.setStartTime(evt.getScoreObject().getStartTime());
        } else if (evt.getPropertyChanged() == 2) {
            this.lineView.setDuration(evt.getScoreObject().getSubjectiveDuration());
        }
    };

    public SoundEditor() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.add((Component)((Object)this.editor));
        this.editor.setLabelText("[ Sound ]");
        JFXPanel jfxPanel = new JFXPanel();
        CountDownLatch latch = new CountDownLatch(1);
        JFXPanel jfxCommentPanel = new JFXPanel();
        BlueFX.runOnFXThread(() -> {
            try {
                MenuButton btn = new MenuButton("Automations");
                BorderPane mainPane = new BorderPane();
                this.lineView = new ParameterLineView(this.lineList);
                this.lineSelector = new LineSelector(this.lineList);
                this.lineView.widthProperty().bind((ObservableValue)mainPane.widthProperty());
                this.lineView.heightProperty().bind((ObservableValue)mainPane.heightProperty().subtract((ObservableNumberValue)this.lineSelector.heightProperty()));
                this.lineSelector.getChildren().add(0, (Object)btn);
                this.lineSelector.setSpacing(5.0);
                this.lineView.selectedLineProperty().bind(this.lineSelector.selectedLineProperty());
                TimeBar tb = new TimeBar();
                tb.startTimeProperty().bind((ObservableValue)this.lineView.startTimeProperty());
                tb.durationProperty().bind((ObservableValue)this.lineView.durationProperty());
                Pane p = new Pane(new Node[]{this.lineView, tb});
                p.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.BLACK, CornerRadii.EMPTY, Insets.EMPTY)}));
                this.lineView.widthProperty().bind((ObservableValue)p.widthProperty().subtract(20));
                this.lineView.heightProperty().bind((ObservableValue)p.heightProperty().subtract(40));
                this.lineView.setLayoutX(10.0);
                this.lineView.setLayoutY(30.0);
                tb.widthProperty().bind((ObservableValue)this.lineView.widthProperty());
                tb.setHeight(20.0);
                tb.setLayoutX(10.0);
                tb.setLayoutY(10.0);
                mainPane.setCenter((Node)p);
                mainPane.setTop((Node)this.lineSelector);
                btn.showingProperty().addListener((obs, old, newVal) -> {
                    if (newVal.booleanValue()) {
                        if (this.sObj != null) {
                            this.sObj.getBlueSynthBuilder().getParameterList().sorted().forEach(param -> {
                                MenuItem m = new MenuItem(param.getName());
                                m.setOnAction(e -> {
                                    param.setAutomationEnabled(!param.isAutomationEnabled());
                                    if (param.isAutomationEnabled()) {
                                        Line line = param.getLine();
                                        line.setVarName(param.getName());
                                        ObservableList points = line.getObservableList();
                                        if (points.size() < 2) {
                                            LinePoint lp = new LinePoint();
                                            lp.setLocation(1.0, ((LinePoint)points.get(0)).getY());
                                            points.add(lp);
                                        }
                                        this.lineList.add((Object)line);
                                    } else {
                                        this.lineList.remove((Object)param.getLine());
                                    }
                                    int colorCount = 0;
                                    for (Line line : this.lineList) {
                                        line.setColor(LineColors.getColor((int)colorCount++));
                                    }
                                });
                                if (param.isAutomationEnabled()) {
                                    m.setStyle("-fx-text-fill: green;");
                                }
                                btn.getItems().add((Object)m);
                            });
                        }
                    } else {
                        btn.getItems().clear();
                    }
                });
                Scene scene = new Scene((Parent)mainPane);
                BlueFX.style((Scene)scene);
                jfxPanel.setScene(scene);
                this.commentTextArea = new TextArea();
                this.commentTextArea.setWrapText(true);
                Scene scene2 = new Scene((Parent)this.commentTextArea);
                BlueFX.style((Scene)scene2);
                jfxCommentPanel.setScene(scene2);
            }
            finally {
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.editor.getTabs().insertTab("Automation", null, (Component)jfxPanel, "", 1);
        this.editor.getTabs().addTab("Comments", (Component)jfxCommentPanel);
    }

    @Override
    public final void editScoreObject(ScoreObject sObj) {
        if (sObj == null) {
            this.sObj = null;
            this.editorLabel.setText("no editor available");
            this.editor.editInstrument(null);
            return;
        }
        if (!(sObj instanceof Sound)) {
            this.sObj = null;
            this.editorLabel.setText("no editor available");
            this.editor.editInstrument(null);
            return;
        }
        if (this.sObj != null) {
            Sound temp = this.sObj;
            BlueFX.runOnFXThread(() -> {
                temp.commentProperty().unbind();
                temp.removeScoreObjectListener(this.sObjListener);
            });
        }
        this.sObj = (Sound)sObj;
        this.editor.editInstrument((Instrument)this.sObj.getBlueSynthBuilder());
        BlueFX.runOnFXThread(() -> {
            this.lineList.clear();
            int colorCount = 0;
            for (Parameter p : this.sObj.getBlueSynthBuilder().getParameterList().sorted()) {
                if (!p.isAutomationEnabled()) continue;
                p.getLine().setVarName(p.getName());
                p.getLine().setColor(LineColors.getColor((int)colorCount++));
                ObservableList points = p.getLine().getObservableList();
                if (points.size() < 2) {
                    LinePoint lp = new LinePoint();
                    lp.setLocation(1.0, ((LinePoint)points.get(0)).getY());
                    points.add(lp);
                }
                this.lineList.add((Object)p.getLine());
            }
            this.lineView.setStartTime(this.sObj.getStartTime());
            this.lineView.setDuration(this.sObj.getSubjectiveDuration());
            this.commentTextArea.setText(this.sObj.getComment());
            this.sObj.commentProperty().bind((ObservableValue)this.commentTextArea.textProperty());
            this.sObj.addScoreObjectListener(this.sObjListener);
        });
    }

    public final void testSoundObject() {
        if (this.sObj == null) {
            return;
        }
        NoteList notes = null;
        try {
            notes = this.sObj.generateForCSD(new CompileData(new Arrangement(), new Tables()), 0.0, -1.0);
        }
        catch (Exception e) {
            ExceptionDialog.showExceptionDialog(SwingUtilities.getRoot(this), e);
        }
        if (notes != null) {
            InfoDialog.showInformationDialog(SwingUtilities.getRoot(this), notes.toString(), BlueSystem.getString((String)"soundObject.generatedScore"));
        }
    }
}

