/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.editor.actions;

import blue.tools.codeRepository.AddToCodeRepositoryDialog;
import blue.tools.codeRepository.CodeRepositoryManager;
import electric.xml.ParseException;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.editor.BaseAction;

public class AddToCodeRepositoryAction
extends BaseAction {
    static AddToCodeRepositoryDialog addDialog = new AddToCodeRepositoryDialog();

    public AddToCodeRepositoryAction() {
        super("Add to Code Repository");
        this.putValue("ShortDescription", "Add Selected Text to Code Repository");
    }

    public void actionPerformed(ActionEvent evt, JTextComponent target) {
        String selectedText = target.getSelectedText();
        if (selectedText == null || selectedText.length() == 0) {
            return;
        }
        while (addDialog.ask()) {
            DefaultMutableTreeNode rootNode;
            try {
                rootNode = addDialog.getUpdatedCodeRepository(selectedText);
            }
            catch (ParseException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "There was an error trying to open or parse opcodes.xml or codeRepository.xml");
                return;
            }
            if (rootNode == null) {
                JOptionPane.showMessageDialog(null, "Error: Code Snippet Name not filled in or Category not selected.");
                continue;
            }
            CodeRepositoryManager.saveCodeRepository(rootNode);
            return;
        }
    }
}

