/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.mixer;

import blue.mixer.Effect;
import blue.settings.GeneralSettings;
import blue.ui.utilities.FileChooserManager;
import electric.xml.Document;
import electric.xml.Element;
import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javafx.stage.FileChooser;
import javax.swing.JOptionPane;
import org.openide.windows.WindowManager;

public class EffectsUtil {
    private static final String IMPORT_DIALOG = "effect.import";
    private static final String EXPORT_DIALOG = "effect.export";

    public static void exportEffect(Effect effect) {
        File retVal = FileChooserManager.getDefault().showSaveDialog((Object)EXPORT_DIALOG, (Component)WindowManager.getDefault().getMainWindow());
        if (retVal != null) {
            int overWrite;
            File f = retVal;
            if (f.exists() && (overWrite = JOptionPane.showConfirmDialog(WindowManager.getDefault().getMainWindow(), "Please confirm you would like to overwrite this file.")) != 0) {
                return;
            }
            Element node = effect.saveAsXML();
            try {
                PrintWriter out = new PrintWriter(new FileWriter(f));
                out.print(node.toString());
                out.flush();
                out.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static Effect importEffect() {
        List retVal = FileChooserManager.getDefault().showOpenDialog((Object)IMPORT_DIALOG, (Component)WindowManager.getDefault().getMainWindow());
        Effect effect = null;
        if (!retVal.isEmpty()) {
            File f = (File)retVal.get(0);
            try {
                Document doc = new Document(f);
                Element root = doc.getRoot();
                if (root.getName().equals("effect")) {
                    effect = Effect.loadFromXML((Element)root);
                } else {
                    JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), "Error: File did not contain Effect", "Error", 0);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), "Error: Could not read Effect from file", "Error", 0);
            }
        }
        return effect;
    }

    static {
        File defaultFile = new File(GeneralSettings.getInstance().getDefaultDirectory() + File.separator + "default.effect");
        FileChooser.ExtensionFilter presetFilter = new FileChooser.ExtensionFilter("blue Effect File", new String[]{"*.effect"});
        FileChooserManager fcm = FileChooserManager.getDefault();
        fcm.addFilter((Object)IMPORT_DIALOG, presetFilter);
        fcm.setDialogTitle((Object)IMPORT_DIALOG, "Import Effect");
        fcm.setSelectedFile((Object)IMPORT_DIALOG, defaultFile);
        fcm.addFilter((Object)EXPORT_DIALOG, presetFilter);
        fcm.setDialogTitle((Object)EXPORT_DIALOG, "Export Effect");
        fcm.setSelectedFile((Object)EXPORT_DIALOG, defaultFile);
    }
}

