/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score;

import blue.WindowSettingManager;
import blue.WindowSettingsSavable;
import blue.ui.core.score.layers.LayerGroupPanel;
import blue.utility.GUI;
import electric.xml.Element;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

public class ScoreNavigatorDialog
extends JDialog
implements ComponentListener,
AdjustmentListener,
WindowSettingsSavable {
    private JScrollPane jScrollPane;
    private NavBox overBox = new NavBox();
    boolean isAdjusting = false;
    private JPanel layerPanel;

    public ScoreNavigatorDialog() {
        this((Frame)null);
    }

    public ScoreNavigatorDialog(Frame owner) {
        super(owner);
        this.setTitle("Navigation");
        this.setSize(new Dimension(80, 100));
        final JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.setDoubleBuffered(true);
        this.setContentPane(layeredPane);
        final PreviewPanel drawPanel = new PreviewPanel();
        layeredPane.add((Component)drawPanel, JLayeredPane.DEFAULT_LAYER);
        layeredPane.setBackground(Color.BLACK);
        layeredPane.add((Component)this.overBox, JLayeredPane.DRAG_LAYER);
        layeredPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ScoreNavigatorDialog.this.updateOverBox();
                drawPanel.setSize(layeredPane.getWidth(), layeredPane.getHeight());
                drawPanel.repaint();
            }
        });
        this.overBox.addComponentListener(this);
        WindowSettingManager.getInstance().registerWindow("JScrollNavigator", this);
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                drawPanel.repaint();
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        });
        this.getRootPane().putClientProperty("SeparateWindow", Boolean.TRUE);
    }

    public void setJScrollPane(JScrollPane jScrollPane) {
        this.jScrollPane = jScrollPane;
        Component view = jScrollPane.getViewport().getView();
        if (view != null) {
            view.addComponentListener(this);
            jScrollPane.getViewport().addComponentListener(this);
            jScrollPane.getHorizontalScrollBar().addAdjustmentListener(this);
            jScrollPane.getVerticalScrollBar().addAdjustmentListener(this);
            this.updateOverBox();
        }
    }

    private void updateOverBox() {
        this.isAdjusting = true;
        JViewport viewport = this.jScrollPane.getViewport();
        Dimension d = viewport.getViewSize();
        Rectangle vRect = viewport.getViewRect();
        int vWidth = d.width;
        int vHeight = d.height;
        int w = this.getContentPane().getWidth();
        int h = this.getContentPane().getHeight();
        float xMult = (float)w / (float)vWidth;
        float yMult = (float)h / (float)vHeight;
        int newX = (int)((float)vRect.x * xMult);
        int newY = (int)((float)vRect.y * yMult);
        int newW = (int)((float)vRect.width * xMult);
        int newH = (int)((float)vRect.height * yMult);
        this.overBox.setLocation(newX, newY);
        this.overBox.setSize(newW, newH);
        this.isAdjusting = false;
    }

    public static void main(String[] args) {
        GUI.setBlueLookAndFeel();
        JScrollPane jsp = new JScrollPane();
        JEditorPane blueEditorPane = new JEditorPane();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < 100; ++i) {
            buffer.append("test" + i + "\n");
        }
        blueEditorPane.setText(buffer.toString());
        jsp.setViewportView(blueEditorPane);
        ScoreNavigatorDialog nav = new ScoreNavigatorDialog();
        nav.setJScrollPane(jsp);
        GUI.showComponentAsStandalone((Component)jsp, (String)"JScrollNavigator Test", (boolean)true);
        nav.setModal(false);
        nav.setVisible(true);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        if (e.getSource() == this.jScrollPane.getViewport() || e.getSource() == this.jScrollPane.getViewport().getView()) {
            this.updateOverBox();
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        if (e.getSource() == this.overBox && this.overBox.origin != null) {
            this.isAdjusting = true;
            Rectangle r = this.overBox.getBounds();
            JViewport viewport = this.jScrollPane.getViewport();
            Dimension d = viewport.getViewSize();
            int vWidth = d.width;
            int vHeight = d.height;
            int w = this.getContentPane().getWidth();
            int h = this.getContentPane().getHeight();
            float xMult = (float)vWidth / (float)w;
            float yMult = (float)vHeight / (float)h;
            int newX = (int)((float)r.x * xMult);
            int newY = (int)((float)r.y * yMult);
            int newW = (int)((float)r.width * xMult);
            int newH = (int)((float)r.height * yMult);
            Rectangle newRect = new Rectangle(newX, newY, newW, newH);
            ((JComponent)viewport.getView()).scrollRectToVisible(newRect);
            this.isAdjusting = false;
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        if (!this.isAdjusting) {
            this.updateOverBox();
        }
    }

    public void setLayerPanel(JPanel layerPanel) {
        this.layerPanel = layerPanel;
    }

    @Override
    public void loadWindowSettings(Element settings) {
        WindowSettingManager.setBasicSettings(settings, this);
    }

    @Override
    public Element saveWindowSettings() {
        return WindowSettingManager.getBasicSettings(this);
    }

    private class PreviewPanel
    extends JComponent {
        public PreviewPanel() {
            this.setDoubleBuffered(true);
        }

        @Override
        public void paintComponent(Graphics g) {
            if (ScoreNavigatorDialog.this.jScrollPane == null) {
                return;
            }
            super.paintComponent(g);
            JComponent view = (JComponent)ScoreNavigatorDialog.this.jScrollPane.getViewport().getView();
            Graphics2D g2d = (Graphics2D)g.create();
            int w = this.getWidth();
            int h = this.getHeight();
            g2d.setColor(Color.BLACK);
            g2d.fillRect(0, 0, w, h);
            if (ScoreNavigatorDialog.this.layerPanel != null) {
                Component[] comps;
                double xscale = (double)w / (double)view.getWidth();
                double yscale = (double)h / (double)view.getHeight();
                g2d.scale(xscale, yscale);
                for (Component c : comps = ScoreNavigatorDialog.this.layerPanel.getComponents()) {
                    if (!(c instanceof LayerGroupPanel)) continue;
                    g2d.translate(c.getX(), c.getY());
                    ((LayerGroupPanel)((Object)c)).paintNavigatorView(g2d);
                    g2d.translate(-c.getX(), -c.getY());
                }
            }
            g2d.dispose();
        }
    }

    static class NavBox
    extends JPanel {
        boolean dragging = false;
        public Point origin = null;
        int originX = -1;
        int originY = -1;

        public NavBox() {
            this.setBorder(new LineBorder(Color.WHITE, 1));
            this.setBackground(new Color(255, 255, 255, 32));
            this.setOpaque(true);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    origin = SwingUtilities.convertPoint(this, e.getPoint(), this.getParent());
                    originX = this.getX();
                    originY = this.getY();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    origin = null;
                    originX = -1;
                    originY = -1;
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    NavBox box = this;
                    Container c = box.getParent();
                    int leftBound = -originX;
                    int rightBound = c.getWidth() - box.getWidth() - originX;
                    int topBound = -originY;
                    int bottomBound = c.getHeight() - box.getHeight() - originY;
                    Point p = SwingUtilities.convertPoint(box, e.getPoint(), c);
                    int xDiff = p.x - origin.x;
                    int yDiff = p.y - origin.y;
                    if (xDiff < leftBound) {
                        xDiff = leftBound;
                    }
                    if (xDiff > rightBound) {
                        xDiff = rightBound;
                    }
                    if (yDiff < topBound) {
                        yDiff = topBound;
                    }
                    if (yDiff > bottomBound) {
                        yDiff = bottomBound;
                    }
                    box.setLocation(originX + xDiff, originY + yDiff);
                }
            });
        }
    }
}

