/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.layers.soundObject.actions;

import blue.BlueData;
import blue.SoundLayer;
import blue.SoundObjectLibrary;
import blue.projects.BlueProjectManager;
import blue.score.Score;
import blue.score.ScoreObject;
import blue.score.TimeState;
import blue.score.layers.Layer;
import blue.score.layers.ScoreObjectLayer;
import blue.soundObject.Instance;
import blue.soundObject.PolyObject;
import blue.soundObject.SoundObject;
import blue.ui.core.score.ScoreController;
import blue.ui.core.score.ScorePath;
import blue.ui.core.score.undo.AddScoreObjectEdit;
import blue.undo.BlueUndoManager;
import blue.utility.ScoreUtilities;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.undo.UndoableEdit;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class PasteAsPolyObjectAction
extends AbstractAction
implements ContextAwareAction {
    private List<? extends ScoreObject> scoreObjects;
    private List<Integer> layerIndexes;
    private Point p;
    private TimeState timeState;
    private PolyObject pObj = new PolyObject();
    private final ScorePath scorePath;

    public PasteAsPolyObjectAction() {
        this(Utilities.actionsGlobalContext());
    }

    public PasteAsPolyObjectAction(Lookup lookup) {
        super(NbBundle.getMessage(PasteAsPolyObjectAction.class, (String)"CTL_PasteAsPolyObjectAction"));
        ScoreController scoreController = ScoreController.getInstance();
        Score score = scoreController.getScore();
        this.scoreObjects = scoreController.getScoreObjectBuffer().scoreObjects;
        this.layerIndexes = scoreController.getScoreObjectBuffer().layerIndexes;
        this.p = (Point)lookup.lookup(Point.class);
        this.timeState = (TimeState)lookup.lookup(TimeState.class);
        this.scorePath = (ScorePath)lookup.lookup(ScorePath.class);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i;
        BlueData data = BlueProjectManager.getInstance().getCurrentBlueData();
        SoundObjectLibrary sObjLib = data.getSoundObjectLibrary();
        ArrayList<Instance> instanceSoundObjects = new ArrayList<Instance>();
        ScoreController.ScoreObjectBuffer buffer = ScoreController.getInstance().getScoreObjectBuffer();
        double start = (double)this.p.x / (double)this.timeState.getPixelSecond();
        if (this.timeState.isSnapEnabled()) {
            start = ScoreUtilities.getSnapValueStart((double)start, (double)this.timeState.getSnapValue());
        }
        int minLayer = Integer.MAX_VALUE;
        int maxLayer = Integer.MIN_VALUE;
        for (Integer layerIndex : this.layerIndexes) {
            if (layerIndex < minLayer) {
                minLayer = layerIndex;
            }
            if (layerIndex <= maxLayer) continue;
            maxLayer = layerIndex;
        }
        int numLayers = maxLayer - minLayer + 1;
        for (i = 0; i < numLayers; ++i) {
            this.pObj.newLayerAt(-1);
        }
        for (i = 0; i < this.scoreObjects.size(); ++i) {
            ScoreObject scoreObj = this.scoreObjects.get(i);
            int layerIndex = this.layerIndexes.get(i);
            SoundLayer layer = (SoundLayer)this.pObj.get(layerIndex - minLayer);
            SoundObject clone = (SoundObject)scoreObj.deepCopy();
            layer.add(clone);
            if (!(clone instanceof Instance)) continue;
            instanceSoundObjects.add((Instance)clone);
        }
        sObjLib.checkAndAddInstanceSoundObjects(instanceSoundObjects);
        this.pObj.normalizeSoundObjects();
        this.pObj.setStartTime(start);
        ScoreObjectLayer layer = (ScoreObjectLayer)this.scorePath.getGlobalLayerForY(this.p.y);
        layer.add((Object)this.pObj);
        AddScoreObjectEdit edit = new AddScoreObjectEdit(layer, (ScoreObject)this.pObj);
        BlueUndoManager.setUndoManager((String)"score");
        BlueUndoManager.addEdit((UndoableEdit)edit);
    }

    @Override
    public boolean isEnabled() {
        for (ScoreObject scoreObject : this.scoreObjects) {
            if (scoreObject instanceof SoundObject) continue;
            return false;
        }
        Layer layer = this.scorePath.getGlobalLayerForY(this.p.y);
        return this.scoreObjects.size() > 0 && layer != null && layer.accepts((ScoreObject)this.pObj);
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new PasteAsPolyObjectAction(actionContext);
    }
}

