/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.object.actions;

import blue.score.ScoreObject;
import blue.ui.core.score.undo.SetColorEdit;
import blue.undo.BlueUndoManager;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JColorChooser;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public final class SetColorAction
extends AbstractAction
implements ContextAwareAction {
    private final Collection<? extends ScoreObject> scoreObjects;

    public SetColorAction() {
        this(Utilities.actionsGlobalContext());
    }

    public SetColorAction(Lookup lookup) {
        super(NbBundle.getMessage(SetColorAction.class, (String)"CTL_SetColorAction"));
        this.scoreObjects = lookup.lookupAll(ScoreObject.class);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.scoreObjects.size() > 0) {
            Color retVal = JColorChooser.showDialog(WindowManager.getDefault().getMainWindow(), "Choose Color", this.scoreObjects.iterator().next().getBackgroundColor());
            SetColorEdit top = null;
            if (retVal != null) {
                for (ScoreObject scoreObject : this.scoreObjects) {
                    Color old = scoreObject.getBackgroundColor();
                    scoreObject.setBackgroundColor(retVal);
                    SetColorEdit edit = new SetColorEdit(scoreObject, old, retVal);
                    if (top == null) {
                        top = edit;
                        continue;
                    }
                    top.addEdit(edit);
                }
                BlueUndoManager.setUndoManager((String)"score");
                BlueUndoManager.addEdit(top);
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return this.scoreObjects.size() > 0;
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new SetColorAction(actionContext);
    }
}

