/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.soundLayer;

import blue.SoundLayer;
import blue.automation.AutomationManager;
import blue.automation.Parameter;
import blue.automation.ParameterIdList;
import blue.components.ColorSelectionPanel;
import blue.noteProcessor.NoteProcessorChain;
import blue.noteProcessor.NoteProcessorChainMap;
import blue.ui.components.IconFactory;
import blue.ui.core.score.NoteProcessorDialog;
import blue.ui.core.score.ScoreController;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SoundLayerPanel
extends JPanel
implements ListSelectionListener,
PropertyChangeListener {
    private static Border NORMAL_BORDER = BorderFactory.createBevelBorder(0);
    private static Border SELECTED_BORDER = BorderFactory.createBevelBorder(0, Color.GREEN, Color.GREEN.darker());
    private static SoundLayerPanelMenu OTHER_MENU = null;
    private final SoundLayer sLayer;
    private boolean automatable = true;
    private final ParameterIdList paramIdList;
    boolean updating = false;
    private NoteProcessorChainMap npcMap;
    private JButton automationButton;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel4;
    private JToggleButton muteToggleButton;
    private JLabel nameLabel;
    private JTextField nameText;
    private JButton noteProcessorButton;
    private JButton otherMenuButton;
    private ColorSelectionPanel paramColorSelect;
    private JLabel paramNameLabel;
    private JButton paramNextButton;
    private JButton paramPreviousButton;
    private JPanel paramSelectPanel;
    private JToggleButton soloToggleButton;

    public SoundLayerPanel(SoundLayer soundLayer, NoteProcessorChainMap npcMap) {
        NoteProcessorChain npc;
        this.initComponents();
        this.setSelected(false);
        boolean automatable = ScoreController.getInstance().getScorePath().getLastLayerGroup() == null;
        this.muteToggleButton.putClientProperty("BlueToggleButton.selectColorOverride", Color.ORANGE.darker());
        this.soloToggleButton.putClientProperty("BlueToggleButton.selectColorOverride", Color.GREEN.darker());
        this.automationButton.setVisible(automatable);
        this.paramSelectPanel.setVisible(automatable);
        this.automatable = automatable;
        this.npcMap = npcMap;
        this.sLayer = soundLayer;
        this.sLayer.addPropertyChangeListener((PropertyChangeListener)this);
        this.muteToggleButton.setSelected(this.sLayer.isMuted());
        this.soloToggleButton.setSelected(this.sLayer.isSolo());
        this.nameLabel.setText(this.sLayer.getName());
        int size = this.sLayer.getNoteProcessorChain().size();
        this.noteProcessorButton.setBackground(size == 0 ? null : Color.GREEN);
        this.paramIdList = this.sLayer.getAutomationParameters();
        if (this.paramIdList != null) {
            this.paramIdList.addListSelectionListener((ListSelectionListener)this);
        }
        if ((npc = this.sLayer.getNoteProcessorChain()).size() > 0) {
            this.noteProcessorButton.setBackground(Color.RED.darker());
        } else {
            this.noteProcessorButton.setBackground(null);
        }
        this.updateParameterPanel();
    }

    public void setSelected(boolean val) {
        this.setBorder(val ? SELECTED_BORDER : NORMAL_BORDER);
    }

    public void editName() {
        if (this.sLayer == null) {
            return;
        }
        this.nameText.setText(this.sLayer.getName());
        ((CardLayout)this.jPanel1.getLayout()).show(this.jPanel1, "textField");
        this.nameText.requestFocusInWindow();
    }

    @Override
    public void removeNotify() {
        if (this.paramIdList != null) {
            this.paramIdList.removeListSelectionListener((ListSelectionListener)this);
        }
        if (this.sLayer != null) {
            this.sLayer.removePropertyChangeListener((PropertyChangeListener)this);
        }
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        if (this.paramIdList != null) {
            this.paramIdList.addListSelectionListener((ListSelectionListener)this);
        }
        if (this.sLayer != null) {
            this.sLayer.addPropertyChangeListener((PropertyChangeListener)this);
        }
        super.addNotify();
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.nameLabel = new JLabel();
        this.nameText = new JTextField();
        this.muteToggleButton = new JToggleButton();
        this.soloToggleButton = new JToggleButton();
        this.noteProcessorButton = new JButton();
        this.automationButton = new JButton();
        this.otherMenuButton = new JButton();
        this.paramSelectPanel = new JPanel();
        this.paramColorSelect = new ColorSelectionPanel();
        this.paramNameLabel = new JLabel();
        this.paramPreviousButton = new JButton();
        this.paramNextButton = new JButton();
        this.jPanel4 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                SoundLayerPanel.this.formComponentResized(evt);
            }
        });
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 2));
        this.jPanel1.setLayout(new CardLayout());
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.jPanel1.setMinimumSize(new Dimension(0, 0));
        this.jPanel1.setPreferredSize(new Dimension(17, 17));
        this.nameLabel.setText("SoundObject Name");
        this.nameLabel.setMinimumSize(new Dimension(0, 15));
        this.jPanel1.add((Component)this.nameLabel, "label");
        this.nameText.setText("SoundObject Name");
        this.nameText.setMinimumSize(new Dimension(0, 15));
        this.nameText.setPreferredSize(new Dimension(115, 17));
        this.nameText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundLayerPanel.this.nameTextActionPerformed(evt);
            }
        });
        this.nameText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SoundLayerPanel.this.nameTextFocusLost(evt);
            }
        });
        this.nameText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SoundLayerPanel.this.nameTextKeyPressed(evt);
            }
        });
        this.jPanel1.add((Component)this.nameText, "textField");
        this.jPanel2.add(this.jPanel1);
        this.muteToggleButton.setFont(new Font("Dialog", 1, 10));
        this.muteToggleButton.setText("M");
        this.muteToggleButton.setFocusPainted(false);
        this.muteToggleButton.setFocusable(false);
        this.muteToggleButton.setMargin(new Insets(0, 3, 0, 3));
        this.muteToggleButton.setMaximumSize(new Dimension(19, 19));
        this.muteToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundLayerPanel.this.muteToggleButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.muteToggleButton);
        this.soloToggleButton.setFont(new Font("Dialog", 1, 10));
        this.soloToggleButton.setText("S");
        this.soloToggleButton.setFocusPainted(false);
        this.soloToggleButton.setFocusable(false);
        this.soloToggleButton.setMargin(new Insets(0, 3, 0, 3));
        this.soloToggleButton.setMaximumSize(new Dimension(19, 19));
        this.soloToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundLayerPanel.this.soloToggleButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.soloToggleButton);
        this.noteProcessorButton.setFont(new Font("Dialog", 1, 10));
        this.noteProcessorButton.setText("N");
        this.noteProcessorButton.setFocusPainted(false);
        this.noteProcessorButton.setFocusable(false);
        this.noteProcessorButton.setMargin(new Insets(0, 3, 0, 3));
        this.noteProcessorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundLayerPanel.this.noteProcessorButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.noteProcessorButton);
        this.automationButton.setFont(new Font("Dialog", 1, 10));
        this.automationButton.setText("A");
        this.automationButton.setToolTipText("Automation Settings");
        this.automationButton.setFocusPainted(false);
        this.automationButton.setFocusable(false);
        this.automationButton.setMargin(new Insets(0, 3, 0, 3));
        this.automationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundLayerPanel.this.automationButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.automationButton);
        this.otherMenuButton.setFont(new Font("Dialog", 1, 10));
        this.otherMenuButton.setIcon(IconFactory.getDownArrowIcon());
        this.otherMenuButton.setToolTipText("Automation Settings");
        this.otherMenuButton.setFocusPainted(false);
        this.otherMenuButton.setFocusable(false);
        this.otherMenuButton.setMargin(new Insets(5, 0, 4, 0));
        this.otherMenuButton.setMaximumSize(new Dimension(19, 19));
        this.otherMenuButton.setPreferredSize(new Dimension(16, 17));
        this.otherMenuButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundLayerPanel.this.otherMenuButtonActionPerformed(evt);
            }
        });
        this.jPanel2.add(this.otherMenuButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.paramSelectPanel.setLayout(new BoxLayout(this.paramSelectPanel, 2));
        this.paramSelectPanel.setFocusable(false);
        this.paramSelectPanel.setPreferredSize(new Dimension(100, 19));
        this.paramColorSelect.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.paramColorSelect.setToolTipText("Parameter Line Color");
        this.paramColorSelect.setMaximumSize(new Dimension(15, 15));
        this.paramColorSelect.setPreferredSize(new Dimension(15, 15));
        this.paramColorSelect.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SoundLayerPanel.this.paramColorSelectPropertyChange(evt);
            }
        });
        this.paramSelectPanel.add(this.paramColorSelect);
        this.paramNameLabel.setFont(new Font("Dialog", 0, 10));
        this.paramNameLabel.setText("jLabel1");
        this.paramNameLabel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
        this.paramNameLabel.setFocusable(false);
        this.paramNameLabel.setMaximumSize(new Dimension(32768, 15));
        this.paramNameLabel.setPreferredSize(new Dimension(100, 15));
        this.paramSelectPanel.add(this.paramNameLabel);
        this.paramPreviousButton.setFont(new Font("Dialog", 1, 10));
        this.paramPreviousButton.setIcon(IconFactory.getLeftArrowIcon());
        this.paramPreviousButton.setToolTipText("Automation Settings");
        this.paramPreviousButton.setFocusPainted(false);
        this.paramPreviousButton.setFocusable(false);
        this.paramPreviousButton.setMargin(new Insets(0, 0, 0, 0));
        this.paramPreviousButton.setMaximumSize(new Dimension(15, 15));
        this.paramPreviousButton.setPreferredSize(new Dimension(18, 17));
        this.paramPreviousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundLayerPanel.this.paramPreviousButtonActionPerformed(evt);
            }
        });
        this.paramSelectPanel.add(this.paramPreviousButton);
        this.paramNextButton.setFont(new Font("Dialog", 1, 10));
        this.paramNextButton.setIcon(IconFactory.getRightArrowIcon());
        this.paramNextButton.setToolTipText("Automation Settings");
        this.paramNextButton.setFocusPainted(false);
        this.paramNextButton.setFocusable(false);
        this.paramNextButton.setMargin(new Insets(0, 0, 0, 0));
        this.paramNextButton.setMaximumSize(new Dimension(15, 15));
        this.paramNextButton.setPreferredSize(new Dimension(17, 17));
        this.paramNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundLayerPanel.this.paramNextButtonActionPerformed(evt);
            }
        });
        this.paramSelectPanel.add(this.paramNextButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.paramSelectPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel4, gridBagConstraints);
    }

    private void otherMenuButtonActionPerformed(ActionEvent evt) {
        if (OTHER_MENU == null) {
            OTHER_MENU = new SoundLayerPanelMenu();
        }
        OTHER_MENU.setSoundLayer(this.sLayer);
        OTHER_MENU.show(this.otherMenuButton, 0, this.otherMenuButton.getHeight());
    }

    private void paramColorSelectPropertyChange(PropertyChangeEvent evt) {
        if (this.sLayer == null || this.paramIdList == null || this.updating) {
            return;
        }
        int index = this.paramIdList.getSelectedIndex();
        if (index < 0) {
            return;
        }
        String id = this.paramIdList.getParameterId(index);
        Parameter param = AutomationManager.getInstance().getParameter(id);
        if (param != null) {
            param.getLine().setColor(this.paramColorSelect.getColor());
        }
    }

    private void formComponentResized(ComponentEvent evt) {
        if (this.sLayer == null) {
            return;
        }
        if (this.automatable && this.sLayer.getAutomationParameters().size() > 0) {
            this.paramSelectPanel.setVisible(this.getHeight() > 22);
        } else {
            this.paramSelectPanel.setVisible(false);
        }
    }

    private void paramNextButtonActionPerformed(ActionEvent evt) {
        if (this.sLayer == null || this.paramIdList == null || this.paramIdList.size() < 2) {
            return;
        }
        int index = this.paramIdList.getSelectedIndex() + 1;
        if (index >= this.paramIdList.size()) {
            index = 0;
        }
        this.paramIdList.setSelectedIndex(index);
    }

    private void paramPreviousButtonActionPerformed(ActionEvent evt) {
        if (this.sLayer == null || this.paramIdList == null || this.paramIdList.size() < 2) {
            return;
        }
        int index = this.paramIdList.getSelectedIndex() - 1;
        if (index < 0) {
            index = this.paramIdList.size() - 1;
        }
        this.paramIdList.setSelectedIndex(index);
    }

    private void automationButtonActionPerformed(ActionEvent evt) {
        JPopupMenu menu = AutomationManager.getInstance().getAutomationMenu(this.sLayer.getAutomationParameters());
        menu.show(this.automationButton, 0, this.automationButton.getHeight());
    }

    private void nameTextKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 27) {
            ((CardLayout)this.jPanel1.getLayout()).show(this.jPanel1, "label");
        }
    }

    private void nameTextFocusLost(FocusEvent evt) {
        ((CardLayout)this.jPanel1.getLayout()).show(this.jPanel1, "label");
    }

    private void nameTextActionPerformed(ActionEvent evt) {
        if (this.sLayer == null) {
            return;
        }
        this.sLayer.setName(this.nameText.getText());
        this.nameLabel.setText(this.sLayer.getName());
        ((CardLayout)this.jPanel1.getLayout()).show(this.jPanel1, "label");
    }

    private void noteProcessorButtonActionPerformed(ActionEvent evt) {
        NoteProcessorDialog dialog = NoteProcessorDialog.getInstance();
        NoteProcessorChain npc = this.sLayer.getNoteProcessorChain();
        dialog.setNoteProcessorChain(npc);
        dialog.setNoteProcessorChainMap(this.npcMap);
        dialog.ask();
        if (npc.size() > 0) {
            this.noteProcessorButton.setBackground(Color.RED.darker());
        } else {
            this.noteProcessorButton.setBackground(null);
        }
    }

    private void soloToggleButtonActionPerformed(ActionEvent evt) {
        if (this.sLayer == null) {
            return;
        }
        this.sLayer.setSolo(this.soloToggleButton.isSelected());
    }

    private void muteToggleButtonActionPerformed(ActionEvent evt) {
        if (this.sLayer == null) {
            return;
        }
        this.sLayer.setMuted(this.muteToggleButton.isSelected());
    }

    private void updateParameterPanel() {
        if (!this.automatable) {
            this.paramSelectPanel.setVisible(false);
            return;
        }
        int index = this.paramIdList.getSelectedIndex();
        if (this.paramIdList.size() <= 0 || index < 0) {
            this.updating = true;
            this.paramColorSelect.setEnabled(false);
            this.paramColorSelect.setColor(Color.BLACK);
            this.updating = false;
            this.paramNameLabel.setText("No Parameters Available");
            this.paramNameLabel.setEnabled(false);
            this.paramNextButton.setEnabled(false);
            this.paramPreviousButton.setEnabled(false);
            this.paramSelectPanel.setVisible(false);
            return;
        }
        String id = this.paramIdList.getParameterId(index);
        Parameter param = AutomationManager.getInstance().getParameter(id);
        if (param == null) {
            this.updating = true;
            this.paramColorSelect.setEnabled(false);
            this.paramColorSelect.setColor(Color.BLACK);
            this.updating = false;
            this.paramNameLabel.setText("No Parameters Available");
            this.paramNameLabel.setEnabled(false);
            this.paramNextButton.setEnabled(false);
            this.paramPreviousButton.setEnabled(false);
            this.paramSelectPanel.setVisible(false);
            return;
        }
        if (this.getHeight() > 22) {
            this.paramSelectPanel.setVisible(true);
        }
        this.updating = true;
        this.paramColorSelect.setEnabled(true);
        this.paramColorSelect.setColor(param.getLine().getColor());
        this.paramNameLabel.setText(param.getName());
        this.paramNameLabel.setEnabled(true);
        int size = this.paramIdList.size();
        this.paramNextButton.setEnabled(true);
        this.paramPreviousButton.setEnabled(true);
        this.updating = false;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateParameterPanel();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.sLayer) {
            String propName;
            switch (propName = evt.getPropertyName()) {
                case "heightIndex": {
                    this.revalidate();
                    break;
                }
                case "name": {
                    this.nameText.setText(this.sLayer.getName());
                    this.nameLabel.setText(this.sLayer.getName());
                }
            }
        }
    }

    static class SoundLayerPanelMenu
    extends JPopupMenu {
        SoundLayer soundLayer = null;
        JMenuItem[] heightItems = new JMenuItem[9];

        public SoundLayerPanelMenu() {
            JMenu layerHeightMenu = new JMenu("Layer Height");
            ActionListener al = ae -> {
                if (this.soundLayer == null) {
                    return;
                }
                int heightIndex = Integer.parseInt(ae.getActionCommand()) - 1;
                this.soundLayer.setHeightIndex(heightIndex);
            };
            for (int i = 0; i < this.heightItems.length; ++i) {
                this.heightItems[i] = new JMenuItem(Integer.toString(i + 1));
                this.heightItems[i].addActionListener(al);
                layerHeightMenu.add(this.heightItems[i]);
            }
            this.add(layerHeightMenu);
        }

        public void setSoundLayer(SoundLayer sLayer) {
            this.soundLayer = sLayer;
            this.setupHeightMenu();
        }

        private void setupHeightMenu() {
            if (this.soundLayer == null) {
                return;
            }
            int index = this.soundLayer.getHeightIndex();
            for (int i = 0; i < this.heightItems.length; ++i) {
                this.heightItems[i].setEnabled(i != index);
            }
        }
    }
}

