/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.udo;

import blue.BlueSystem;
import blue.event.SelectionEvent;
import blue.event.SelectionListener;
import blue.udo.UDOLibrary;
import blue.udo.UserDefinedOpcode;
import blue.ui.core.udo.UDOTreeDragSource;
import blue.ui.core.udo.UDOTreeDropTarget;
import blue.ui.core.udo.UDOTreePopup;
import blue.ui.utilities.UiUtilities;
import blue.utility.GUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class UDOLibraryPanel
extends JComponent {
    private static final UDOTreePopup popup = new UDOTreePopup();
    public UDOLibrary iLibrary = null;
    JTree libraryTree = new JTree();
    ArrayList<SelectionListener> listeners = new ArrayList();

    public UDOLibraryPanel() {
        this.setLayout(new BorderLayout());
        JLabel label = new JLabel("User-Defined Opcode Library");
        this.add((Component)label, "North");
        label.setMinimumSize(new Dimension(0, 0));
        label.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(0), new EmptyBorder(3, 3, 3, 3)));
        JScrollPane libraryScroll = new JScrollPane(this.libraryTree);
        libraryScroll.setBorder(null);
        libraryScroll.setMinimumSize(new Dimension(0, 0));
        this.add((Component)libraryScroll, "Center");
        this.libraryTree.setEditable(true);
        ToolTipManager.sharedInstance().registerComponent(this.libraryTree);
        new UDOTreeDragSource(this.libraryTree, 3);
        new UDOTreeDropTarget(this.libraryTree);
        this.libraryTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path = UDOLibraryPanel.this.libraryTree.getSelectionPath();
                if (path == null) {
                    return;
                }
                Object userObject = path.getLastPathComponent();
                if (UiUtilities.isRightMouseButton((MouseEvent)e)) {
                    UDOLibraryPanel.this.showPopup(userObject, e.getX(), e.getY());
                } else {
                    SelectionEvent se = new SelectionEvent(userObject, 0);
                    UDOLibraryPanel.this.fireSelected(se);
                }
            }
        });
        InputMap inputMap = this.libraryTree.getInputMap(0);
        ActionMap actionMap = this.libraryTree.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(88, BlueSystem.getMenuShortcutKey()), "cutNode");
        inputMap.put(KeyStroke.getKeyStroke(67, BlueSystem.getMenuShortcutKey()), "copyNode");
        inputMap.put(KeyStroke.getKeyStroke(86, BlueSystem.getMenuShortcutKey()), "pasteNode");
        inputMap.put(KeyStroke.getKeyStroke(127, 0), "deleteNode");
        actionMap.put("cutNode", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UDOLibraryPanel.this.cutNode();
            }
        });
        actionMap.put("copyNode", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UDOLibraryPanel.this.copyNode();
            }
        });
        actionMap.put("pasteNode", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UDOLibraryPanel.this.pasteNode();
            }
        });
        actionMap.put("deleteNode", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UDOLibraryPanel.this.deleteNode();
            }
        });
        this.libraryTree.getSelectionModel().setSelectionMode(1);
        this.iLibrary = BlueSystem.getUDOLibrary();
        this.libraryTree.setModel((TreeModel)this.iLibrary);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.listeners.remove(listener);
    }

    public void fireSelected(SelectionEvent se) {
        for (SelectionListener listener : this.listeners) {
            listener.selectionPerformed(se);
        }
    }

    protected void cutNode() {
        TreePath path = this.libraryTree.getSelectionPath();
        if (path == null) {
            return;
        }
        Object userObj = path.getLastPathComponent();
        popup.setInstrumentGUI(this);
        popup.setUserObj(userObj);
        popup.cutNode();
    }

    protected void copyNode() {
        TreePath path = this.libraryTree.getSelectionPath();
        if (path == null) {
            return;
        }
        Object userObj = path.getLastPathComponent();
        popup.setInstrumentGUI(this);
        popup.setUserObj(userObj);
        popup.copyNode();
    }

    protected void pasteNode() {
        TreePath path = this.libraryTree.getSelectionPath();
        if (path == null) {
            return;
        }
        Object userObj = path.getLastPathComponent();
        popup.setInstrumentGUI(this);
        popup.setUserObj(userObj);
        popup.pasteNode();
    }

    protected void deleteNode() {
        TreePath path = this.libraryTree.getSelectionPath();
        if (path == null) {
            return;
        }
        Object userObj = path.getLastPathComponent();
        popup.setInstrumentGUI(this);
        popup.setUserObj(userObj);
        popup.deleteNode();
    }

    private void showPopup(Object userObj, int x, int y) {
        popup.show(this, userObj, x, y);
    }

    public void removeUDO(UserDefinedOpcode udo) {
        this.iLibrary.removeUDO(udo);
    }

    public UserDefinedOpcode getSelectedUDO() {
        TreePath selectionPath = this.libraryTree.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        Object obj = selectionPath.getLastPathComponent();
        if (obj instanceof UserDefinedOpcode) {
            return (UserDefinedOpcode)obj;
        }
        return null;
    }

    public static void main(String[] args) {
        GUI.showComponentAsStandalone((Component)new UDOLibraryPanel(), (String)"UDO Library", (boolean)true);
    }

    public void deselect() {
        this.libraryTree.clearSelection();
    }
}

