/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.udo;

import blue.BlueSystem;
import blue.udo.UDOCategory;
import blue.udo.UserDefinedOpcode;
import blue.ui.core.udo.UDOBuffer;
import blue.ui.core.udo.UDOLibraryPanel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

class UDOTreePopup
extends JPopupMenu {
    Object userObj;
    UDOLibraryPanel instrGUI;
    JMenuItem addCategoryMenuItem = new JMenuItem(BlueSystem.getString((String)"codeRepository.addGroup"));
    JMenuItem removeCategoryMenuItem = new JMenuItem(BlueSystem.getString((String)"codeRepository.removeGroup"));
    JMenuItem addInstrumentMenu;
    JMenuItem removeInstrumentMenuItem = new JMenuItem(BlueSystem.getString((String)"common.remove"));
    JMenuItem cutMenuItem = new JMenuItem(BlueSystem.getString((String)"instrument.cut"));
    JMenuItem copyMenuItem = new JMenuItem(BlueSystem.getString((String)"instrument.copy"));
    JMenuItem pasteMenuItem = new JMenuItem(BlueSystem.getString((String)"instrument.paste"));
    JPopupMenu.Separator sep = new JPopupMenu.Separator();

    public UDOTreePopup() {
        this.addCategoryMenuItem.addActionListener(e -> this.addUDOCategory());
        this.removeCategoryMenuItem.addActionListener(e -> this.removeUDOCategory());
        this.removeInstrumentMenuItem.addActionListener(e -> this.removeUDO());
        this.cutMenuItem.addActionListener(e -> this.cutNode());
        this.copyMenuItem.addActionListener(e -> this.copyNode());
        this.pasteMenuItem.addActionListener(e -> this.pasteNode());
        this.addInstrumentMenu = this.getAddUDOMenu();
        this.add(this.addCategoryMenuItem);
        this.add(this.removeCategoryMenuItem);
        this.add(this.sep);
        this.add(this.addInstrumentMenu);
        this.add(this.removeInstrumentMenuItem);
        this.addSeparator();
        this.add(this.cutMenuItem);
        this.add(this.copyMenuItem);
        this.add(this.pasteMenuItem);
    }

    public void setUserObj(Object obj) {
        this.userObj = obj;
    }

    public void setInstrumentGUI(UDOLibraryPanel instrGUI) {
        this.instrGUI = instrGUI;
    }

    protected void cutNode() {
        if (this.userObj == this.instrGUI.iLibrary.getRoot() || this.userObj == null) {
            return;
        }
        this.copyNode();
        this.deleteNode();
    }

    protected void deleteNode() {
        if (this.userObj == this.instrGUI.iLibrary.getRoot()) {
            return;
        }
        if (this.userObj instanceof UserDefinedOpcode) {
            this.removeUDO();
        } else {
            this.removeUDOCategory();
        }
    }

    protected void copyNode() {
        if (this.userObj == this.instrGUI.iLibrary.getRoot()) {
            return;
        }
        Object bufObj = this.userObj instanceof UserDefinedOpcode ? new UserDefinedOpcode((UserDefinedOpcode)this.userObj) : new UDOCategory((UDOCategory)this.userObj);
        UDOBuffer.getInstance().setBufferedObject(bufObj);
    }

    protected void pasteNode() {
        Object bufferedObj = UDOBuffer.getInstance().getBufferedObject();
        if (this.userObj instanceof UserDefinedOpcode || bufferedObj == null) {
            return;
        }
        if (bufferedObj instanceof UserDefinedOpcode) {
            this.addUDO((UserDefinedOpcode)bufferedObj);
        } else if (bufferedObj instanceof UserDefinedOpcode[]) {
            for (UserDefinedOpcode udo : (UserDefinedOpcode[])bufferedObj) {
                this.addUDO(udo);
            }
        } else {
            this.addUDOCategory(new UDOCategory((UDOCategory)bufferedObj));
        }
    }

    private void addUDOCategory() {
        UDOCategory newCategory = new UDOCategory();
        this.addUDOCategory(newCategory);
    }

    private void addUDOCategory(UDOCategory iCategory) {
        if (this.userObj instanceof UserDefinedOpcode) {
            return;
        }
        this.instrGUI.iLibrary.addCategory((UDOCategory)this.userObj, iCategory);
    }

    private void removeUDOCategory() {
        UDOCategory category = (UDOCategory)this.userObj;
        this.instrGUI.iLibrary.removeCategory(category);
    }

    private void addUDO() {
        UserDefinedOpcode newUDO = new UserDefinedOpcode();
        UDOCategory currentCategory = (UDOCategory)this.userObj;
        this.instrGUI.iLibrary.addUDO(currentCategory, newUDO);
    }

    private void addUDO(UserDefinedOpcode udo) {
        UserDefinedOpcode newUDO = new UserDefinedOpcode(udo);
        UDOCategory currentCategory = (UDOCategory)this.userObj;
        this.instrGUI.iLibrary.addUDO(currentCategory, newUDO);
    }

    private void removeUDO() {
        UserDefinedOpcode udo = (UserDefinedOpcode)this.userObj;
        this.instrGUI.removeUDO(udo);
    }

    public void show(UDOLibraryPanel instrGui, Object userObj, int x, int y) {
        this.instrGUI = instrGui;
        this.userObj = userObj;
        if (userObj instanceof UDOCategory) {
            this.addCategoryMenuItem.setVisible(true);
            if (((UDOCategory)userObj).isRoot()) {
                this.removeCategoryMenuItem.setVisible(false);
            } else {
                this.removeCategoryMenuItem.setVisible(true);
            }
            this.addInstrumentMenu.setVisible(true);
            this.removeInstrumentMenuItem.setVisible(false);
            this.sep.setVisible(true);
        } else {
            this.addCategoryMenuItem.setVisible(false);
            this.removeCategoryMenuItem.setVisible(false);
            this.addInstrumentMenu.setVisible(false);
            this.removeInstrumentMenuItem.setVisible(true);
            this.sep.setVisible(false);
        }
        this.setBufferMenuItems();
        super.show(instrGui, x, y);
    }

    private void setBufferMenuItems() {
        Object bufferedObj = UDOBuffer.getInstance().getBufferedObject();
        this.pasteMenuItem.setEnabled(bufferedObj != null);
        if (this.userObj instanceof UDOCategory && ((UDOCategory)this.userObj).isRoot()) {
            this.cutMenuItem.setEnabled(false);
            this.copyMenuItem.setEnabled(false);
        } else {
            this.cutMenuItem.setEnabled(true);
            this.copyMenuItem.setEnabled(true);
        }
        this.cutMenuItem.setText(BlueSystem.getString((String)"common.cut"));
        this.copyMenuItem.setText(BlueSystem.getString((String)"common.copy"));
        this.pasteMenuItem.setText(BlueSystem.getString((String)"common.paste"));
    }

    private JMenuItem getAddUDOMenu() {
        JMenuItem instrumentMenu = new JMenuItem("Add User-Defined Opcode");
        instrumentMenu.addActionListener(ae -> this.addUDO());
        return instrumentMenu;
    }
}

