/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.udo;

import blue.projects.BlueProject;
import blue.projects.BlueProjectManager;
import blue.udo.OpcodeList;
import blue.udo.UserDefinedOpcode;
import blue.ui.core.udo.OpcodeListEditPanel;
import blue.ui.core.udo.UDOEditor;
import blue.ui.core.udo.UDOLibraryPanel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.util.Properties;
import javax.swing.GroupLayout;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="UserDefinedOpcodeTopComponent", persistenceType=0)
public final class UserDefinedOpcodeTopComponent
extends TopComponent {
    private static UserDefinedOpcodeTopComponent instance;
    Border libraryBorder = new LineBorder(Color.GREEN);
    private boolean isChanging = false;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private OpcodeListEditPanel opcodeListEditPanel1;
    private UDOEditor uDOEditor1;
    private UDOLibraryPanel uDOLibraryPanel1;

    private UserDefinedOpcodeTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(UserDefinedOpcodeTopComponent.class, (String)"CTL_UserDefinedOpcodeTopComponent"));
        this.setToolTipText(NbBundle.getMessage(UserDefinedOpcodeTopComponent.class, (String)"HINT_UserDefinedOpcodeTopComponent"));
        this.uDOLibraryPanel1.addSelectionListener(e -> {
            Object obj = e.getSelectedItem();
            this.isChanging = true;
            if (obj instanceof UserDefinedOpcode) {
                this.uDOEditor1.editUserDefinedOpcode((UserDefinedOpcode)obj);
                this.uDOEditor1.setBorder(this.libraryBorder);
            } else {
                this.uDOEditor1.editUserDefinedOpcode(null);
                this.uDOEditor1.setBorder(null);
            }
            this.opcodeListEditPanel1.deselect();
            this.isChanging = false;
        });
        this.opcodeListEditPanel1.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting() || this.isChanging) {
                return;
            }
            UserDefinedOpcode[] udos = this.opcodeListEditPanel1.getSelectedUDOs();
            if (udos != null && udos.length == 1) {
                this.uDOEditor1.editUserDefinedOpcode(udos[0]);
                this.uDOEditor1.setBorder(null);
            } else {
                this.uDOEditor1.editUserDefinedOpcode(null);
                this.uDOEditor1.setBorder(null);
            }
            this.uDOLibraryPanel1.deselect();
        });
        BlueProjectManager.getInstance().addPropertyChangeListener(evt -> {
            if ("currentProject".equals(evt.getPropertyName())) {
                this.reinitialize();
            }
        });
        this.reinitialize();
    }

    private void reinitialize() {
        BlueProject project = BlueProjectManager.getInstance().getCurrentProject();
        if (project == null) {
            this.opcodeListEditPanel1.setOpcodeList(null);
        } else {
            OpcodeList opcodeList = project.getData().getOpcodeList();
            this.opcodeListEditPanel1.setOpcodeList(opcodeList);
        }
    }

    private void initComponents() {
        this.jSplitPane2 = new JSplitPane();
        this.jSplitPane1 = new JSplitPane();
        this.uDOEditor1 = new UDOEditor();
        this.opcodeListEditPanel1 = new OpcodeListEditPanel();
        this.uDOLibraryPanel1 = new UDOLibraryPanel();
        this.jSplitPane2.setDividerLocation(200);
        this.jSplitPane2.setMinimumSize(new Dimension(0, 0));
        this.jSplitPane1.setDividerLocation(200);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setMinimumSize(new Dimension(0, 0));
        this.jSplitPane1.setRightComponent(this.uDOEditor1);
        this.jSplitPane1.setTopComponent(this.opcodeListEditPanel1);
        this.jSplitPane2.setRightComponent(this.jSplitPane1);
        this.jSplitPane2.setLeftComponent(this.uDOLibraryPanel1);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane2, -1, 518, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane2, -1, 367, Short.MAX_VALUE));
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

