/*
 * Decompiled with CFR 0.152.
 */
package blue.csnd6.render;

import blue.BlueData;
import blue.BlueSystem;
import blue.LiveData;
import blue.ProjectProperties;
import blue.automation.Parameter;
import blue.csnd6.render.BlueCallbackWrapper;
import blue.event.PlayModeListener;
import blue.noteProcessor.TempoMapper;
import blue.orchestra.blueSynthBuilder.StringChannel;
import blue.services.render.CSDRenderService;
import blue.services.render.CsdRenderResult;
import blue.services.render.CsoundBinding;
import blue.services.render.RealtimeRenderService;
import blue.services.render.RenderTimeManager;
import blue.settings.GeneralSettings;
import blue.settings.PlaybackSettings;
import blue.settings.ProjectPropertiesUtil;
import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import blue.soundObject.SoundObjectException;
import blue.utility.FileUtilities;
import blue.utility.ScoreUtilities;
import blue.utility.TextUtilities;
import csnd6.Csound;
import csnd6.CsoundArgVList;
import csnd6.CsoundMYFLTArray;
import csnd6.controlChannelType;
import csnd6.csnd6;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.windows.IOColors;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class CS6RealtimeRenderService
implements RealtimeRenderService,
PlayModeListener {
    List<PlayModeListener> listeners = null;
    private BlueData data = null;
    APIRunnerThread runnerThread = null;
    JCheckBox disableMessagesBox = null;
    JPanel errorPanel = null;
    private boolean shouldStop;
    private BlueCallbackWrapper blueCallbackWrapper;
    private InputOutput io = null;
    private final List<CsoundBinding> bindings = new ArrayList<CsoundBinding>();
    private Csound csound;

    public CS6RealtimeRenderService() {
        csnd6.csoundInitialize(csnd6.CSOUNDINIT_NO_ATEXIT | csnd6.CSOUNDINIT_NO_SIGNAL_HANDLER);
    }

    public String toString() {
        return "Csound 6 API";
    }

    public boolean isRunning() {
        return this.runnerThread != null;
    }

    public void play(BlueData blueData, CsdRenderResult result, String[] args, File currentWorkingDirectory, double renderStart) {
        if (this.runnerThread != null) {
            this.runnerThread.setKeepRunning(false);
            this.runnerThread.await();
        }
        this.csound = new Csound();
        this.blueCallbackWrapper = new BlueCallbackWrapper(this.csound);
        this.blueCallbackWrapper.SetMessageCallback();
        if (this.io != null) {
            try {
                this.io.getOut().reset();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.io = IOProvider.getDefault().getIO("Csound", false);
        IOColors.setColor((InputOutput)this.io, (IOColors.OutputType)IOColors.OutputType.OUTPUT, (Color)Color.WHITE);
        this.blueCallbackWrapper.setInputOutput(this.io);
        CsoundArgVList argsList = new CsoundArgVList();
        this.io.getOut().append((CharSequence)"Render Command (");
        for (int i = 0; i < args.length; ++i) {
            argsList.Append(args[i]);
            this.io.getOut().append((CharSequence)" ").append(args[i]);
        }
        if (currentWorkingDirectory != null) {
            String sfdir = "--env:SFDIR=" + currentWorkingDirectory.getAbsolutePath();
            argsList.Append(sfdir);
            this.io.getOut().append((CharSequence)" ").append(sfdir);
        }
        this.io.getOut().append((CharSequence)" )\n");
        int retVal = this.csound.Compile(argsList.argc(), argsList.argv());
        if (retVal != 0) {
            if (GeneralSettings.getInstance().isCsoundErrorWarningEnabled()) {
                if (this.errorPanel == null) {
                    this.errorPanel = new JPanel(new BorderLayout());
                    this.errorPanel.add((Component)new JLabel("<html>There was an error in running Csound.<br>Please view the Csound Output Dialog for more information.<br><br></html>"), "Center");
                    this.disableMessagesBox = new JCheckBox("Disable Error Message Dialog");
                    this.errorPanel.add((Component)this.disableMessagesBox, "South");
                }
                this.disableMessagesBox.setSelected(false);
                SwingUtilities.invokeLater(() -> {
                    JOptionPane.showMessageDialog(null, this.errorPanel, "Csound Error", 0);
                    if (this.disableMessagesBox.isSelected()) {
                        GeneralSettings.getInstance().setCsoundErrorWarningEnabled(false);
                        GeneralSettings.getInstance().save();
                    }
                });
            }
            this.notifyPlayModeListeners(0);
            this.csound.Stop();
            this.csound.Cleanup();
            this.csound.SetMessageCallback(null);
            this.csound.Reset();
            this.csound = null;
            this.blueCallbackWrapper = null;
            return;
        }
        this.runnerThread = new APIRunnerThread(blueData, this.csound, this, result.getParameters(), result.getStringChannels(), result.getTempoMapper(), renderStart, this.bindings);
        this.notifyPlayModeListeners(1);
        Thread t = new Thread(this.runnerThread);
        t.setPriority(10);
        t.start();
    }

    public void render() throws SoundObjectException {
        if (this.data == null) {
            return;
        }
        this.shouldStop = false;
        try {
            String command = ProjectPropertiesUtil.getRealtimeCommandLine((ProjectProperties)this.data.getProjectProperties());
            String globalSco = this.data.getGlobalOrcSco().getGlobalSco();
            globalSco = TextUtilities.stripMultiLineComments((String)globalSco);
            globalSco = TextUtilities.stripSingleLineComments((String)globalSco);
            double startTime = this.data.getRenderStartTime();
            double endTime = this.data.getRenderEndTime();
            CsdRenderResult result = CSDRenderService.getDefault().generateCSD(this.data, startTime, endTime, true, true);
            RenderTimeManager timeManager = (RenderTimeManager)Lookup.getDefault().lookup(RenderTimeManager.class);
            timeManager.setTempoMapper(result.getTempoMapper());
            String csd = result.getCsdText();
            File temp = FileUtilities.createTempTextFile((String)"tempCsd", (String)".csd", (File)BlueSystem.getCurrentProjectDirectory(), (String)csd);
            String[] args = command.split("\\s+");
            String[] args2 = new String[args.length + 1];
            System.arraycopy(args, 0, args2, 0, args.length);
            args2[args.length] = temp.getAbsolutePath();
            this.play(null, result, args2, BlueSystem.getCurrentProjectDirectory(), startTime);
        }
        catch (SoundObjectException soe) {
            throw soe;
        }
        catch (Exception ex) {
            StatusDisplayer.getDefault().setStatusText("[" + BlueSystem.getString((String)"message.error") + "] " + BlueSystem.getString((String)"message.generateScore.error"));
            ex.printStackTrace();
        }
    }

    public void renderForBlueLive() throws SoundObjectException {
        String command;
        CsdRenderResult result = CSDRenderService.getDefault().generateCSDForBlueLive(this.data, true);
        String tempCSD = result.getCsdText();
        File temp = FileUtilities.createTempTextFile((String)"tempCsd", (String)".csd", (File)BlueSystem.getCurrentProjectDirectory(), (String)tempCSD);
        String osName = System.getProperty("os.name");
        LiveData liveData = this.data.getLiveData();
        if (liveData.isCommandLineEnabled()) {
            if (liveData.isCommandLineOverride()) {
                command = liveData.getCommandLine();
            } else {
                command = ProjectPropertiesUtil.getRealtimeCommandLine((ProjectProperties)this.data.getProjectProperties());
                command = command + liveData.getCommandLine();
            }
        } else {
            command = ProjectPropertiesUtil.getRealtimeCommandLine((ProjectProperties)this.data.getProjectProperties());
        }
        String[] args = command.split("\\s+");
        String[] args2 = new String[args.length + 1];
        System.arraycopy(args, 0, args2, 0, args.length);
        args2[args.length] = temp.getAbsolutePath();
        this.play(this.data, result, args2, BlueSystem.getCurrentProjectDirectory(), -1.0);
    }

    public void setData(BlueData data) {
        this.data = data;
    }

    public void stop() {
        if (this.runnerThread != null) {
            this.shouldStop = true;
            APIRunnerThread runner = this.runnerThread;
            this.runnerThread = null;
            runner.setKeepRunning(false);
            runner.await();
            Object var1_1 = null;
        }
    }

    public void passToStdin(String text) {
        NoteList nl = null;
        try {
            nl = ScoreUtilities.getNotes((String)text);
        }
        catch (NoteParseException e) {
            e.printStackTrace();
            nl = null;
        }
        if (nl == null) {
            return;
        }
        for (Note note : nl) {
            this.runnerThread.passToStdin(note.toString());
        }
    }

    public void addPlayModeListener(PlayModeListener listener) {
        if (this.listeners == null) {
            this.listeners = new Vector<PlayModeListener>();
        }
        this.listeners.add(listener);
    }

    public void removePlayModeListener(PlayModeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    protected void notifyPlayModeListeners(int playMode) {
        if (this.listeners == null) {
            return;
        }
        for (PlayModeListener listener : this.listeners) {
            listener.playModeChanged(playMode);
        }
    }

    public void playModeChanged(int playMode) {
        if (playMode == 0) {
            if (this.runnerThread != null) {
                this.runnerThread.setKeepRunning(false);
                this.runnerThread = null;
            }
            if (this.data.isLoopRendering() && !this.shouldStop) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            CS6RealtimeRenderService.this.render();
                        }
                        catch (SoundObjectException e) {
                            Exceptions.printStackTrace((Throwable)e);
                            CS6RealtimeRenderService.this.notifyPlayModeListeners(0);
                        }
                    }
                }.start();
            } else {
                this.notifyPlayModeListeners(playMode);
            }
        } else {
            this.notifyPlayModeListeners(playMode);
        }
    }

    public void addBinding(CsoundBinding binding) {
        if (this.isRunning()) {
            binding.setup(this.csound.GetSr(), (long)this.csound.GetKsmps());
        }
        this.bindings.add(binding);
    }

    public void removeBinding(CsoundBinding binding) {
        this.bindings.remove(binding);
        if (this.isRunning()) {
            binding.cleanup();
        }
    }

    static class APIRunnerThread
    implements Runnable {
        private Csound csound;
        private boolean keepRunning = true;
        private PlayModeListener playModeListener;
        private ArrayList parameters;
        private ArrayList<StringChannel> stringChannels;
        private TempoMapper mapper;
        private double startTime;
        private BlueData blueData;
        private double[] valuesCache;
        private CsoundMYFLTArray[] channelPtrCache;
        public boolean isRunning = true;
        CountDownLatch latch = new CountDownLatch(1);
        private final List<CsoundBinding> bindings;

        public APIRunnerThread(BlueData blueData, Csound csound, PlayModeListener playModeListener, ArrayList parameters, ArrayList<StringChannel> stringChannels, TempoMapper mapper, double startTime, List<CsoundBinding> bindings) {
            this.blueData = blueData;
            this.csound = csound;
            this.playModeListener = playModeListener;
            this.parameters = parameters;
            this.stringChannels = stringChannels;
            this.mapper = mapper;
            this.startTime = startTime;
            this.bindings = bindings;
        }

        public void passToStdin(String note) {
            this.csound.InputMessage(note);
        }

        public void setKeepRunning(boolean val) {
            this.keepRunning = val;
        }

        public void await() {
            try {
                this.latch.await();
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        @Override
        public void run() {
            boolean renderUpdatesTime;
            int updateRate = (int)(this.csound.GetKr() / (double)PlaybackSettings.getInstance().getPlaybackFPS());
            int counter = 0;
            RenderTimeManager manager = null;
            boolean bl = renderUpdatesTime = this.startTime >= 0.0;
            if (renderUpdatesTime) {
                manager = (RenderTimeManager)Lookup.getDefault().lookup(RenderTimeManager.class);
                manager.initiateRender(this.startTime);
            }
            double scoreTime = this.csound.GetScoreTime();
            double currentTime = 0.0;
            double renderStartSeconds = 0.0;
            if (renderUpdatesTime) {
                if (this.mapper != null) {
                    renderStartSeconds = this.mapper.beatsToSeconds(this.startTime);
                    currentTime = this.mapper.secondsToBeats(scoreTime + renderStartSeconds);
                } else {
                    currentTime = this.startTime + scoreTime;
                }
            }
            this.createValuesCache(currentTime);
            for (StringChannel strChannel : this.stringChannels) {
                this.csound.SetChannel(strChannel.getChannelName(), strChannel.getValue());
            }
            for (int i = 0; i < this.bindings.size(); ++i) {
                this.bindings.get(i).setup(this.csound.GetSr(), (long)this.csound.GetKsmps());
            }
            while (this.keepRunning) {
                int i;
                scoreTime = this.csound.GetScoreTime();
                if (renderUpdatesTime && ++counter > updateRate) {
                    manager.updateTimePointer(scoreTime);
                    counter = 0;
                }
                currentTime = 0.0;
                if (renderUpdatesTime) {
                    currentTime = this.mapper != null ? this.mapper.secondsToBeats(scoreTime + renderStartSeconds) : this.startTime + scoreTime;
                }
                if (this.blueData != null) {
                    currentTime = this.blueData.getRenderStartTime();
                }
                for (i = 0; i < this.parameters.size(); ++i) {
                    Parameter param = (Parameter)this.parameters.get(i);
                    double value = this.blueData == null ? param.getValue(currentTime) : param.getFixedValue();
                    if (value == this.valuesCache[i]) continue;
                    this.valuesCache[i] = value;
                    this.channelPtrCache[i].SetValue(0, value);
                }
                for (StringChannel strChannel : this.stringChannels) {
                    if (!strChannel.isDirty()) continue;
                    this.csound.SetChannel(strChannel.getChannelName(), strChannel.getValue());
                }
                for (i = 0; i < this.bindings.size(); ++i) {
                    this.bindings.get(i).updateValueToCsound();
                }
                this.keepRunning = this.csound.PerformKsmps() == 0 && this.keepRunning;
                for (i = 0; i < this.bindings.size(); ++i) {
                    this.bindings.get(i).updateValueFromCsound();
                }
            }
            for (int i = 0; i < this.bindings.size(); ++i) {
                this.bindings.get(i).cleanup();
            }
            this.bindings.clear();
            this.csound.Stop();
            this.csound.Cleanup();
            this.csound.SetMessageCallback(null);
            this.csound.Reset();
            if (renderUpdatesTime) {
                manager.endRender();
            }
            this.playModeListener.playModeChanged(0);
            this.latch.countDown();
        }

        private void createValuesCache(double currentTime) {
            int size = this.parameters.size();
            this.valuesCache = new double[size];
            this.channelPtrCache = new CsoundMYFLTArray[size];
            for (int i = 0; i < size; ++i) {
                Parameter param = (Parameter)this.parameters.get(i);
                String varName = param.getCompilationVarName();
                this.valuesCache[i] = this.blueData == null ? param.getValue(currentTime) : param.getFixedValue();
                this.channelPtrCache[i] = new CsoundMYFLTArray(1);
                this.csound.GetChannelPtr(this.channelPtrCache[i].GetPtr(), varName, controlChannelType.CSOUND_CONTROL_CHANNEL.swigValue() | controlChannelType.CSOUND_INPUT_CHANNEL.swigValue());
                this.channelPtrCache[i].SetValue(0, this.valuesCache[i]);
            }
        }
    }
}

