/*
 * Decompiled with CFR 0.152.
 */
package com.kunstmusik.clojureengine;

import clojure.java.api.Clojure;
import clojure.lang.Compiler;
import clojure.lang.DynamicClassLoader;
import clojure.lang.IFn;
import clojure.lang.LineNumberingPushbackReader;
import clojure.lang.RT;
import clojure.lang.Symbol;
import com.kunstmusik.clojureengine.ClojureEngineException;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;

public class ClojureEngine {
    private static final IFn EVAL_FN = Clojure.var((Object)"clojure.core", (Object)"eval");
    private static final IFn READ_FN = Clojure.var((Object)"clojure.core", (Object)"read");
    private static final IFn ASSOC = Clojure.var((Object)"clojure.core", (Object)"assoc");
    private static final IFn IN_NS = Clojure.var((Object)"clojure.core", (Object)"in-ns");
    private static final IFn REFER = Clojure.var((Object)"clojure.core", (Object)"refer");
    private static final IFn INTERN = Clojure.var((Object)"clojure.core", (Object)"intern");
    private static final Object CURRENT_NS_SYM = Clojure.read((String)"*ns*");
    private static final IFn PUSH_THREAD_BINDINGS = Clojure.var((Object)"clojure.core", (Object)"push-thread-bindings");
    private static final IFn POP_THREAD_BINDINGS = Clojure.var((Object)"clojure.core", (Object)"pop-thread-bindings");
    private static final Object EOF = new Object();
    private final Object userNs;
    private Object bindings;
    DynamicClassLoader cl;

    public ClojureEngine(String namespace, File blueUserScriptDir, File blueProjectScriptDir) {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        this.cl = new DynamicClassLoader(old);
        Thread.currentThread().setContextClassLoader((ClassLoader)this.cl);
        this.bindings = RT.map((Object[])new Object[]{Clojure.var((Object)"clojure.core", (Object)"*ns*"), EVAL_FN.invoke(CURRENT_NS_SYM), Compiler.LOADER, this.cl, Clojure.var((Object)"clojure.core", (Object)"*compile-path*"), "classes"});
        PUSH_THREAD_BINDINGS.invoke(this.bindings);
        this.userNs = Clojure.read((String)namespace);
        IN_NS.invoke(this.userNs);
        REFER.invoke(Clojure.read((String)"clojure.core"));
        POP_THREAD_BINDINGS.invoke();
        Thread.currentThread().setContextClassLoader(old);
    }

    public String getNamespace() {
        return this.userNs.toString();
    }

    public Object eval(String code) {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)this.cl);
        PUSH_THREAD_BINDINGS.invoke(this.bindings);
        IN_NS.invoke(this.userNs);
        LineNumberingPushbackReader reader = new LineNumberingPushbackReader((Reader)new StringReader(code));
        Object res = null;
        try {
            Object obj;
            while ((obj = READ_FN.invoke((Object)reader, (Object)false, EOF)) != null && obj != EOF) {
                res = EVAL_FN.invoke(obj);
            }
        }
        catch (RuntimeException e) {
            throw new ClojureEngineException(e, reader.getLineNumber(), reader.getColumnNumber());
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
            POP_THREAD_BINDINGS.invoke();
            Thread.currentThread().setContextClassLoader(old);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intern(Map<String, ? extends Object> values) {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader((ClassLoader)this.cl);
        PUSH_THREAD_BINDINGS.invoke(this.bindings);
        IN_NS.invoke(this.userNs);
        try {
            if (values != null) {
                for (String key : values.keySet()) {
                    INTERN.invoke(this.userNs, (Object)Symbol.create((String)key), values.get(key));
                }
            }
        }
        finally {
            POP_THREAD_BINDINGS.invoke();
            Thread.currentThread().setContextClassLoader(old);
        }
    }
}

