/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.notation;

import blue.soundObject.Note;

public class NotationNote {
    public static final int MIDI = 0;
    public static final int CPS = 1;
    public static final int PCH = 2;
    public static final int OCT = 3;
    public static final int SIXTY_FOURTH = 1;
    public static final int THIRTY_SECOND = 2;
    public static final int SIXTEENTH = 3;
    public static final int EIGHTH = 4;
    public static final int QUARTER = 5;
    public static final int HALF = 6;
    public static final int WHOLE = 7;
    private boolean isRest = false;
    private int accidental = 0;
    private int dots = 0;
    int midiPitch = 60;
    int noteDuration = 5;

    public NotationNote() {
    }

    public NotationNote(NotationNote note) {
        this.isRest = note.isRest;
        this.accidental = note.accidental;
        this.dots = note.dots;
        this.midiPitch = note.midiPitch;
        this.noteDuration = note.noteDuration;
    }

    public int getMidiPitch() {
        return this.midiPitch;
    }

    public void setMidiPitch(int midiPitch) {
        this.midiPitch = midiPitch;
    }

    public int getNoteDuration() {
        return this.noteDuration;
    }

    public void setNoteDuration(int noteDuration) {
        if (noteDuration < 1 || noteDuration > 7) {
            System.err.println("[blue.soundObject.notation.NotationNote :: setNoteDuration()] - Error - invalid note duration : " + noteDuration);
            return;
        }
        this.noteDuration = noteDuration;
    }

    public void increaseDots() {
        ++this.dots;
    }

    public void decreaseDots() {
        if (this.dots > 0) {
            --this.dots;
        }
    }

    public void increaseAccidentals() {
        ++this.accidental;
    }

    public void decreaseAccidentals() {
        if (this.accidental > 0) {
            --this.accidental;
        }
    }

    public Note generateNote(String noteTemplate, int outputType) {
        return null;
    }
}

