/*
 * Decompiled with CFR 0.152.
 */
package blue.util;

import blue.util.ObservableList;
import blue.util.ObservableListEvent;
import blue.util.ObservableListListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ObservableArrayList<T>
extends ArrayList<T>
implements ObservableList<T> {
    private transient List<ObservableListListener<T>> listeners = null;

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        boolean retVal = super.addAll(index, c);
        if (retVal) {
            ArrayList<? extends T> affected = new ArrayList<T>(c);
            ObservableListEvent<? extends T> event = new ObservableListEvent<T>(this, 0, -1, index, index + c.size() - 1, affected);
            super.clear();
            this.fireListChange(event);
        }
        return retVal;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        int index = this.size();
        boolean retVal = super.addAll(c);
        if (retVal) {
            ArrayList<? extends T> affected = new ArrayList<T>(c);
            ObservableListEvent<? extends T> event = new ObservableListEvent<T>(this, 0, -1, index, index + c.size() - 1, affected);
            super.clear();
            this.fireListChange(event);
        }
        return retVal;
    }

    @Override
    public void clear() {
        ArrayList affected = new ArrayList(this);
        ObservableListEvent event = new ObservableListEvent(this, 1, -1, 0, affected.size() - 1, affected);
        super.clear();
        this.fireListChange(event);
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        boolean retVal = super.remove(o);
        if (retVal) {
            ArrayList<Object> affected = new ArrayList<Object>();
            affected.add(o);
            ObservableListEvent event = new ObservableListEvent(this, 1, -1, index, index, affected);
            this.fireListChange(event);
        }
        return retVal;
    }

    @Override
    public T remove(int index) {
        Object retVal = super.remove(index);
        if (retVal != null) {
            ArrayList affected = new ArrayList();
            affected.add(retVal);
            ObservableListEvent event = new ObservableListEvent(this, 1, -1, index, index, affected);
            this.fireListChange(event);
        }
        return (T)retVal;
    }

    @Override
    public void add(int index, T element) {
        super.add(index, element);
        ArrayList<T> affected = new ArrayList<T>();
        affected.add(element);
        ObservableListEvent event = new ObservableListEvent(this, 0, -1, index, index, affected);
        this.fireListChange(event);
    }

    @Override
    public boolean add(T e) {
        int index = this.size();
        boolean retVal = super.add(e);
        ArrayList<T> affected = new ArrayList<T>();
        affected.add(e);
        ObservableListEvent event = new ObservableListEvent(this, 0, -1, index, index, affected);
        this.fireListChange(event);
        return retVal;
    }

    @Override
    public T set(int index, T element) {
        T retVal = super.set(index, element);
        List<T> affected = Collections.singletonList(retVal);
        ObservableListEvent<T> event = new ObservableListEvent<T>(this, 2, 4, index, index, affected);
        this.fireListChange(event);
        return retVal;
    }

    @Override
    public void pushUpItems(int start, int end) {
        Object a = super.remove(start - 1);
        super.add(end, a);
        ObservableListEvent evt = new ObservableListEvent(this, 2, 8, start - 1, end, this.subList(start - 1, end + 1));
        this.fireListChange(evt);
    }

    @Override
    public void pushDownItems(int start, int end) {
        Object a = super.remove(end + 1);
        super.add(start, a);
        ObservableListEvent evt = new ObservableListEvent(this, 2, 16, start, end + 1, this.subList(start, end + 2));
        this.fireListChange(evt);
    }

    @Override
    public void addListener(ObservableListListener<T> listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ObservableListListener<T>>();
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ObservableListListener<T> listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    protected void fireListChange(ObservableListEvent<T> event) {
        if (this.listeners != null) {
            for (ObservableListListener<T> listener : this.listeners) {
                listener.listChanged(event);
            }
        }
    }
}

