/*
 * Decompiled with CFR 0.152.
 */
package blue.jfx.controls;

import blue.jfx.controls.KnobSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.paint.Color;

public class Knob
extends Control {
    StyleableObjectProperty<Color> trackBackgroundColor;
    StyleableObjectProperty<Color> trackColor;
    DoubleProperty value;
    DoubleProperty min = new SimpleDoubleProperty(0.0);
    DoubleProperty max = new SimpleDoubleProperty(1.0);

    public Knob() {
        this.value = new SimpleDoubleProperty(0.0){

            public void set(double newValue) {
                boolean outOfBounds = newValue < Knob.this.getMin() || newValue > Knob.this.getMax();
                super.set(outOfBounds ? this.get() : newValue);
            }
        };
    }

    protected Skin<?> createDefaultSkin() {
        return new KnobSkin(this);
    }

    public void setValue(double value) {
        this.value.set(value);
    }

    public double getValue() {
        return this.value.get();
    }

    public DoubleProperty valueProperty() {
        return this.value;
    }

    public void setMin(double value) {
        this.min.set(value);
    }

    public double getMin() {
        return this.min.get();
    }

    public DoubleProperty minProperty() {
        return this.min;
    }

    public void setMax(Double value) {
        this.max.set(value.doubleValue());
    }

    public Double getMax() {
        return this.max.get();
    }

    public DoubleProperty maxProperty() {
        return this.max;
    }

    public double getRange() {
        return this.getMax() - this.getMin();
    }

    public Color getTrackBackgroundColor() {
        return this.trackBackgroundColor == null ? Color.rgb((int)0, (int)0, (int)0, (double)0.25) : (Color)this.trackBackgroundColor.get();
    }

    public void setTrackBackgroundColor(Color trackBackgroundColor) {
        this.trackBackgroundColorProperty().set((Object)trackBackgroundColor);
    }

    public StyleableObjectProperty<Color> trackBackgroundColorProperty() {
        if (this.trackBackgroundColor == null) {
            this.trackBackgroundColor = new SimpleStyleableObjectProperty(StyleableProperties.TRACK_BACKGROUND_FILL, (Object)this, "trackBackgroundColor", (Object)Color.DARKGRAY);
        }
        return this.trackBackgroundColor;
    }

    public Color getTrackColor() {
        return this.trackColor == null ? Color.rgb((int)63, (int)102, (int)150) : (Color)this.trackColor.get();
    }

    public void setTrackColor(Color trackColor) {
        this.trackColorProperty().set((Object)trackColor);
    }

    public StyleableObjectProperty<Color> trackColorProperty() {
        if (this.trackColor == null) {
            this.trackColor = new SimpleStyleableObjectProperty(StyleableProperties.TRACK_FILL, (Object)this, "trackColor", (Object)Color.DARKGRAY);
        }
        return this.trackColor;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return Knob.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<Knob, Color> TRACK_BACKGROUND_FILL = new CssMetaData<Knob, Color>("-fx-track-background-fill", StyleConverter.getColorConverter(), Color.DARKGRAY){

            public boolean isSettable(Knob control) {
                return control.trackBackgroundColor == null || !control.trackBackgroundColor.isBound();
            }

            public StyleableProperty<Color> getStyleableProperty(Knob control) {
                return control.trackBackgroundColorProperty();
            }
        };
        private static final CssMetaData<Knob, Color> TRACK_FILL = new CssMetaData<Knob, Color>("-fx-track-fill", StyleConverter.getColorConverter(), Color.ALICEBLUE){

            public boolean isSettable(Knob control) {
                return control.trackColor == null || !control.trackColor.isBound();
            }

            public StyleableProperty<Color> getStyleableProperty(Knob control) {
                return control.trackColorProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, TRACK_BACKGROUND_FILL, TRACK_FILL);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

