/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class ReflectionUtils {
    private static final Map<Class<?>, Class<?>> primitiveToWrapperType = new HashMap(8);
    public static final Method OBJECT_EQUALS;
    public static final Method OBJECT_HASHCODE;
    public static final Method OBJECT_TOSTRING;
    public static final Method OBJECT_FINALIZE;

    private ReflectionUtils() {
    }

    public static Method findMethod(Class<?> clazz, String string) {
        return ReflectionUtils.findMethod(clazz, string, null);
    }

    public static Method findMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Method[] methodArray = clazz2.getDeclaredMethods();
            Method method = null;
            for (Method method2 : methodArray) {
                if (Modifier.isPrivate(method2.getModifiers()) || method2.isBridge() || !string.equals(method2.getName())) continue;
                if (classArray == null) {
                    if (method != null) {
                        throw new RuntimeException("Ambiguous name: More than one method are named " + string);
                    }
                    method = method2;
                    continue;
                }
                if (!Arrays.equals(classArray, method2.getParameterTypes())) continue;
                return method2;
            }
            if (method == null) continue;
            return method;
        }
        return null;
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Object ... objectArray) throws NoSuchMethodException {
        Constructor<?> constructor = null;
        for (Constructor<?> constructor2 : clazz.getDeclaredConstructors()) {
            if (!ReflectionUtils.isMatchingConstructor(constructor2, objectArray)) continue;
            if (constructor != null) {
                throw new IllegalArgumentException("Ambiguity in the constructors for " + clazz.getName() + ".");
            }
            constructor = constructor2;
        }
        if (constructor != null) {
            return constructor;
        }
        throw new NoSuchMethodException("Couldn't find constructor for class " + clazz.getName());
    }

    private static boolean isMatchingConstructor(Constructor<?> constructor, Object ... objectArray) {
        if (Modifier.isPrivate(constructor.getModifiers())) {
            return false;
        }
        Class<?>[] classArray = constructor.getParameterTypes();
        if (classArray.length != objectArray.length) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Class<?> clazz = classArray[i];
            if (clazz.isPrimitive()) {
                clazz = ReflectionUtils.wrapPrimitive(clazz);
            }
            if (clazz.isInstance(objectArray[i])) continue;
            return false;
        }
        return true;
    }

    private static Class<?> wrapPrimitive(Class<?> clazz) {
        return primitiveToWrapperType.get(clazz);
    }

    public static Method getDeclaredMethod(Class<?> clazz, String string, Class<?> ... classArray) {
        try {
            return clazz.getDeclaredMethod(string, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }

    static {
        primitiveToWrapperType.put(Boolean.TYPE, Boolean.class);
        primitiveToWrapperType.put(Byte.TYPE, Byte.class);
        primitiveToWrapperType.put(Short.TYPE, Short.class);
        primitiveToWrapperType.put(Character.TYPE, Character.class);
        primitiveToWrapperType.put(Integer.TYPE, Integer.class);
        primitiveToWrapperType.put(Long.TYPE, Long.class);
        primitiveToWrapperType.put(Float.TYPE, Float.class);
        primitiveToWrapperType.put(Double.TYPE, Double.class);
        OBJECT_EQUALS = ReflectionUtils.getDeclaredMethod(Object.class, "equals", Object.class);
        OBJECT_HASHCODE = ReflectionUtils.getDeclaredMethod(Object.class, "hashCode", null);
        OBJECT_TOSTRING = ReflectionUtils.getDeclaredMethod(Object.class, "toString", null);
        OBJECT_FINALIZE = ReflectionUtils.getDeclaredMethod(Object.class, "finalize", null);
    }
}

