/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.afm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fontbox.afm.CharMetric;
import org.apache.fontbox.afm.Composite;
import org.apache.fontbox.afm.KernPair;
import org.apache.fontbox.afm.TrackKern;
import org.apache.fontbox.util.BoundingBox;

public class FontMetrics {
    private float afmVersion;
    private int metricSets = 0;
    private String fontName;
    private String fullName;
    private String familyName;
    private String weight;
    private BoundingBox fontBBox;
    private String fontVersion;
    private String notice;
    private String encodingScheme;
    private int mappingScheme;
    private int escChar;
    private String characterSet;
    private int characters;
    private boolean isBaseFont;
    private float[] vVector;
    private boolean isFixedV;
    private float capHeight;
    private float xHeight;
    private float ascender;
    private float descender;
    private final List<String> comments = new ArrayList<String>();
    private float underlinePosition;
    private float underlineThickness;
    private float italicAngle;
    private float[] charWidth;
    private boolean isFixedPitch;
    private float standardHorizontalWidth;
    private float standardVerticalWidth;
    private List<CharMetric> charMetrics = new ArrayList<CharMetric>();
    private Map<String, CharMetric> charMetricsMap = new HashMap<String, CharMetric>();
    private List<TrackKern> trackKern = new ArrayList<TrackKern>();
    private List<Composite> composites = new ArrayList<Composite>();
    private List<KernPair> kernPairs = new ArrayList<KernPair>();
    private List<KernPair> kernPairs0 = new ArrayList<KernPair>();
    private List<KernPair> kernPairs1 = new ArrayList<KernPair>();

    public float getCharacterWidth(String string) {
        float f = 0.0f;
        CharMetric charMetric = this.charMetricsMap.get(string);
        if (charMetric != null) {
            f = charMetric.getWx();
        }
        return f;
    }

    public float getCharacterHeight(String string) {
        float f = 0.0f;
        CharMetric charMetric = this.charMetricsMap.get(string);
        if (charMetric != null && (f = charMetric.getWy()) == 0.0f) {
            f = charMetric.getBoundingBox().getHeight();
        }
        return f;
    }

    public float getAverageCharacterWidth() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        for (CharMetric charMetric : this.charMetrics) {
            if (!(charMetric.getWx() > 0.0f)) continue;
            f2 += charMetric.getWx();
            f3 += 1.0f;
        }
        if (f2 > 0.0f) {
            f = f2 / f3;
        }
        return f;
    }

    public void addComment(String string) {
        this.comments.add(string);
    }

    public List<String> getComments() {
        return Collections.unmodifiableList(this.comments);
    }

    public float getAFMVersion() {
        return this.afmVersion;
    }

    public int getMetricSets() {
        return this.metricSets;
    }

    public void setAFMVersion(float f) {
        this.afmVersion = f;
    }

    public void setMetricSets(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("The metricSets attribute must be in the set {0,1,2} and not '" + n + "'");
        }
        this.metricSets = n;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String string) {
        this.fontName = string;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String string) {
        this.fullName = string;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public void setFamilyName(String string) {
        this.familyName = string;
    }

    public String getWeight() {
        return this.weight;
    }

    public void setWeight(String string) {
        this.weight = string;
    }

    public BoundingBox getFontBBox() {
        return this.fontBBox;
    }

    public void setFontBBox(BoundingBox boundingBox) {
        this.fontBBox = boundingBox;
    }

    public String getNotice() {
        return this.notice;
    }

    public void setNotice(String string) {
        this.notice = string;
    }

    public String getEncodingScheme() {
        return this.encodingScheme;
    }

    public void setEncodingScheme(String string) {
        this.encodingScheme = string;
    }

    public int getMappingScheme() {
        return this.mappingScheme;
    }

    public void setMappingScheme(int n) {
        this.mappingScheme = n;
    }

    public int getEscChar() {
        return this.escChar;
    }

    public void setEscChar(int n) {
        this.escChar = n;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public void setCharacterSet(String string) {
        this.characterSet = string;
    }

    public int getCharacters() {
        return this.characters;
    }

    public void setCharacters(int n) {
        this.characters = n;
    }

    public boolean isBaseFont() {
        return this.isBaseFont;
    }

    public void setIsBaseFont(boolean bl) {
        this.isBaseFont = bl;
    }

    public float[] getVVector() {
        return this.vVector;
    }

    public void setVVector(float[] fArray) {
        this.vVector = fArray;
    }

    public boolean isFixedV() {
        return this.isFixedV;
    }

    public void setIsFixedV(boolean bl) {
        this.isFixedV = bl;
    }

    public float getCapHeight() {
        return this.capHeight;
    }

    public void setCapHeight(float f) {
        this.capHeight = f;
    }

    public float getXHeight() {
        return this.xHeight;
    }

    public void setXHeight(float f) {
        this.xHeight = f;
    }

    public float getAscender() {
        return this.ascender;
    }

    public void setAscender(float f) {
        this.ascender = f;
    }

    public float getDescender() {
        return this.descender;
    }

    public void setDescender(float f) {
        this.descender = f;
    }

    public String getFontVersion() {
        return this.fontVersion;
    }

    public void setFontVersion(String string) {
        this.fontVersion = string;
    }

    public float getUnderlinePosition() {
        return this.underlinePosition;
    }

    public void setUnderlinePosition(float f) {
        this.underlinePosition = f;
    }

    public float getUnderlineThickness() {
        return this.underlineThickness;
    }

    public void setUnderlineThickness(float f) {
        this.underlineThickness = f;
    }

    public float getItalicAngle() {
        return this.italicAngle;
    }

    public void setItalicAngle(float f) {
        this.italicAngle = f;
    }

    public float[] getCharWidth() {
        return this.charWidth;
    }

    public void setCharWidth(float[] fArray) {
        this.charWidth = fArray;
    }

    public boolean isFixedPitch() {
        return this.isFixedPitch;
    }

    public void setFixedPitch(boolean bl) {
        this.isFixedPitch = bl;
    }

    public List<CharMetric> getCharMetrics() {
        return Collections.unmodifiableList(this.charMetrics);
    }

    public void setCharMetrics(List<CharMetric> list) {
        this.charMetrics = list;
        this.charMetricsMap = new HashMap<String, CharMetric>(this.charMetrics.size());
        for (CharMetric charMetric : list) {
            this.charMetricsMap.put(charMetric.getName(), charMetric);
        }
    }

    public void addCharMetric(CharMetric charMetric) {
        this.charMetrics.add(charMetric);
        this.charMetricsMap.put(charMetric.getName(), charMetric);
    }

    public List<TrackKern> getTrackKern() {
        return Collections.unmodifiableList(this.trackKern);
    }

    public void setTrackKern(List<TrackKern> list) {
        this.trackKern = list;
    }

    public void addTrackKern(TrackKern trackKern) {
        this.trackKern.add(trackKern);
    }

    public List<Composite> getComposites() {
        return Collections.unmodifiableList(this.composites);
    }

    public void setComposites(List<Composite> list) {
        this.composites = list;
    }

    public void addComposite(Composite composite) {
        this.composites.add(composite);
    }

    public List<KernPair> getKernPairs() {
        return Collections.unmodifiableList(this.kernPairs);
    }

    public void addKernPair(KernPair kernPair) {
        this.kernPairs.add(kernPair);
    }

    public void setKernPairs(List<KernPair> list) {
        this.kernPairs = list;
    }

    public List<KernPair> getKernPairs0() {
        return Collections.unmodifiableList(this.kernPairs0);
    }

    public void addKernPair0(KernPair kernPair) {
        this.kernPairs0.add(kernPair);
    }

    public void setKernPairs0(List<KernPair> list) {
        this.kernPairs0 = list;
    }

    public List<KernPair> getKernPairs1() {
        return Collections.unmodifiableList(this.kernPairs1);
    }

    public void addKernPair1(KernPair kernPair) {
        this.kernPairs1.add(kernPair);
    }

    public void setKernPairs1(List<KernPair> list) {
        this.kernPairs1 = list;
    }

    public float getStandardHorizontalWidth() {
        return this.standardHorizontalWidth;
    }

    public void setStandardHorizontalWidth(float f) {
        this.standardHorizontalWidth = f;
    }

    public float getStandardVerticalWidth() {
        return this.standardVerticalWidth;
    }

    public void setStandardVerticalWidth(float f) {
        this.standardVerticalWidth = f;
    }
}

